/*
 * Decompiled with CFR 0.152.
 */
package oracle.viz.util.color;

import java.awt.Color;

public class ColorBand {
    static final int SKYBLUE = 0;
    static final int GREEN = 1;
    static final int ORANGE = 2;
    static final int YELLOW = 3;
    static final int PURPLE = 4;
    static final int PINK = 5;
    static final int AQUA = 6;
    static final int RED = 7;
    static final int OCEANBLUE = 8;
    public static float[][] BrightnessBandParams = new float[][]{{0.575f, 0.8f}, {0.325f, 0.6f}, {0.1f, 1.0f}, {0.15f, 0.8f}, {0.75f, 0.6f}, {0.9f, 0.6f}, {0.45f, 0.6f}, {0.0f, 0.8f}, {0.625f, 0.6f}};

    public static Color[] setBrightnessBands(int numColors, float hue, float saturation) {
        Color[] c = ColorBand.setBrightnessBands(numColors, hue, saturation, 0.4f);
        return c;
    }

    public static Color[] setBrightnessBands(int numColors, float hue, float saturation, float brightMin) {
        float brightStep;
        if (numColors < 1) {
            return null;
        }
        Color[] c = new Color[numColors];
        if ((double)brightMin > 1.0 || (double)brightMin < 0.0) {
            brightMin = 0.4f;
        }
        if (numColors <= 1) {
            brightStep = 0.0f;
            brightMin = 1.0f;
        } else {
            brightStep = (float)((1.0 - (double)brightMin) / (double)(numColors - 1));
        }
        int k = 0;
        int i = 0;
        while (i < numColors) {
            float brightness = brightMin + (float)k * brightStep;
            c[k] = Color.getHSBColor(hue, saturation, brightness);
            ++k;
            ++i;
        }
        return c;
    }

    public static Color[] setHueBands(int numColors, float saturation, float brightness) {
        if (numColors < 1) {
            return null;
        }
        Color[] c = new Color[numColors];
        float step = (float)(1.0 / (double)c.length);
        int k = 0;
        while (k < numColors) {
            float hue = step * (float)k;
            c[k] = Color.getHSBColor(hue, saturation, brightness);
            ++k;
        }
        return c;
    }
}

