/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.io;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import oracle.charts.axischart.GanttTaskTree;
import oracle.charts.io.StringParser;
import oracle.charts.types.TaskDesc;
import oracle.charts.types.TaskLink;
import oracle.viz.util.DFTreeIterator;

public class GanttLoader {
    static final String[] topKeywords = new String[]{"TITLE", "SUBTITLE", "CH_WIDTH", "CH_HEIGHT", "CH_DEPTH", "START_DATE", "END_DATE", "TASK", "SUB", "END", "LINK", "COMPLETION", "BK_COLOR", "STYLE", "REPEAT", "RESOURCE", "INCLUDE"};
    static final int TITLE = 0;
    static final int SUBTITLE = 1;
    static final int CH_WIDTH = 2;
    static final int CH_HEIGHT = 3;
    static final int CH_DEPTH = 4;
    static final int START_DATE = 5;
    static final int END_DATE = 6;
    static final int TASK = 7;
    static final int SUB = 8;
    static final int END = 9;
    static final int LINK = 10;
    static final int COMPLETION = 11;
    static final int BK_COLOR = 12;
    static final int STYLE = 13;
    static final int REPEAT = 14;
    static final int RESOURCE = 15;
    static final int INCLUDE = 16;
    static final String[] linkKeywords = new String[]{"FINISH_PRE_START", "FINISH_PRE_FINISH", "START_PRE_START", "START_PRE_FINISH", "FPS", "FPF", "SPS", "SPF"};
    static final int[] linkTypeMap = new int[]{1, 1, 1, 1, 1, 1, 1, 1};
    static final String[] styleKeywords = new String[]{"NORMAL_TASK", "MILESTONE", "TASK_GROUP"};
    static final String[] colorKeywords = new String[]{"BLACK", "BLUE", "CYAN", "DARKGRAY", "GRAY", "GREEN", "LIGHTGRAY", "MAGENTA", "ORANGE", "PINK", "RED", "WHITE", "YELLOW", ""};
    static final Color[] colorMap = new Color[]{Color.black, Color.blue, Color.cyan, Color.darkGray, Color.gray, Color.green, Color.lightGray, Color.magenta, Color.orange, Color.pink, Color.red, Color.white, Color.yellow, null};

    public static void main(String[] args) {
        if (args[0].equals("map")) {
            TreeMap tmap = GanttLoader.TestFileNames(args[1]);
            Iterator iter = tmap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                System.out.println("Found: " + entry.getKey() + " = " + entry.getValue());
            }
        } else if (args[0].equals("load")) {
            GanttChartDesc test = new GanttChartDesc();
            GanttLoader.LoadData(args[1], test);
            System.out.println(test);
        }
    }

    public static TreeMap TestFileNames(String masterFileName) {
        BufferedReader fileReader = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(masterFileName);
            fileReader = new BufferedReader(new InputStreamReader(fis));
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
        TreeMap<Integer, String> tmap = new TreeMap<Integer, String>();
        try {
            String line = null;
            while (null != (line = GanttLoader.getDataLine(fileReader))) {
                StringParser parser = new StringParser(line);
                int testId = parser.skip().nextInteger();
                String testFile = parser.skip().nextToken();
                tmap.put(new Integer(testId), testFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        fileReader = null;
        try {
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return tmap;
    }

    public static boolean LoadData(String dataFileName, GanttChartDesc GanttChartDesc2) {
        BufferedReader fileReader = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(dataFileName);
            fileReader = new BufferedReader(new InputStreamReader(fis));
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        if (null == GanttChartDesc2.tasks) {
            GanttChartDesc2.tasks = new GanttTaskTree();
            GanttChartDesc2.iter = GanttChartDesc2.tasks.viewIterator(Integer.MAX_VALUE);
        }
        if (null == GanttChartDesc2.fileName) {
            GanttChartDesc2.fileName = dataFileName;
        }
        String line = null;
        int lineType = -1;
        try {
            while (null != (line = GanttLoader.getDataLine(fileReader))) {
                StringParser parser = new StringParser(line);
                parser.skip();
                lineType = -1;
                try {
                    lineType = parser.nextPattern(topKeywords);
                }
                catch (Exception e) {
                    throw new Exception("Illegal keyword: " + parser.nextToken());
                }
                TaskDesc task = null;
                switch (lineType) {
                    case 0: {
                        GanttChartDesc2.title = parser.skip().nextGroup("\"");
                        break;
                    }
                    case 1: {
                        File file = new File(GanttChartDesc2.fileName);
                        GanttChartDesc2.subTitle = parser.skip().nextGroup("\"") + " (" + file.getName() + ")";
                        break;
                    }
                    case 2: {
                        GanttChartDesc2.width = parser.skip().nextInteger();
                        break;
                    }
                    case 3: {
                        GanttChartDesc2.height = parser.skip().nextInteger();
                        break;
                    }
                    case 4: {
                        parser.skip();
                        if (0 == parser.nextPattern(new String[]{"MAX_DEPTH", ""})) {
                            GanttChartDesc2.depth = Integer.MAX_VALUE;
                            break;
                        }
                        GanttChartDesc2.depth = parser.nextInteger();
                        break;
                    }
                    case 5: {
                        GanttChartDesc2.startDate = GanttLoader.GetDate(parser);
                        break;
                    }
                    case 6: {
                        GanttChartDesc2.endDate = GanttLoader.GetDate(parser);
                        break;
                    }
                    case 7: {
                        GanttLoader.MakeTask(parser, GanttChartDesc2);
                        break;
                    }
                    case 8: {
                        GanttChartDesc2.down = true;
                        break;
                    }
                    case 9: {
                        if (!GanttChartDesc2.down) {
                            GanttChartDesc2.iter.up();
                        }
                        GanttChartDesc2.down = false;
                        break;
                    }
                    case 10: {
                        GanttLoader.MakeLink(parser, GanttChartDesc2);
                        break;
                    }
                    case 11: {
                        task = GanttChartDesc2.tasks.getTaskDesc(parser.skip().nextLong());
                        task.setCompletion(parser.skip().nextFloat() / 100.0f);
                        break;
                    }
                    case 12: {
                        task = GanttChartDesc2.tasks.getTaskDesc(parser.skip().nextLong());
                        task.setBackground(GanttLoader.GetColor(parser));
                        break;
                    }
                    case 13: {
                        task = GanttChartDesc2.tasks.getTaskDesc(parser.skip().nextLong());
                        task.setTaskStyle(parser.skip().nextPattern(styleKeywords));
                        break;
                    }
                    case 14: {
                        task = GanttChartDesc2.tasks.getTaskDesc(parser.skip().nextLong());
                        long rptID = parser.skip().nextLong();
                        java.util.Date start = GanttLoader.GetDate(parser);
                        java.util.Date end = GanttLoader.GetDate(parser);
                        task.addRepeat(rptID, start, end);
                        break;
                    }
                    case 15: {
                        System.out.println("Warning on: '" + line + "'");
                        System.out.println("RESOURCE keyword not supported");
                        break;
                    }
                    case 16: {
                        GanttLoader.LoadData(parser.skip().nextToken(), GanttChartDesc2);
                        break;
                    }
                    default: {
                        throw new Exception("Illegal keyword: " + parser.nextToken());
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error while processing: '" + line + "'");
            if (lineType != -1) {
                System.out.println("Couldn't parse arguments for keyword '" + topKeywords[lineType] + "'");
            }
            e.printStackTrace(System.out);
            return false;
        }
        fileReader = null;
        try {
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return true;
    }

    static String getDataLine(BufferedReader reader) {
        String result = null;
        try {
            while (null != (result = reader.readLine())) {
                int comment = result.indexOf("//");
                if (comment >= 0) {
                    result = result.substring(0, comment);
                }
                result.trim();
                if (result.length() == 0) continue;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return result;
    }

    static java.util.Date GetDate(StringParser parser) throws Exception {
        String str = parser.skip().nextGroup("\"");
        if (str.indexOf(58) != -1) {
            return Timestamp.valueOf(str);
        }
        return Date.valueOf(str);
    }

    static Color GetColor(StringParser parser) throws Exception {
        try {
            int colorId = parser.skip().nextPattern(colorKeywords);
            Color color = colorMap[colorId];
            if (null == color) {
                int r = parser.skip().nextInteger();
                int g = parser.skip().nextInteger();
                int b = parser.skip().nextInteger();
                color = new Color(r, g, b);
            }
            return color;
        }
        catch (Exception e) {
            throw new Exception("Invalid color spec: '" + parser.getData() + "'");
        }
    }

    static void MakeTask(StringParser parser, GanttChartDesc GanttChartDesc2) throws Exception {
        try {
            long taskID = parser.skip().nextLong();
            String label = parser.skip().nextGroup("\"");
            java.util.Date start = GanttLoader.GetDate(parser);
            java.util.Date end = GanttLoader.GetDate(parser);
            TaskDesc task = new TaskDesc(taskID, label, start, end);
            if (GanttChartDesc2.down) {
                GanttChartDesc2.iter.addChild(task);
                GanttChartDesc2.iter.next();
                GanttChartDesc2.down = false;
            } else {
                GanttChartDesc2.iter.add(task);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new Exception("Invalid task spec: '" + parser.getData() + "'");
        }
    }

    /*
     * Unable to fully structure code
     */
    static void MakeLink(StringParser parser, GanttChartDesc GanttChartDesc) throws Exception {
        try {
            type = parser.skip().nextPattern(GanttLoader.linkKeywords);
            syntaxError = false;
            try {
                from = parser.skip().nextGroup();
                to = parser.skip().nextGroup();
                vec = new Vector<Long>();
                idParser = new StringParser(from);
                try {
                    while (true) {
                        vec.add(new Long(idParser.skip().nextLong()));
                    }
                }
                catch (Exception e) {
                    srcs = new long[vec.size()];
                    i = 0;
                    ** while (i < vec.size())
                }
lbl-1000:
                // 1 sources

                {
                    srcs[i] = (Long)vec.get(i);
                    ++i;
                    continue;
                }
lbl21:
                // 1 sources

                vec.clear();
                idParser = new StringParser(to);
                try {
                    while (true) {
                        vec.add(new Long(idParser.skip().nextLong()));
                    }
                }
                catch (Exception e) {
                    sinks = new long[vec.size()];
                    i = 0;
                    ** while (i < vec.size())
                }
lbl-1000:
                // 1 sources

                {
                    sinks[i] = (Long)vec.get(i);
                    ++i;
                    continue;
                }
lbl35:
                // 1 sources

                if (0 == srcs.length || 0 == sinks.length) {
                    syntaxError = true;
                    throw new Exception();
                }
                link = new TaskLink(GanttLoader.linkTypeMap[type], srcs, sinks);
                GanttChartDesc.tasks.setDependency(link);
                return;
            }
            catch (Exception e) {
                if (syntaxError) {
                    throw e;
                }
                fromId = parser.skip().nextLong();
                toId = parser.skip().nextLong();
                link = new TaskLink(GanttLoader.linkTypeMap[type], fromId, toId);
                GanttChartDesc.tasks.setDependency(link);
            }
        }
        catch (Exception e) {
            throw new Exception("Invalid link spec: '" + parser.getData() + "'");
        }
    }

    public static class GanttChartDesc {
        public int width = -1;
        public int height = -1;
        public int depth = -1;
        public String title = null;
        public String subTitle = null;
        public java.util.Date startDate = null;
        public java.util.Date endDate = null;
        public GanttTaskTree tasks = null;
        String fileName = null;
        boolean down = false;
        DFTreeIterator iter = null;

        public String toString() {
            String result = "File " + this.fileName + ": " + "'" + this.title + "' ('" + this.subTitle + "') " + this.width + "w by " + this.height + "h pixels, ";
            result = this.depth == Integer.MAX_VALUE ? result + "max depth" : result + "depth " + this.depth;
            result = result + ", from " + this.startDate + " to " + this.endDate + ". Tasks:\n" + this.tasks;
            return result;
        }
    }
}

