/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.internal;

import java.util.Vector;

public final class SliceLabelBreak {
    boolean test = false;
    String pieLabel;
    String SeparateLineChars = "";
    Vector[] SliceLabelPermutations;
    Vector[] SliceLabelBest;
    int[] labelBlockWidthIndex;
    int numDelimiters = 0;
    int numPermutations = 0;
    char[] Delimiters = new char[]{' '};
    int[] indexOfDelimiters;
    boolean lastWordNewline = false;

    public SliceLabelBreak(String label) {
        this.pieLabel = label.trim();
    }

    public Vector getLabel(int index) {
        return this.SliceLabelBest[index];
    }

    public int getNumDelimiters() {
        return this.numDelimiters;
    }

    void setLabel(String label) {
        this.pieLabel = label.trim();
    }

    public void setDelimiters(char[] delimiters) {
        this.Delimiters = delimiters;
    }

    int countDelimiters() {
        int numDelimiters = 0;
        int k = 0;
        int s = 0;
        while (s < this.Delimiters.length) {
            k = 0;
            while (k != -1) {
                if ((k = this.pieLabel.indexOf(this.Delimiters[s], k)) == -1) continue;
                ++k;
                ++numDelimiters;
            }
            ++s;
        }
        if (numDelimiters == 0) {
            return numDelimiters;
        }
        this.indexOfDelimiters = new int[numDelimiters];
        numDelimiters = 0;
        int[] kIndex = new int[this.Delimiters.length];
        s = 0;
        while (s < this.Delimiters.length) {
            kIndex[s] = 0;
            ++s;
        }
        s = 0;
        while (s < this.Delimiters.length) {
            kIndex[s] = this.pieLabel.indexOf(this.Delimiters[s], kIndex[s]);
            ++s;
        }
        while (true) {
            int smallestIndex = 1000;
            int smallestDelimiter = -1;
            s = 0;
            while (s < this.Delimiters.length) {
                if (kIndex[s] != -1 && kIndex[s] < smallestIndex) {
                    smallestIndex = kIndex[s];
                    smallestDelimiter = s;
                }
                ++s;
            }
            if (smallestDelimiter == -1) break;
            this.indexOfDelimiters[numDelimiters] = smallestIndex;
            kIndex[smallestDelimiter] = this.pieLabel.indexOf(this.Delimiters[smallestDelimiter], smallestIndex + 1);
            ++numDelimiters;
        }
        return numDelimiters;
    }

    public void setLastWordNewline() {
        this.lastWordNewline = true;
    }

    void rank() {
        this.labelBlockWidthIndex = new int[this.numDelimiters];
        int[] minBlockWidth = new int[this.numDelimiters];
        int i = 0;
        while (i < this.numDelimiters) {
            minBlockWidth[i] = Integer.MAX_VALUE;
            this.labelBlockWidthIndex[i] = -1;
            ++i;
        }
        if (this.test) {
            System.out.println("numPerm " + this.numPermutations);
        }
        i = 0;
        while (i < this.numPermutations - 1) {
            if (this.test) {
                System.out.println("i = " + i);
                this.dump(i);
            }
            if (this.lastWordNewline && this.isLastWordNewline(i) || !this.lastWordNewline) {
                if (this.isSpecialCharCompliant(this.SliceLabelPermutations[i])) {
                    int index = this.SliceLabelPermutations[i].size() - 2;
                    int phraseWidth = this.getWidth(this.SliceLabelPermutations[i]);
                    if (phraseWidth < minBlockWidth[index]) {
                        this.labelBlockWidthIndex[index] = i;
                        minBlockWidth[index] = phraseWidth;
                    }
                } else if (this.test) {
                    System.out.println("Not Compliant");
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.numDelimiters) {
            if (this.labelBlockWidthIndex[i] > -1) {
                this.SliceLabelBest[i] = this.SliceLabelPermutations[this.labelBlockWidthIndex[i]];
                if (this.test) {
                    System.out.println("assign " + this.labelBlockWidthIndex[i]);
                }
                if (this.test) {
                    System.out.println("assign " + this.SliceLabelBest[i]);
                }
            } else {
                this.SliceLabelBest[i] = null;
            }
            ++i;
        }
    }

    boolean isLastWordNewline(int counter) {
        return counter % 2 == 0;
    }

    int getWidth(Vector p) {
        int maxStringLength = 0;
        int i = 0;
        while (i < p.size()) {
            String s = (String)p.elementAt(i);
            if (s.length() > maxStringLength) {
                maxStringLength = s.length();
            }
            ++i;
        }
        return maxStringLength;
    }

    boolean isSpecialCharCompliant(Vector p) {
        if (this.SeparateLineChars.length() == 0) {
            return true;
        }
        boolean maxStringLength = false;
        int i = 0;
        while (i < p.size()) {
            String s = (String)p.elementAt(i);
            if (this.containsDelimiters(s)) {
                int j = 0;
                while (j < this.SeparateLineChars.length()) {
                    if (s.indexOf(this.SeparateLineChars.charAt(j)) > -1) {
                        return false;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean containsDelimiters(String str) {
        int s = 0;
        while (s < this.Delimiters.length) {
            if (str.indexOf(this.Delimiters[s]) > -1) {
                return true;
            }
            ++s;
        }
        return false;
    }

    void increment(int[] counter) {
        int digits = counter.length;
        if (counter.length == 0) {
            return;
        }
        int last_digit = digits - 1;
        counter[last_digit] = (counter[last_digit] + 1) % 2;
        int i = last_digit - 1;
        while (i >= 0) {
            if (counter[i + 1] != 0) {
                return;
            }
            counter[i] = (counter[i] + 1) % 2;
            --i;
        }
    }

    void printCounter(int[] counter) {
        System.out.print("Counter [");
        int i = 0;
        while (i < counter.length) {
            System.out.print(counter[i]);
            ++i;
        }
        System.out.println("]");
    }

    public void printBestSliceLabel() {
        System.out.println("Best Slice Label: ");
        int i = 0;
        while (i < this.labelBlockWidthIndex.length) {
            System.out.print("(" + (i + 2) + ", " + this.labelBlockWidthIndex[i] + ")");
            ++i;
        }
        System.out.println("");
    }

    public void dump(int index) {
        int i = 0;
        while (i < this.SliceLabelPermutations[index].size()) {
            String s = (String)this.SliceLabelPermutations[index].elementAt(i);
            System.out.println(s);
            ++i;
        }
        System.out.println();
    }

    public void init(String SeparateLineChars) {
        this.SeparateLineChars = SeparateLineChars;
        this.numDelimiters = this.countDelimiters();
        int[] counter = new int[this.numDelimiters];
        int i = 0;
        while (i < this.numDelimiters) {
            counter[i] = 0;
            ++i;
        }
        this.numPermutations = (int)Math.pow(2.0, this.numDelimiters);
        this.SliceLabelPermutations = new Vector[this.numPermutations];
        this.SliceLabelBest = new Vector[this.numDelimiters];
        i = 0;
        while (i < this.numPermutations - 1) {
            this.SliceLabelPermutations[i] = new Vector();
            this.increment(counter);
            int digits = counter.length;
            int lastIndex = 0;
            int j = 0;
            while (j < digits) {
                if (counter[j] == 1) {
                    String word = new String(this.pieLabel.substring(lastIndex, this.indexOfDelimiters[j] + 1));
                    word = word.trim();
                    this.SliceLabelPermutations[i].addElement(word);
                    lastIndex = this.indexOfDelimiters[j] + 1;
                }
                ++j;
            }
            this.SliceLabelPermutations[i].addElement(new String(this.pieLabel.substring(lastIndex)));
            ++i;
        }
        this.rank();
    }
}

