/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.axischart.internal;

import java.awt.FontMetrics;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.text.AttributedString;
import oracle.charts.types.StringAxisDesc;

public final class LabelUtil {
    public static AttributedString getStringLabelAttributedString(String s, StringAxisDesc sd) {
        AttributedString attrStr = null;
        if (sd.getTextAttributes() != null) {
            attrStr = new AttributedString(s, sd.getTextAttributes());
        }
        return attrStr;
    }

    public static int getStringLabelWidth(String s, StringAxisDesc sd, FontRenderContext frc, FontMetrics fm) {
        int currentLabelWidth = 0;
        if (s != null) {
            AttributedString attrStr = LabelUtil.getStringLabelAttributedString(s, sd);
            if (attrStr == null) {
                currentLabelWidth = fm.stringWidth(s);
            } else {
                TextLayout layout = new TextLayout(attrStr.getIterator(), frc);
                currentLabelWidth = (int)Math.round(layout.getBounds().getWidth());
            }
        }
        return currentLabelWidth;
    }

    public static int getStringLabelHeight(String s, StringAxisDesc sd, FontRenderContext frc, FontMetrics fm) {
        int currentLabelHeight = 0;
        if (s != null) {
            AttributedString attrStr = LabelUtil.getStringLabelAttributedString(s, sd);
            if (attrStr == null) {
                currentLabelHeight = fm.getHeight();
            } else {
                TextLayout layout = new TextLayout(attrStr.getIterator(), frc);
                currentLabelHeight = Math.round(layout.getAscent() + layout.getDescent());
            }
        }
        return currentLabelHeight;
    }
}

