/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.axischart.internal;

import java.awt.Color;
import java.awt.Graphics2D;
import oracle.charts.axischart.internal.Effect3D;

public final class DropShadow {
    public boolean effect3D = false;
    public final int SideShadowDelta = 3;
    public final int TopShadowDelta = 3;
    public final int Side3DDeltaAdjust = 2;
    public final int SideShadowDeltaAdjust = 1;
    int sideShadowDelta = 3;
    int topShadowDelta = 3;
    Color Gray102 = new Color(102, 102, 102);
    Color Gray153 = new Color(153, 153, 153);
    Color Gray51 = new Color(51, 51, 51);
    boolean shortWidth = false;
    boolean mediumWidth = false;

    public void DropShadow() {
    }

    public void setShadowWidthThreshold(double barWidth) {
        this.sideShadowDelta = 3;
        this.topShadowDelta = 3;
        if (!this.effect3D) {
            this.sideShadowDelta = 2;
            this.topShadowDelta = 1;
        }
        if (this.effect3D) {
            if (barWidth <= 2.0) {
                this.sideShadowDelta = 1;
                this.topShadowDelta = 1;
                this.shortWidth = true;
            } else if (barWidth <= 7.0) {
                this.sideShadowDelta = 2;
                this.topShadowDelta = 2;
                this.mediumWidth = true;
            }
        } else if (barWidth <= 4.0) {
            this.sideShadowDelta = 1;
            this.topShadowDelta = 1;
            this.shortWidth = true;
        } else if (barWidth <= 7.0) {
            this.sideShadowDelta = 2;
            this.topShadowDelta = 1;
        }
    }

    protected void setShadowHeightThreshold(int barHeight) {
        if (this.effect3D) {
            if (barHeight <= 1) {
                this.topShadowDelta = 0;
                this.sideShadowDelta = 1;
            } else if (barHeight <= 5) {
                this.topShadowDelta = 2;
                if (this.sideShadowDelta > 2) {
                    this.sideShadowDelta = 2;
                }
            }
        } else if (barHeight <= 1) {
            this.topShadowDelta = 0;
            this.sideShadowDelta = 1;
        } else if (barHeight <= 10) {
            this.topShadowDelta = 1;
            if (this.sideShadowDelta > 2) {
                this.sideShadowDelta = 2;
            }
        }
    }

    public void drawShadow(Graphics2D g2, Color barColor, Effect3D shadowColors, int x, int y, double barWidth, int barHeight, boolean positive, boolean firstPass, boolean topBar, boolean bottomBar, int maxStackHeight) {
        int[] yShadow;
        int[] xShadow;
        this.setShadowWidthThreshold(barWidth);
        if (maxStackHeight > 0) {
            this.setShadowHeightThreshold(maxStackHeight);
        } else {
            this.setShadowHeightThreshold(barHeight);
        }
        if (this.effect3D && topBar) {
            xShadow = new int[4];
            yShadow = new int[4];
            if (positive) {
                xShadow[0] = x;
                xShadow[1] = x + this.sideShadowDelta;
                xShadow[2] = x + this.sideShadowDelta + (int)barWidth;
                xShadow[3] = x + (int)barWidth;
                yShadow[0] = y;
                yShadow[1] = y - this.topShadowDelta;
                yShadow[2] = yShadow[1];
                yShadow[3] = yShadow[0];
            }
            if (positive) {
                g2.setColor(shadowColors.topFillColor);
                g2.fillPolygon(xShadow, yShadow, 4);
                if (this.shortWidth || this.mediumWidth) {
                    g2.setColor(shadowColors.topFillColor);
                } else {
                    g2.setColor(shadowColors.topLineColor);
                }
                g2.drawPolygon(xShadow, yShadow, 4);
            }
            if (!positive) {
                // empty if block
            }
        }
        int xBarRightSide = x + (int)barWidth;
        int xShadowRightSide = xBarRightSide + this.sideShadowDelta;
        xShadow = new int[4];
        yShadow = new int[4];
        if (positive) {
            xShadow[0] = xBarRightSide;
            xShadow[1] = xBarRightSide;
            xShadow[2] = xShadowRightSide;
            xShadow[3] = xShadowRightSide;
            if (this.effect3D) {
                yShadow[0] = y + barHeight;
                yShadow[1] = y;
                yShadow[2] = y - this.topShadowDelta;
                yShadow[3] = y + barHeight;
                if (!bottomBar) {
                    yShadow[3] = y + barHeight - this.topShadowDelta;
                }
            } else {
                yShadow[0] = y + barHeight;
                yShadow[3] = y + barHeight;
                if (topBar) {
                    yShadow[1] = y + this.topShadowDelta;
                    yShadow[2] = y + this.topShadowDelta;
                } else {
                    yShadow[1] = y;
                    yShadow[2] = y;
                }
            }
        } else {
            xShadow[0] = xShadowRightSide;
            xShadow[1] = xShadowRightSide;
            xShadow[2] = xBarRightSide;
            xShadow[3] = xBarRightSide;
            if (this.effect3D) {
                yShadow[0] = y;
                yShadow[1] = y + barHeight - this.topShadowDelta - 1;
                yShadow[2] = y + barHeight - 1;
                yShadow[3] = y;
                if (!bottomBar) {
                    yShadow[0] = y - this.topShadowDelta;
                    yShadow[3] = yShadow[3] - 1;
                }
            } else {
                yShadow[0] = y;
                yShadow[3] = y;
                if (topBar) {
                    yShadow[1] = y + barHeight - this.topShadowDelta;
                    yShadow[2] = y + barHeight - this.topShadowDelta;
                } else {
                    yShadow[1] = y + barHeight;
                    yShadow[2] = y + barHeight;
                }
            }
        }
        if (firstPass) {
            g2.setColor(shadowColors.sideFillColor);
            g2.fillPolygon(xShadow, yShadow, 4);
        }
        int ys0 = yShadow[0];
        int ys3 = yShadow[3];
        if (positive) {
            ys0 = yShadow[0] - 1;
            ys3 = yShadow[3] - 1;
        }
        if (this.effect3D) {
            g2.setColor(shadowColors.sideFillColor);
            g2.drawLine(xShadow[0], ys0, xShadow[1], yShadow[1]);
            g2.drawLine(xShadow[2], yShadow[2], xShadow[3], ys3);
            if (topBar) {
                g2.drawLine(xShadow[1], yShadow[1], xShadow[2], yShadow[2]);
            }
        }
    }

    public void drawShadowHorizontal(Graphics2D g2, Color barColor, Effect3D shadowColors, int x, int y, int barLength, int barWidth, boolean positive, boolean topBar, boolean bottomBar) {
        this.setShadowWidthThreshold(barWidth);
        this.setShadowHeightThreshold(barLength);
        int[] xShadow = new int[4];
        int[] yShadow = new int[4];
        if (positive) {
            if (this.effect3D) {
                xShadow[0] = x;
                xShadow[1] = x + this.topShadowDelta + barLength;
                xShadow[2] = x + barLength;
                xShadow[3] = x - 1;
                if (!bottomBar) {
                    xShadow[0] = x + this.topShadowDelta;
                }
                yShadow[0] = y - this.sideShadowDelta;
                yShadow[1] = y - this.sideShadowDelta;
                yShadow[2] = y;
                yShadow[3] = y;
            } else {
                xShadow[0] = x;
                xShadow[1] = x - this.topShadowDelta + barLength;
                xShadow[2] = x - this.topShadowDelta + barLength;
                xShadow[3] = x;
                if (!bottomBar) {
                    xShadow[0] = x - this.topShadowDelta;
                    xShadow[3] = x - this.topShadowDelta;
                }
                yShadow[0] = y + barWidth + this.sideShadowDelta;
                yShadow[1] = y + barWidth + this.sideShadowDelta;
                yShadow[2] = y + barWidth;
                yShadow[3] = y + barWidth;
            }
        } else if (this.effect3D) {
            xShadow[0] = x + barLength;
            if (!bottomBar) {
                xShadow[0] = x + barLength + this.topShadowDelta;
            }
            xShadow[1] = x + this.topShadowDelta;
            xShadow[2] = x - 1;
            xShadow[3] = x + barLength - 1;
            yShadow[0] = y - this.sideShadowDelta;
            yShadow[1] = y - this.sideShadowDelta;
            yShadow[2] = y;
            yShadow[3] = y;
        } else {
            xShadow[0] = x + barLength;
            xShadow[1] = x + this.topShadowDelta;
            xShadow[2] = x + this.topShadowDelta;
            xShadow[3] = x + barLength;
            yShadow[0] = y + barWidth + this.sideShadowDelta;
            yShadow[1] = y + barWidth + this.sideShadowDelta;
            yShadow[2] = y + barWidth;
            yShadow[3] = y + barWidth;
        }
        if (this.effect3D) {
            g2.setColor(shadowColors.topFillColor);
        } else {
            g2.setColor(shadowColors.sideFillColor);
        }
        g2.fillPolygon(xShadow, yShadow, 4);
        boolean outline = false;
        if (outline && this.effect3D && !this.shortWidth) {
            g2.setColor(shadowColors.topFillColor);
            if (bottomBar) {
                if (!positive) {
                    xShadow[0] = xShadow[0] - 1;
                    xShadow[3] = xShadow[3] - 1;
                }
                if (positive) {
                    xShadow[3] = xShadow[3] + 1;
                }
            }
            g2.drawPolyline(xShadow, yShadow, 4);
        }
        xShadow = new int[4];
        yShadow = new int[4];
        if (this.effect3D && topBar) {
            int xBarRightSide = x + barLength;
            int xShadowRightSide = xBarRightSide + this.topShadowDelta;
            int xBarLeftSide = x;
            int xShadowLeftSide = x - this.topShadowDelta;
            if (positive) {
                xShadow[0] = xBarRightSide;
                xShadow[1] = xBarRightSide;
                xShadow[2] = xShadowRightSide;
                xShadow[3] = xShadowRightSide;
                yShadow[0] = y + barWidth - 1;
                yShadow[1] = y;
                yShadow[2] = y - this.sideShadowDelta;
                yShadow[3] = y + barWidth - this.sideShadowDelta - 1;
            }
            if (positive) {
                g2.setColor(shadowColors.sideFillColor);
                g2.fillPolygon(xShadow, yShadow, 4);
                boolean outline2 = false;
                if (outline2 && !this.shortWidth) {
                    g2.setColor(shadowColors.sideLineColor);
                    g2.drawPolygon(xShadow, yShadow, 4);
                }
            }
        }
    }
}

