/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.macros;

import oracle.ide.util.Namespace;
import oracle.ideimpl.macros.MacroDefinitions;
import oracle.ideimpl.macros.Scope;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public class MacroDefinition
extends HashStructureAdapter {
    public static final String DATA_KEY = "oracle.ideimpl.macros.MacroDefinition";
    public static final String NAME = "MACRO_NAME";
    public static final String DESCRIPTION = "MACRO_DESCRIPTION";
    public static final String VALUE = "MACRO_VALUE";
    public static final String QUALIFIER = "MACRO_QUALIFIER";
    public static final String SCOPE = "MACRO_SCOPE";
    public static final String IS_LOCATION = "MACRO_IS_LOCATION";
    public static final String IS_CUSTOM = "MACRO_IS_CUSTOM";

    public MacroDefinition(HashStructure hashStructure) {
        super(hashStructure);
    }

    public MacroDefinition() {
        super(HashStructure.newInstance());
    }

    public MacroDefinition(String name) {
        super(HashStructure.newInstance());
        this.setName(name);
    }

    public static MacroDefinition getInstance(PropertyStorage ps) {
        return new MacroDefinition(MacroDefinition.findOrCreate((PropertyStorage)ps, (String)DATA_KEY));
    }

    public HashStructure getHash() {
        return this._hash;
    }

    public static MacroDefinitions getMacroDefinitionsList(Namespace namespace) {
        return (MacroDefinitions)((Object)namespace.find("oracle.ideimpl.macros.MacroDefinitionList"));
    }

    public String getName() {
        return this._hash.getString(NAME);
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Macro name is required");
        }
        this._hash.putString(NAME, name);
    }

    public String getDescription() {
        return this._hash.getString(DESCRIPTION);
    }

    public void setDescription(String description) {
        this._hash.putString(DESCRIPTION, description);
    }

    public String getValue() {
        return this._hash.getString(VALUE);
    }

    public void setValue(String value) {
        this._hash.putString(VALUE, value);
    }

    public String getQualifier() {
        return this._hash.getString(QUALIFIER);
    }

    public void setQualifier(String qualifier) {
        this._hash.putString(QUALIFIER, qualifier);
    }

    public Scope getScope() {
        String s = this._hash.getString(SCOPE);
        if (s == null) {
            System.out.println("ERROR - no scope stored!");
            return Scope.PROJECT;
        }
        return Scope.valueOf(this._hash.getString(SCOPE));
    }

    public void setScope(Scope value) {
        this._hash.putString(SCOPE, value.toString());
    }

    public boolean isLocation() {
        return this._hash.getBoolean(IS_LOCATION, true);
    }

    public void setIsLocation(boolean isLocation) {
        this._hash.putBoolean(IS_LOCATION, isLocation);
    }

    public boolean isCustom() {
        return this._hash.getBoolean(IS_CUSTOM, false);
    }

    public void setCustom(boolean isCustom) {
        this._hash.putBoolean(IS_CUSTOM, isCustom);
    }
}

