/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.ui.table;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import oracle.bm.util.ui.table.AbstractRenderer;
import oracle.bm.util.ui.table.CellUtils;

public class BooleanRenderer
extends AbstractRenderer {
    private static final BooleanRenderer[][] INSTANCES = new BooleanRenderer[2][3];
    public static final int CHECK_BOX = 0;
    public static final int RADIO_BUTTON = 1;

    protected BooleanRenderer(int type, int canEdit) {
        super(type == 1 ? CellUtils.createRadioButtonRenderer() : CellUtils.createCheckBoxRenderer(), canEdit);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JToggleButton renderer = (JToggleButton)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        renderer.setSelected(value != null && (Boolean)value != false);
        return renderer;
    }

    public static BooleanRenderer getBooleanRenderer(int type, int canEdit) {
        return INSTANCES[type][canEdit];
    }

    static {
        for (int i = 0; i <= 1; ++i) {
            BooleanRenderer.INSTANCES[i][0] = new BooleanRenderer(i, 0);
            BooleanRenderer.INSTANCES[i][1] = new BooleanRenderer(i, 1);
            BooleanRenderer.INSTANCES[i][2] = new BooleanRenderer(i, 2);
        }
    }
}

