/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.javatools.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Flavor {
    private static final Pattern PARSE_PATTERN = Pattern.compile("\\s*+([^=]*+)=((?:[^\"][^;]*+)|(?:\"(?:(?:(?<!\\\\)[^\\\\\"])|(?:\\\\.))*+\"));?+");
    private static final Pattern REPLACE_PATTERN = Pattern.compile("\\\\(.)");
    private int m_hashCode;
    private String m_primaryType;
    private String m_subType;
    private ClassLoader m_classLoader;
    private Map<String, String> m_parameters;

    public Flavor(String primaryType, String subType, ClassLoader classLoader, String representationClass, Map<String, String> parameters) {
        this.m_primaryType = primaryType;
        this.m_subType = subType;
        this.m_classLoader = classLoader;
        this.hashFields();
        this.m_parameters = new TreeMap<String, String>();
        if (parameters != null) {
            for (Map.Entry<String, String> e : parameters.entrySet()) {
                this.addParameter(e.getKey(), e.getValue());
            }
        }
        if (representationClass != null) {
            this.addParameter("class", representationClass);
        }
        this.makeParametersReadOnly();
    }

    public Flavor(DataFlavor df) {
        if (df == null) {
            throw new IllegalArgumentException("Missing data flavor");
        }
        this.m_primaryType = df.getPrimaryType();
        this.m_subType = df.getSubType();
        Class<?> representationClass = df.getRepresentationClass();
        if (representationClass != null) {
            this.m_classLoader = representationClass.getClassLoader();
        }
        this.hashFields();
        this.m_parameters = new TreeMap<String, String>();
        String mimeType = df.getMimeType();
        int firstParameter = mimeType.indexOf(59) + 1;
        if (firstParameter > 0 && firstParameter < mimeType.length()) {
            Matcher m = PARSE_PATTERN.matcher(mimeType);
            m.region(firstParameter, mimeType.length());
            while (m.find()) {
                String key = m.group(1);
                String value = m.group(2);
                if (value.length() > 1 && value.charAt(0) == '\"') {
                    value = value.substring(1, value.length() - 1);
                    value = REPLACE_PATTERN.matcher(value).replaceAll("$1");
                }
                this.addParameter(key, value);
            }
            this.makeParametersReadOnly();
        }
    }

    private void hashFields() {
        this.hash(this.m_primaryType);
        this.hash(this.m_subType);
    }

    private void hash(String value) {
        if (value != null) {
            this.m_hashCode += value.hashCode();
        }
    }

    private void addParameter(String key, String value) {
        this.m_parameters.put(key, value);
        this.hash(key);
        this.hash(value);
    }

    private void makeParametersReadOnly() {
        this.m_parameters = Collections.unmodifiableMap(this.m_parameters);
    }

    public String getPrimaryType() {
        return this.m_primaryType;
    }

    public String getSubType() {
        return this.m_subType;
    }

    public ClassLoader getClassLoader() {
        return this.m_classLoader;
    }

    public String getRepresentationClass() {
        return this.m_parameters.get("class");
    }

    public Map<String, String> getParameters() {
        return this.m_parameters;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Flavor) {
            Flavor f = (Flavor)obj;
            if (this.m_hashCode != f.m_hashCode) {
                return false;
            }
            return this.m_parameters.equals(f.m_parameters) && this.checkEquals(this.m_subType, f.m_subType) && this.checkEquals(this.m_primaryType, f.m_primaryType);
        }
        return false;
    }

    private boolean checkEquals(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public int hashCode() {
        return this.m_hashCode;
    }
}

