/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.importer.writers;

import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.importer.writers.IImportGenerator;
import oracle.dbtools.importer.writers.ImportGenModel;
import oracle.dbtools.importer.writers.ImportGenRegistry;
import oracle.dbtools.importer.writers.ImportGenTask;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.utils.IToolRunMode;

public class ImportAPI {
    private ImportProperties _iProps;
    private IToolRunMode _tRunMode;
    private IImportGenerator _service;
    private ImportGenModel _iGenModel;

    public ImportAPI(ImportProperties iProps, IToolRunMode runMode) throws IllegalStateException {
        if (iProps == null || runMode == null) {
            throw new IllegalStateException("ImportAPI called with invalid parameters");
        }
        this._iProps = iProps;
        this._tRunMode = runMode;
        this._iGenModel = new ImportGenModel(this._iProps);
        this._iGenModel.setRunMode(runMode);
        this._service = this.getService();
        this._service.setGenModel(this._iGenModel);
        this._service.setRunMode(runMode);
        this._iGenModel.setService(this._service);
    }

    public ImportGenModel getModel() {
        return this._iGenModel;
    }

    public IImportGenerator getService() {
        Integer loadMethod = (Integer)this._iProps.get(ImportKeys.LOAD_METHOD);
        if (this._iProps.getValueBoolean(ImportKeys.IS_SOURCE_OSS).booleanValue() && loadMethod == 2) {
            loadMethod = 5;
        }
        if (this._service == null) {
            this._service = ImportGenRegistry.getGenerator(loadMethod);
        }
        return this._service;
    }

    public ExitCode start() throws IllegalStateException {
        return this.start(false);
    }

    public ExitCode start(boolean isConnClone) throws IllegalStateException {
        try {
            this._iGenModel.start();
            this._service.start(this._iProps, this._iGenModel, isConnClone);
            return this._iGenModel.getExitCode();
        }
        catch (Exception e) {
            ExitCode exitCode = ExitCode.EXIT_SEVERE;
            exitCode.setMessage(exitCode.getMessage() + " " + e.toString());
            return ExitCode.EXIT_SEVERE;
        }
    }

    public ExitCode process() {
        if (!this._iGenModel.isExitCodeSuccess()) {
            this._iGenModel.setExitCode(ExitCode.EXIT_SEVERE);
            return this._iGenModel.getExitCode();
        }
        ImportGenTask genTask = new ImportGenTask(this._iGenModel);
        RaptorTask<Void> task = genTask.getTask(this._service.getToolName(), true, this._tRunMode.getRunMode() == IToolRunMode.RunMode.GUI ? IRaptorTaskRunMode.MODAL_OPTIONAL : IRaptorTaskRunMode.NO_GUI);
        this._tRunMode.setTask(task);
        return this._iGenModel.getExitCode();
    }
}

