/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extract;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.dbtools.common.config.IEnvironmentConfig;
import oracle.dbtools.common.config.IStorage;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.export.service.ExportParms;
import oracle.dbtools.export.service.SDCloudDeployAPI;
import oracle.dbtools.extract.DeployJson;
import oracle.dbtools.importer.core.CloudStorageUtils;
import oracle.dbtools.importer.readers.DataReaderUtils;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.deployment.DbmsCloudAPI;
import oracle.dbtools.raptor.deployment.DbmsCloudResources;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.IProcessMonitor;
import oracle.dbtools.raptor.utils.IToolRunMode;
import oracle.dbtools.raptor.utils.ToolLogger;
import oracle.dbtools.transfer.location.LocationTestInfo;
import oracle.dbtools.transfer.location.OracleSwiftObjectStorage;
import oracle.dbtools.transfer.task.TransferTaskProgressMonitor;
import oracle.dbtools.transfer.utility.SimpleByteProgressMonitor;
import oracle.dbtools.util.Logger;

public class DeployPdbAPI {
    public static final String ACTION_COPY_DATA = "actionCopyData";
    public static final String ACTION_COPY_BAD = "actionCopyBad";
    public static final String ACTION_COPY_LOG = "actionCopyLog";
    public static final String ACTION_DROP_DATA = "actionDropData";
    public static final String ACTION_DROP_BAD_AND_LOG = "actionDropBadAndLog";
    public static final String ACTION_EXTERNAL_TABLE = "actionExternalTable";
    public static final String ACTION_INSERT_DATA = "actionInsert";
    public static final String ACTION_UPLOAD_DATA = "actionUploadPutData";
    public static final String ACTION_VALIDATE_DATA = "actionValidateData";
    public static final String DATA_FILE_NAME = "dataFileName";
    public static final String DATA_FILE_CREDENTIAL = "dataFileCredential";
    public static final String DATA_FILE_FORMAT = "dataFileFormat";
    public static final String DATA_FILE_PATH = "dataFilePath";
    public static final String DATA_CLOUD_FORMAT = "dataCloudFormat";
    public static final String DATA_FIELDS = "dataFields";
    public static final String DISPLAY_FILE_FORMAT = "displayFileFormat";
    public static final String FMT_DELIMITER = "fmtDelimiter";
    public static final String FMT_ENCLOSURE_LEFT = "fmtEnclosureLeft";
    public static final String FMT_ENCLOSURE_RIGHT = "fmtEnclosureRight";
    public static final String FMT_ENCODING = "fmtEncoding";
    public static final String FMT_FIELDS = "fmtFields";
    public static final String FMT_TERMINATOR = "fmtTerminator";
    public static final String IS_SOURCE_DBO = "isSourceDBO";
    public static final String IS_SOURCE_LOCAL_FILE = "isSourceLocalFile";
    public static final String IS_SOURCE_CLOUD_FILE = "isSourceCloudFile";
    public static final String TARGET_COLUMNS = "TargetColumns";
    public static final String TARGET_CONNECTION = "targetConnection";
    public static final String TARGET_CREDENTIAL = "targetCredential";
    public static final String TARGET_STORAGE_LOCATION = "targetStorageLocation";
    public static final String TARGET_SCHEMA = "targetSchema";
    public static final String TARGET_TABLE = "targetTable";
    public static final String IS_VALIDATE_LIMIT = "isValidateLimit";
    public static final String VALIDATE_LIMIT = "validateLimit";
    private static final String NL = "\n";
    private static final String SPACE = " ";
    public static final String OP_TYPE_SQL = "SQL";
    public static final String OP_TYPE_LDR = "LDR";
    public static final String OP_TYPE_BLD = "BUILD";
    String _cartName;
    Connection _conn;
    String _connName;
    String _connUser;
    boolean _isSchemaConnOwner;
    boolean _isConnClone = false;
    boolean _isPConn = false;
    boolean _connLocked;
    boolean _autoCommit;
    ExitCode _exitCode;
    ExitCode _deployExitCode;
    ExitCode _operationExitCode;
    DbmsCloudAPI _cloudAPI;
    SDCloudDeployAPI _sDDeployAPI;
    DeployJson _deployJson;
    ToolLogger _tLogger;
    IToolRunMode _tRunMode;
    String _zipFile;
    BigDecimal _zipFileSize;
    File _deployDir;
    ArrayList<String> _deployCtl = new ArrayList();
    String _cloudLocation;
    LocationTestInfo _locationTestInfo;
    boolean _isUploadViaDBMS_CLOUD = true;
    String _cloudCredential;
    String _dataFileCredential;
    String _dataFormat;
    String _dataBucketStgLoc;
    String _dataFileStgLoc;
    String _dataFileShortName;
    String _dataFilePath;
    String _displayFileFormat;
    ExportParms _eParms;
    String _schema;
    String _targetTable;
    boolean _isSourceDbo;
    boolean _isSourceLocalFile;
    boolean _isSourceCloudFile;
    private int _operation = 0;
    private boolean _isOperationComplete = false;
    private String _operationType = "BUILD";
    boolean _isBadRows;
    boolean _isLogRows;
    private String _badRowCount;
    private ArrayList<String> _badFileNames;
    private ArrayList<String> _logFileNames;
    private String _badFileLocations;
    private BigDecimal _operationId;
    private String _xTabLog;
    private String _xTabBad;
    private RaptorTask<Void> _task = null;
    private IRaptorTaskProgressUpdater _progressUpdater;
    private boolean _isCancel = false;
    private IProcessMonitor _monitor;

    public void setMonitor(IProcessMonitor aMonitor) {
        this._monitor = aMonitor;
    }

    private void showMonitor() {
        if (this._monitor != null) {
            this._monitor.show();
        }
    }

    private void refreshMonitor() {
        if (this._monitor != null) {
            this._monitor.refresh();
        }
    }

    public DeployPdbAPI(ExportParms eParms, ToolLogger tLogger) {
        this._eParms = eParms;
        this._tRunMode = this._eParms.getToolRunMode();
        this._connName = eParms.getDestConnName();
        this._tLogger = tLogger;
    }

    public DeployPdbAPI(ExportParms eParms) {
        this._eParms = eParms;
        this._tRunMode = this._eParms.getToolRunMode();
        this._connName = this._eParms.getDestConnName();
        this._tLogger = new ToolLogger(this._tRunMode.getEncoding());
    }

    public void setProgressUpdater(IRaptorTaskProgressUpdater progressUpdater) {
        this._progressUpdater = progressUpdater;
    }

    public ExitCode startDeploy(String cartName, String zipFile, String schema, String cloudLocation, String cloudCredential, LocationTestInfo locationTestInfo) {
        this._deployExitCode = ExitCode.EXIT_SUCCESS;
        this._operationExitCode = ExitCode.EXIT_SUCCESS;
        this.setExitCode(ExitCode.EXIT_SUCCESS);
        this._schema = schema;
        this._cloudLocation = cloudLocation;
        this._cloudCredential = cloudCredential;
        this._locationTestInfo = locationTestInfo;
        this._zipFile = zipFile;
        this._cartName = cartName;
        try {
            this._cloudAPI = new DbmsCloudAPI(this._tLogger);
            this.setExitCode(this._cloudAPI.startService(this._connName, true));
            this._isConnClone = true;
        }
        catch (Exception e) {
            Logger.warn(DeployPdbAPI.class, (Throwable)e);
            this.setExitCode(ExitCode.EXIT_SEVERE);
            this.getExitCode().setShortMessage(e.getMessage());
        }
        if (this.getExitCode() != ExitCode.EXIT_SUCCESS) {
            return this.getExitCode();
        }
        this._cloudAPI.setSqlSpacing("  ");
        this._conn = this._cloudAPI.getConnection();
        this._connUser = this._cloudAPI.getConnectionUser();
        this._isSchemaConnOwner = this._connUser.equals(this._schema);
        try {
            this._sDDeployAPI = new SDCloudDeployAPI(this._tLogger);
            this._sDDeployAPI.startService(this._connName, this._conn, this._connUser, this._schema);
        }
        catch (Exception e) {
            Logger.warn(DeployPdbAPI.class, (Throwable)e);
            this.setExitCode(ExitCode.EXIT_SEVERE);
            this.getExitCode().setShortMessage(e.getMessage());
        }
        try {
            this._sDDeployAPI.insertSdDeploy(this._cartName, this._zipFile, "DEPLOY", this._zipFileSize, this._schema, this._cloudLocation, cloudCredential);
            this._conn.commit();
            this.showMonitor();
        }
        catch (SQLException e) {
            this.setExitCode(this._sDDeployAPI.getExitCode());
            return this._exitCode;
        }
        return this.getDeployExitCode();
    }

    public ExitCode restartDeploy() {
        if (this._cloudAPI == null || this._sDDeployAPI == null || this._conn == null || this._connName == null) {
            this.setExitCode(ExitCode.EXIT_SEVERE);
            this.getExitCode().setShortMessage("Service cannot be restarted");
            return this.getExitCode();
        }
        try {
            this.finish();
            this.setExitCode(this._cloudAPI.restartService(true));
            this._isConnClone = true;
            this._conn = this._cloudAPI.getConnection();
            this._sDDeployAPI.restartService(this._connName, this._conn, this._connUser, this._schema);
        }
        catch (Exception e) {
            Logger.warn(DeployPdbAPI.class, (Throwable)e);
            this.setExitCode(ExitCode.EXIT_SEVERE);
            this.getExitCode().setShortMessage(e.getMessage());
        }
        return this.getDeployExitCode();
    }

    public void executeDeployAsTask() {
        IRaptorTaskRunMode mode = IRaptorTaskRunMode.IDE_STATUSBAR;
        String msg = DbmsCloudResources.getString((String)"DBMS_CLOUD_DEPLOY_CART");
        this._task = new DatabaseQueryTask<Void>(msg, mode, false, true){

            public Void doWork() {
                DeployPdbAPI.this.executeDeploy();
                return null;
            }

            public boolean cancel() {
                DeployPdbAPI.this._isCancel = true;
                return true;
            }

            public String getConnectionName() {
                return DeployPdbAPI.this._connName;
            }

            public String getQuery() {
                return "";
            }
        };
        this._task.setCancellable(true);
        this._task.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFinished(RaptorTaskEvent event) {
                try {
                    DeployPdbAPI.this.finish();
                }
                finally {
                    DeployPdbAPI.this._task = null;
                }
            }

            public void taskCancelled(RaptorTaskEvent event) {
                DeployPdbAPI.this.cancelled();
                DeployPdbAPI.this._isCancel = true;
            }

            public void taskFailed(RaptorTaskEvent event) {
                DeployPdbAPI.this.failed();
                DeployPdbAPI.this._isCancel = true;
            }
        });
        this._progressUpdater = this._task.getRaptorTaskProgressUpdater();
        RaptorTaskManager.getInstance().addTask(this._task);
    }

    public ExitCode executeDeploy() {
        if (this.getExitCode() != ExitCode.EXIT_SUCCESS) {
            return this.getExitCode();
        }
        this._deployExitCode = ExitCode.EXIT_SUCCESS;
        this.setExitCode(ExitCode.EXIT_SUCCESS);
        if (this.getExitCode() != ExitCode.EXIT_SUCCESS) {
            return this.getExitCode();
        }
        if (!this.lockConnectionLong()) {
            return this.getExitCode();
        }
        this._cloudAPI.isConnLocked(true);
        this._sDDeployAPI.setConnLocked(true);
        String msg = this.validateDeploy();
        if (!msg.isEmpty()) {
            ExitCode exitCode = ExitCode.EXIT_ERROR;
            exitCode.setShortMessage(DbmsCloudResources.getString((String)"DBMS_CLOUD_START_ERR_DEPLOY") + SPACE);
            exitCode.setMessage(this.getExitCode().getShortMessage() + msg);
            this.setExitCode(exitCode);
            return exitCode;
        }
        try {
            this._deployCtl = this.getFileAsArray("deploy.sqldev");
        }
        catch (Exception e) {
            Logger.warn(DeployPdbAPI.class, (Throwable)e);
            this.eLogException(e);
        }
        this._isUploadViaDBMS_CLOUD = true;
        if (this._locationTestInfo != null) {
            Logger.info(this.getClass(), (String)(DbmsCloudResources.getString((String)"DBMS_CLOUD_TESTING") + SPACE + DbmsCloudResources.getString((String)"DBMS_CLOUD_UPLOAD_DB")));
            this._locationTestInfo = OracleSwiftObjectStorage.testBucketUrl((String)this._cloudLocation, (boolean)false);
            Logger.info(this.getClass(), (String)this._locationTestInfo.getResultString());
            if (this._locationTestInfo.getResult() == LocationTestInfo.Result.PASS) {
                this._tLogger.log(DbmsCloudResources.getString((String)"DBMS_CLOUD_UPLOAD_OPT"));
                this._isUploadViaDBMS_CLOUD = false;
            }
        }
        int phase = 0;
        try {
            for (String deployObj : this._deployCtl) {
                if (this._progressUpdater != null) {
                    this._progressUpdater.checkCanProceed();
                }
                ++this._operation;
                this._tLogger = new ToolLogger(this._tRunMode.getEncoding());
                this._cloudAPI.setTLogger(this._tLogger);
                this._sDDeployAPI.setTLogger(this._tLogger);
                this._displayFileFormat = null;
                this._operationId = null;
                String[] cols = deployObj.split(SPACE);
                this._operationType = cols[0];
                this._operationExitCode = ExitCode.EXIT_SUCCESS;
                this.setExitCode(ExitCode.EXIT_SUCCESS);
                this.taskProgress(DbmsCloudResources.format((String)"DBMS_CLOUD_DEPLOY_START", (Object[])new Object[]{cols[1]}));
                if (this.insertDeployOperationMeta(this._operation + 1, cols[1], this._operationType)) {
                    this._isOperationComplete = false;
                    if (this._operationType.equals(OP_TYPE_SQL)) {
                        try {
                            this.taskProgress(DbmsCloudResources.format((String)"DBMS_CLOUD_DEPLOY_START_SQL", (Object[])new Object[]{cols[1]}));
                            if (!this.executeSql(this.getFileAsString(cols[1]))) {
                                this.setExitCode(ExitCode.EXIT_ERROR);
                            }
                        }
                        catch (Exception e) {
                            Logger.warn(DeployPdbAPI.class, (Throwable)e);
                            this.eLogException(e);
                        }
                    } else {
                        phase = 2;
                    }
                    if (this._operationType.equals(OP_TYPE_LDR)) {
                        try {
                            this.taskProgress(DbmsCloudResources.format((String)"DBMS_CLOUD_DEPLOY_START_LOAD", (Object[])new Object[]{cols[1]}));
                            this.executeLdr(cols[1]);
                        }
                        catch (Exception e) {
                            this.setExitCode(ExitCode.EXIT_ERROR);
                            Logger.warn(DeployPdbAPI.class, (Throwable)e);
                            this.eLogException(e);
                        }
                    }
                }
                this.completeOperation();
            }
            this.completeDeployment("DBMS_CLOUD_DEPLOY_FINISH");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return this.getDeployExitCode();
    }

    private void completeOperation() {
        this._tLogger.finished();
        try {
            String status = this._isCancel ? DbmsCloudResources.getString((String)"DBMS_CLOUD_CANCELLED_STATUS") : DbmsCloudResources.getString((String)("DBMS_CLOUD_DEPLOY_" + this.getOperationExitCode()));
            this.updateDeployOperationMeta(this._operation + 1, this._operationType, status, this._tLogger.getLogName(), this._operationId, this._displayFileFormat);
        }
        catch (Exception e) {
            this.setExitCode(this._sDDeployAPI.getExitCode());
        }
        this._isOperationComplete = true;
    }

    private void completeDeployment(String progressMsg) {
        try {
            this.taskProgress(progressMsg);
            String status = this._isCancel ? DbmsCloudResources.getString((String)"DBMS_CLOUD_CANCELLED_STATUS") : DbmsCloudResources.getString((String)("DBMS_CLOUD_DEPLOY_" + this.getDeployExitCode()));
            this._sDDeployAPI.updateSdDeploy(this._cartName, status);
            this._conn.commit();
            this.refreshMonitor();
        }
        catch (Exception e) {
            this.setExitCode(this._sDDeployAPI.getExitCode());
        }
    }

    public ExitCode cancelled() {
        this._isCancel = true;
        ExitCode exitCode = ExitCode.EXIT_SEVERE;
        exitCode.setShortMessage(DbmsCloudResources.getString((String)"DBMS_CLOUD_CANCELLED_STATUS") + SPACE);
        exitCode.setMessage(DbmsCloudResources.getString((String)"DBMS_CLOUD_CANCELLED_MSG"));
        this.setExitCode(exitCode);
        if (!this._isOperationComplete) {
            this.completeOperation();
            this.refreshMonitor();
        }
        this.completeDeployment(DbmsCloudResources.getString((String)"DBMS_CLOUD_CANCELLED_MSG"));
        return this.finish();
    }

    public ExitCode failed() {
        ExitCode exitCode = ExitCode.EXIT_SEVERE;
        exitCode.setShortMessage(DbmsCloudResources.getString((String)"DBMS_CLOUD_FAILED_STATUS") + SPACE);
        exitCode.setMessage(DbmsCloudResources.getString((String)"DBMS_CLOUD_FAILED_MSG"));
        this.setExitCode(exitCode);
        if (!this._isOperationComplete) {
            this.completeOperation();
            this.refreshMonitor();
        }
        this.completeDeployment(DbmsCloudResources.getString((String)"DBMS_CLOUD_CANCELLED_MSG"));
        return this.finish();
    }

    public ExitCode finish() {
        this.setExitCode(ExitCode.EXIT_SUCCESS);
        try {
            if (this._connLocked) {
                this._conn.setAutoCommit(this._autoCommit);
                LockManager.unlock((Connection)this._conn);
            }
        }
        catch (Exception e) {
            LockManager.unlock((Connection)this._conn);
            Logger.warn(DeployPdbAPI.class, (Throwable)e);
            this.setExitCode(ExitCode.EXIT_WARNING);
            this.getExitCode().setShortMessage(e.getMessage());
            this.eLogException(e);
        }
        finally {
            this._cloudAPI.isConnLocked(false);
            this._sDDeployAPI.setConnLocked(false);
            this._connLocked = false;
            try {
                if (this._isConnClone) {
                    this._conn.close();
                    this._isConnClone = false;
                }
            }
            catch (Exception e) {
                Logger.warn(DeployPdbAPI.class, (Throwable)e);
                this.setExitCode(ExitCode.EXIT_WARNING);
                this.getExitCode().setShortMessage(e.getMessage());
                this.eLogException(e);
            }
        }
        return this.getExitCode();
    }

    private boolean lockConnectionLong() {
        try {
            this._connLocked = LockManager.lock((Connection)this._conn);
            if (!this._connLocked) {
                this.setExitCode(ExitCode.EXIT_SEVERE);
                this.getExitCode().setShortMessage(DbmsCloudResources.getString((String)"DBMS_CLOUD_LOCK_CONN_ERR"));
                Logger.warn(DeployPdbAPI.class, (String)this.getExitCode().getShortMessage());
                return false;
            }
            this._autoCommit = this._conn.getAutoCommit();
            this._conn.setAutoCommit(false);
        }
        catch (Exception e) {
            Logger.severe(DeployPdbAPI.class, (Throwable)e);
            this.setExitCode(ExitCode.EXIT_SEVERE);
            this.getExitCode().setShortMessage(e.getMessage());
            return false;
        }
        return this._connLocked;
    }

    public ExitCode getExitCode() {
        return this._exitCode;
    }

    public void setExitCode(ExitCode exitCode) {
        this._exitCode = exitCode;
        this.setOperationExitCode(this._exitCode);
        this.setDeployExitCode(this._exitCode);
    }

    public void setOperationExitCode(ExitCode exitCode) {
        if (exitCode != null && this._operationExitCode.getSeverity() < exitCode.getSeverity()) {
            this._operationExitCode = exitCode;
        }
    }

    public void setDeployExitCode(ExitCode exitCode) {
        if (exitCode != null && this._deployExitCode.getSeverity() < exitCode.getSeverity()) {
            this._deployExitCode = exitCode;
        }
    }

    public ExitCode getOperationExitCode() {
        return this._operationExitCode;
    }

    public ExitCode getDeployExitCode() {
        return this._deployExitCode;
    }

    private ArrayList<String> getFileAsArray(String fileName) throws Exception {
        ArrayList<String> contents = new ArrayList<String>();
        try (InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(this._deployDir + File.separator + fileName), "UTF8");
             BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("--")) continue;
                contents.add(line);
            }
        }
        return contents;
    }

    private String getFileAsString(String fileName) throws Exception {
        StringBuffer contents = new StringBuffer();
        try (InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(this._deployDir + File.separator + fileName), "UTF8");
             BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
                contents.append(line + NL);
            }
        }
        return contents.toString();
    }

    private Map<String, Object> loadJsonObject(String fileName) throws Exception {
        this._deployJson = new DeployJson();
        return this._deployJson.loadDeployCtl(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeLdr(String stepFile) {
        block17: {
            this.loadJsonObject(this._deployDir + File.separator + stepFile);
            boolean isSuccess = this.initLdr(this._deployJson);
            this._displayFileFormat = this._deployJson.getJsonObjectAsString(DISPLAY_FILE_FORMAT);
            if (!this._deployJson.getString(ACTION_UPLOAD_DATA, "false").equals("true") || this.doPut(this._deployJson)) break block17;
            this.setExitCode(ExitCode.EXIT_ERROR);
            boolean bl = false;
            this.eLog(NL);
            this.eLog(DbmsCloudResources.format((String)"DBMS_CLOUD_DEPLOY_OP_STATUS", (Object[])new Object[]{DbmsCloudResources.getString((String)("DBMS_CLOUD_DEPLOY_" + this.getExitCode()))}));
            if (this._badRowCount != null) {
                this.eLog(DbmsCloudResources.format((String)"DBMS_CLOUD_VAL_XTAB_BAD_COUNT", (Object[])new Object[]{this._xTabBad, this._badRowCount}));
            }
            return bl;
        }
        try {
            if (this._deployJson.getString(ACTION_COPY_DATA, "false").equals("true") && !this.doCopy(this._deployJson)) {
                this.setExitCode(ExitCode.EXIT_ERROR);
            }
            if (this._deployJson.getString(ACTION_EXTERNAL_TABLE, "false").equals("true") && !this.doExternalTable(this._deployJson)) {
                this.setExitCode(ExitCode.EXIT_ERROR);
            }
            if (this._deployJson.getString(ACTION_DROP_DATA, "false").equals("true") && !this.doDropData(this._deployJson)) {
                this.setExitCode(ExitCode.EXIT_ERROR);
            }
            if (this._deployJson.getString(ACTION_INSERT_DATA, "false").equals("true") && !this.doInsert(this._deployJson)) {
                this.setExitCode(ExitCode.EXIT_ERROR);
            }
            if (this._deployJson.getString(ACTION_COPY_LOG, "false").equals("true") && !this.doCopyLog(this._deployJson)) {
                this.setExitCode(ExitCode.EXIT_ERROR);
            }
            if (this._deployJson.getString(ACTION_COPY_BAD, "false").equals("true") && !this.doCopyBad(this._deployJson)) {
                this.setExitCode(ExitCode.EXIT_ERROR);
            }
            this.doBadPreview(this._deployJson);
            if (this._deployJson.getString(ACTION_DROP_BAD_AND_LOG, "false").equals("true") && !this.doDropLogAndBad(this._deployJson)) {
                this.setExitCode(ExitCode.EXIT_ERROR);
            }
            if (this._isBadRows) {
                this.setExitCode(ExitCode.EXIT_WARNING);
            }
            this.eLog(NL);
        }
        catch (Exception e) {
            boolean bl;
            try {
                Logger.warn(DeployPdbAPI.class, (Throwable)e);
                this.setExitCode(ExitCode.EXIT_ERROR);
                this.eLogException(e);
                bl = true;
                this.eLog(NL);
            }
            catch (Throwable throwable) {
                this.eLog(NL);
                this.eLog(DbmsCloudResources.format((String)"DBMS_CLOUD_DEPLOY_OP_STATUS", (Object[])new Object[]{DbmsCloudResources.getString((String)("DBMS_CLOUD_DEPLOY_" + this.getExitCode()))}));
                if (this._badRowCount != null) {
                    this.eLog(DbmsCloudResources.format((String)"DBMS_CLOUD_VAL_XTAB_BAD_COUNT", (Object[])new Object[]{this._xTabBad, this._badRowCount}));
                }
                throw throwable;
            }
            this.eLog(DbmsCloudResources.format((String)"DBMS_CLOUD_DEPLOY_OP_STATUS", (Object[])new Object[]{DbmsCloudResources.getString((String)("DBMS_CLOUD_DEPLOY_" + this.getExitCode()))}));
            if (this._badRowCount != null) {
                this.eLog(DbmsCloudResources.format((String)"DBMS_CLOUD_VAL_XTAB_BAD_COUNT", (Object[])new Object[]{this._xTabBad, this._badRowCount}));
            }
            return bl;
        }
        this.eLog(DbmsCloudResources.format((String)"DBMS_CLOUD_DEPLOY_OP_STATUS", (Object[])new Object[]{DbmsCloudResources.getString((String)("DBMS_CLOUD_DEPLOY_" + this.getExitCode()))}));
        if (this._badRowCount != null) {
            this.eLog(DbmsCloudResources.format((String)"DBMS_CLOUD_VAL_XTAB_BAD_COUNT", (Object[])new Object[]{this._xTabBad, this._badRowCount}));
        }
        return true;
    }

    private boolean initLdr(DeployJson _deployJson) {
        try {
            this._isSourceDbo = _deployJson.getString(IS_SOURCE_DBO, "false").equals("true");
            this._isSourceLocalFile = _deployJson.getString(IS_SOURCE_LOCAL_FILE, "false").equals("true");
            this._isSourceCloudFile = _deployJson.getString(IS_SOURCE_CLOUD_FILE, "false").equals("true");
            if (!this._isSourceDbo) {
                this._dataFilePath = _deployJson.getString(DATA_FILE_PATH);
            }
            this._dataFormat = _deployJson.getString(DATA_FILE_FORMAT, "CSV".toLowerCase());
            this._dataBucketStgLoc = _deployJson.getString(TARGET_STORAGE_LOCATION, "");
            this._dataFileShortName = _deployJson.getString(DATA_FILE_NAME, "");
            int i = this._dataFileShortName.lastIndexOf(".");
            String _dataFilePrefix = i == -1 ? this._dataFileShortName : this._dataFileShortName.substring(0, i);
            String tmpFileName = DataReaderUtils.getTempName(_dataFilePrefix) + "." + this._dataFormat;
            if (this._isSourceCloudFile) {
                this._dataFileStgLoc = this._dataFilePath;
                this._dataBucketStgLoc = this._dataFilePath.substring(0, this._dataFilePath.lastIndexOf("/"));
            } else {
                Object object = this._dataFileStgLoc = this._dataBucketStgLoc.endsWith("/") ? this._dataBucketStgLoc + tmpFileName : this._dataBucketStgLoc + "/" + tmpFileName;
            }
            if (!this._dataBucketStgLoc.endsWith("/")) {
                this._dataBucketStgLoc = this._dataBucketStgLoc + "/";
            }
            this._dataFileCredential = _deployJson.getString(DATA_FILE_CREDENTIAL, "");
            this._cloudCredential = _deployJson.getString(TARGET_CREDENTIAL, "");
            this._schema = _deployJson.getString(TARGET_SCHEMA, "");
            this._cloudAPI.setSchema(this._schema);
            this._targetTable = _deployJson.getString(TARGET_TABLE, "");
        }
        catch (Exception e) {
            this.setExitCode(ExitCode.EXIT_ERROR);
            Logger.warn(DeployPdbAPI.class, (Throwable)e);
            this.eLogException(e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doPut(DeployJson _deployJson) {
        block21: {
            String extractFile;
            String string = extractFile = this._isSourceDbo ? this._deployDir.getPath() + File.separator + this._dataFileShortName : this._dataFilePath;
            if (this._isUploadViaDBMS_CLOUD) {
                Logger.info(this.getClass(), (String)(DbmsCloudResources.getString((String)"DBMS_CLOUD_ATTEMPTING") + SPACE + DbmsCloudResources.getString((String)"DBMS_CLOUD_UPLOAD_DB")));
                try (FileInputStream fis = new FileInputStream(extractFile);){
                    this._cloudAPI.putObject(this._cloudCredential, this._dataFileStgLoc, (InputStream)fis);
                    fis.close();
                    break block21;
                }
                catch (Exception e) {
                    Logger.warn(DeployPdbAPI.class, (Throwable)e);
                    this.eLogException(e);
                    return false;
                }
            }
            String msg = DbmsCloudResources.getString((String)"DBMS_CLOUD_SUCCESS");
            this.eLog(DbmsCloudResources.format((String)"DBMS_CLOUD_STEP_START", (Object[])new Object[]{DbmsCloudResources.getString((String)"DBMS_CLOUD_STEP_PUT_DATA")}));
            this.eLog(DbmsCloudResources.getString((String)"DBMS_CLOUD_UPLOAD_OPT"));
            OracleSwiftObjectStorage storage = null;
            Logger.info(this.getClass(), (String)(DbmsCloudResources.getString((String)"DBMS_CLOUD_ATTEMPTING") + SPACE + DbmsCloudResources.getString((String)"DBMS_CLOUD_UPLOAD_OPT")));
            try (FileInputStream fis = new FileInputStream(extractFile);){
                storage = OracleSwiftObjectStorage.find((String)this._dataFileStgLoc);
                if (storage != null) {
                    URL dataFileStgLoc = new URL(this._dataFileStgLoc);
                    String path = dataFileStgLoc.getPath();
                    String target = path.substring(path.indexOf(47, 4) + 1);
                    storage.connect();
                    storage.copy((InputStream)fis, target, (TransferTaskProgressMonitor)new SimpleByteProgressMonitor(), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                } else {
                    this.eLog(DbmsCloudResources.getString((String)"DBMS_CLOUD_UPLOAD_OSOS_ERROR"));
                    this.eLog(DbmsCloudResources.getString((String)"DBMS_CLOUD_UPLOAD_OPT_ERROR"));
                }
            }
            catch (Exception e) {
                this.eLog(DbmsCloudResources.getString((String)"DBMS_CLOUD_UPLOAD_OPT_ERROR"));
                Logger.warn(DeployPdbAPI.class, (Throwable)e);
                this.eLogException(e);
            }
            finally {
                if (storage != null) {
                    storage.disconnect();
                }
            }
            this.eLog(msg);
            this.eLog(DbmsCloudResources.format((String)"DBMS_CLOUD_STEP_END", (Object[])new Object[]{DbmsCloudResources.getString((String)"DBMS_CLOUD_STEP_PUT_DATA")}) + NL);
        }
        return true;
    }

    public boolean doCopy(DeployJson _deployJson) throws SQLException {
        this._isLogRows = false;
        this._isBadRows = false;
        this._xTabLog = "";
        this._xTabBad = "";
        this._badFileNames = new ArrayList();
        this._logFileNames = new ArrayList();
        try {
            String sql = this._cloudAPI.getCopyDataProcedure(_deployJson.getString(TARGET_TABLE), this._dataFileCredential, this._dataFileStgLoc, this._schema, _deployJson.getString(DATA_FIELDS, ""), this.formatString(_deployJson.getString(DATA_CLOUD_FORMAT)));
            this._operationId = this._cloudAPI.doCopy(sql);
        }
        catch (Exception e) {
            this.setExitCode(this._cloudAPI.getExitCode());
            this._operationId = this._cloudAPI.getLastOperationId();
        }
        if (this._operationId == null || this._operationId.compareTo(new BigDecimal(0)) == -1) {
            return false;
        }
        String operationPrefix = "COPY$";
        this._xTabLog = operationPrefix + this._operationId + "_LOG";
        this._xTabBad = operationPrefix + this._operationId + "_BAD";
        this._isLogRows = this._cloudAPI.logXTabLog(this._schema, this._xTabLog, this._badFileNames, this._logFileNames);
        this._badRowCount = this._cloudAPI.getCountCloudTab(this._xTabBad);
        this._isBadRows = this._badRowCount != null && !this._badRowCount.isEmpty() && !this._badRowCount.equals("0");
        return true;
    }

    public boolean doExternalTable(DeployJson _deployJson) throws SQLException {
        this._isLogRows = false;
        this._isBadRows = false;
        this._xTabLog = "";
        this._xTabBad = "";
        this._badFileNames = new ArrayList();
        this._logFileNames = new ArrayList();
        try {
            String sql = this._cloudAPI.getExtCreateTableStatement(this._targetTable, this._dataFileCredential, this._dataFileStgLoc, this._schema, _deployJson.getString(TARGET_COLUMNS, ""), this.formatString(_deployJson.getString(DATA_CLOUD_FORMAT)));
            this._cloudAPI.createExternalTable(sql);
        }
        catch (Exception e) {
            this.setExitCode(this._cloudAPI.getExitCode());
            return false;
        }
        if (_deployJson.getString(ACTION_VALIDATE_DATA, "false").equals("true")) {
            try {
                BigDecimal validateLimit = null;
                if (_deployJson.getString(IS_VALIDATE_LIMIT, "false").equals("true")) {
                    validateLimit = new BigDecimal(_deployJson.getString(VALIDATE_LIMIT, "0"));
                }
                this._operationId = this._cloudAPI.validateExternalTable(this._targetTable, this._schema, validateLimit);
            }
            catch (SQLException e) {
                this.setExitCode(this._cloudAPI.getExitCode());
                this._operationId = this._cloudAPI.getLastOperationId();
            }
        }
        if (this._operationId == null || this._operationId.compareTo(new BigDecimal(0)) == -1) {
            return false;
        }
        String operationPrefix = "VALIDATE$";
        this._xTabLog = operationPrefix + this._operationId + "_LOG";
        this._xTabBad = operationPrefix + this._operationId + "_BAD";
        this._isLogRows = this._cloudAPI.logXTabLog(this._schema, this._xTabLog, this._badFileNames, this._logFileNames);
        this._badRowCount = this._cloudAPI.getCountCloudTab(this._xTabBad);
        this._isBadRows = this._badRowCount != null && !this._badRowCount.isEmpty() && !this._badRowCount.equals("0");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doDropData(DeployJson _deployJson) {
        if (this._isUploadViaDBMS_CLOUD) {
            try {
                this._cloudAPI.deleteObject(this._cloudCredential, this._dataFileStgLoc);
            }
            catch (Exception e) {
                Logger.warn(DeployPdbAPI.class, (Throwable)e);
                this.eLogException(e);
                return false;
            }
        }
        String msg = DbmsCloudResources.getString((String)"DBMS_CLOUD_SUCCESS");
        this.eLog(DbmsCloudResources.format((String)"DBMS_CLOUD_STEP_START", (Object[])new Object[]{DbmsCloudResources.getString((String)"DBMS_CLOUD_STEP_DELETE_OBJECT")}));
        OracleSwiftObjectStorage storage = null;
        Logger.info(this.getClass(), (String)(DbmsCloudResources.getString((String)"DBMS_CLOUD_ATTEMPTING") + SPACE + DbmsCloudResources.getString((String)"DBMS_CLOUD_UPLOAD_OPT")));
        try {
            storage = OracleSwiftObjectStorage.find((String)this._dataFileStgLoc);
            if (storage != null) {
                URL dataFileStgLoc = new URL(this._dataFileStgLoc);
                String path = dataFileStgLoc.getPath();
                String target = path.substring(path.indexOf(47, 4) + 1);
                storage.connect();
                storage.delete(target);
            } else {
                this.eLog(DbmsCloudResources.getString((String)"DBMS_CLOUD_UPLOAD_OSOS_ERROR"));
            }
        }
        catch (Exception e) {
            this.eLog(DbmsCloudResources.getString((String)"DBMS_CLOUD_UPLOAD_OPT_ERROR"));
            Logger.warn(DeployPdbAPI.class, (Throwable)e);
            this.eLogException(e);
        }
        finally {
            if (storage != null) {
                storage.disconnect();
            }
        }
        this.eLog(msg);
        this.eLog(DbmsCloudResources.format((String)"DBMS_CLOUD_STEP_END", (Object[])new Object[]{DbmsCloudResources.getString((String)"DBMS_CLOUD_STEP_DELETE_OBJECT")}) + NL);
        return true;
    }

    protected boolean doInsert(DeployJson _deployJson) {
        return true;
    }

    protected boolean doCopyLog(DeployJson _deployJson) {
        if (this._isLogRows) {
            String logFileLocations;
            try {
                logFileLocations = this._cloudAPI.putObject(this._dataFileCredential, this._dataBucketStgLoc, this._logFileNames, false);
            }
            catch (Exception e) {
                Logger.warn(DeployPdbAPI.class, (Throwable)e);
                this.eLogException(e);
                return false;
            }
            try {
                this._sDDeployAPI.updateSdDeployOperationLogFiles(this._cartName, this._operation + 1, logFileLocations);
            }
            catch (Exception e) {
                this.setExitCode(this._sDDeployAPI.getExitCode());
                return false;
            }
        }
        return true;
    }

    protected boolean doCopyBad(DeployJson _deployJson) {
        this._badFileLocations = "";
        if (this._isBadRows) {
            try {
                this._badFileLocations = this._cloudAPI.putObject(this._dataFileCredential, this._dataBucketStgLoc, this._badFileNames, false);
            }
            catch (Exception e) {
                Logger.warn(DeployPdbAPI.class, (Throwable)e);
                this.eLogException(e);
                return false;
            }
            try {
                this._sDDeployAPI.updateSdDeployOperationBadFiles(this._cartName, this._operation + 1, this._badFileLocations);
            }
            catch (Exception e) {
                this.setExitCode(this._sDDeployAPI.getExitCode());
                return false;
            }
        }
        return true;
    }

    protected boolean doBadPreview(DeployJson _deployJson) {
        if (this._isBadRows) {
            ArrayList<String> previewNames = new ArrayList<String>();
            Integer size = 20000;
            StringBuffer sample = new StringBuffer();
            if (this._badFileNames != null) {
                if (_deployJson.getString(ACTION_COPY_BAD, "false").equals("true")) {
                    for (int i = 0; i < this._badFileNames.size() && size > 0; ++i) {
                        previewNames.add(this._badFileNames.get(i));
                        String root = "";
                        Object location = "";
                        int j = this._dataFilePath.lastIndexOf("/");
                        if (this._isSourceCloudFile) {
                            root = j < 0 ? this._dataFilePath : this._dataFilePath.substring(0, j);
                            location = root + "/" + this._badFileNames.get(i);
                        } else {
                            location = this._dataBucketStgLoc + this._badFileNames.get(i);
                        }
                        String fragment = CloudStorageUtils.getSample(this._connName, (String)location, this._dataFileCredential, size);
                        if (fragment != null) {
                            sample.append(fragment);
                            size = size - fragment.length();
                        }
                        previewNames.remove(0);
                    }
                } else {
                    for (int i = 0; i < this._badFileNames.size() && size > 0; ++i) {
                        String previewLocation;
                        previewNames.add(this._badFileNames.get(i));
                        try {
                            previewLocation = this._cloudAPI.putObject(this._dataFileCredential, this._dataFileStgLoc, previewNames, false);
                        }
                        catch (Exception e) {
                            Logger.warn(DeployPdbAPI.class, (Throwable)e);
                            this.setExitCode(this._cloudAPI.getExitCode());
                            return false;
                        }
                        try {
                            String fragment = CloudStorageUtils.getSample(this._connName, previewLocation, this._dataFileCredential, size);
                            if (fragment != null) {
                                sample.append(fragment);
                                size = size - fragment.length();
                            }
                            this._cloudAPI.deleteObject(this._dataFileCredential, this._dataFileStgLoc, previewNames);
                        }
                        catch (Exception e) {
                            Logger.warn(DeployPdbAPI.class, (Throwable)e);
                            this.eLogException(e);
                            return false;
                        }
                        previewNames.remove(0);
                    }
                }
            }
            try {
                this._sDDeployAPI.updateSdDeployOperationPreview(this._cartName, this._operation + 1, sample.toString());
            }
            catch (Exception e) {
                this.setExitCode(this._sDDeployAPI.getExitCode());
                return false;
            }
        }
        return true;
    }

    protected boolean doDropLogAndBad(DeployJson _deployJson) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeSql(String script) {
        try {
            try {
                this._conn.setSchema(this._schema);
            }
            catch (Exception e) {
                Logger.warn(DeployPdbAPI.class, (Throwable)e);
                this.eLogException(e);
                boolean bl = false;
                if (!this._isSchemaConnOwner) {
                    try {
                        this._conn.setSchema(this._connUser);
                    }
                    catch (Exception e2) {
                        Logger.warn(DeployPdbAPI.class, (Throwable)e2);
                        this.eLogException(e2);
                    }
                }
                return bl;
            }
            String finalScript = script + this.getTerm();
            this.eLog(finalScript);
            String encoding = ScriptRunnerContext.getOutputEncoding();
            StringReader rdr = new StringReader(finalScript);
            ScriptExecutor runner = new ScriptExecutor((Reader)rdr, this._conn);
            ScriptRunnerContext ctx = new ScriptRunnerContext();
            ctx.putProperty("script.runner.using.systemout", (Object)true);
            runner.setScriptRunnerContext(ctx);
            ByteArrayOutputStream BaS = new ByteArrayOutputStream();
            BufferedOutputStream BoS = new BufferedOutputStream(BaS);
            runner.setOut(BoS);
            runner.run();
            BoS.flush();
            this.eLog(BaS.toString(encoding));
            boolean bl = (Boolean)ctx.getProperty("sqldev.error.any.in") == false;
            return bl;
        }
        catch (Exception e) {
            Logger.warn(DeployPdbAPI.class, (Throwable)e);
            this.eLogException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (!this._isSchemaConnOwner) {
                try {
                    this._conn.setSchema(this._connUser);
                }
                catch (Exception e) {
                    Logger.warn(DeployPdbAPI.class, (Throwable)e);
                    this.eLogException(e);
                }
            }
        }
    }

    public boolean insertDeployOperationMeta(int operationNumber, String operationFileName, String operationType) {
        try {
            this._sDDeployAPI.insertSdDeployOperation(this._cartName, operationNumber, operationFileName, operationType);
            this._conn.commit();
            this.refreshMonitor();
        }
        catch (SQLException e) {
            this.setExitCode(this._sDDeployAPI.getExitCode());
            return false;
        }
        return true;
    }

    public boolean updateDeployOperationMeta(int operationNumber, String operationType, String status, String logFileName, BigDecimal operationId, String displayFileFormat) {
        try {
            this._sDDeployAPI.updateSdDeployOperation(this._cartName, operationNumber, status, logFileName, operationId, displayFileFormat, operationType.equals(OP_TYPE_LDR) ? "TABLE" : null, operationType.equals(OP_TYPE_LDR) ? this._targetTable : null);
            this._conn.commit();
            this.refreshMonitor();
        }
        catch (Exception e) {
            this.setExitCode(this._sDDeployAPI.getExitCode());
            return false;
        }
        return true;
    }

    private String validateDeploy() {
        String msg = "";
        if (this._zipFile == null || this._zipFile.isEmpty()) {
            msg = DbmsCloudResources.getString((String)"DBMS_CLOUD_START_ERR_DEPLOY_NO_ZIP");
            return msg;
        }
        try {
            File zFile = new File(this._zipFile);
            this._zipFileSize = new BigDecimal(zFile.length());
            this._deployDir = DeployPdbAPI.expandZip(zFile);
        }
        catch (Exception e) {
            Logger.warn(DeployPdbAPI.class, (Throwable)e);
            this.eLogException(e);
            msg = DbmsCloudResources.format((String)"DBMS_CLOUD_START_ERR_DEPLOY_UNZIP", (Object[])new Object[]{this._zipFile});
            return msg;
        }
        return msg;
    }

    private static File expandZip(File zipfile) throws IOException {
        File result = null;
        IStorage environmentConfig = IEnvironmentConfig.Storage.getInstance();
        File file = new File(environmentConfig.getString("ENV_USER_TEMP_DIR"));
        Path tmpDirPath = Files.createTempDirectory(file.toPath(), "cloudConfig", new FileAttribute[0]);
        File tmpDir = tmpDirPath.toFile();
        tmpDir.deleteOnExit();
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipfile));){
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                File dest = new File(tmpDir, entry.getName());
                if (entry.isDirectory()) {
                    dest.mkdir();
                } else {
                    try (FileOutputStream fos = new FileOutputStream(dest);
                         BufferedOutputStream os = new BufferedOutputStream(fos);){
                        int len = 0;
                        byte[] buf = new byte[4096];
                        while ((len = zis.read(buf, 0, buf.length)) > 0) {
                            ((OutputStream)os).write(buf, 0, len);
                        }
                    }
                }
                zis.closeEntry();
                entry = zis.getNextEntry();
            }
        }
        result = tmpDir;
        return result;
    }

    private String formatString(String str) {
        StringBuffer newStr = new StringBuffer();
        boolean j = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\"') {
                newStr.append("\\");
            }
            newStr.append(c);
        }
        return newStr.toString();
    }

    private String getTerm() {
        return NL;
    }

    private void setProg(String msg) {
        RaptorTaskDescriptor desc = null;
        if (this._task != null) {
            desc = this._task.getDescriptor();
            desc.setMessage(msg);
        }
    }

    private boolean taskProgress() {
        return this.taskProgress(null);
    }

    private boolean taskProgress(String msg) {
        if (this._progressUpdater != null) {
            try {
                this._progressUpdater.checkCanProceed();
            }
            catch (ExecutionException e) {
                this._isCancel = true;
                return false;
            }
            if (msg != null) {
                this._progressUpdater.getDescriptor().setMessage(msg);
            }
        } else {
            Logger.info(DeployPdbAPI.class, (String)msg);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogAsText() {
        StringBuffer sb = new StringBuffer();
        BufferedReader reader = null;
        if (this._tLogger != null) {
            this._tLogger.finished();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(this._tLogger.getLogName());
                String encoding = this._tRunMode.getEncoding();
                InputStreamReader isr = new InputStreamReader((InputStream)fis, encoding);
                reader = new BufferedReader(isr);
                String line = null;
                while ((line = reader.readLine()) != null) {
                    sb.append(line + NL);
                }
            }
            catch (IOException e) {
                Logger.warn(DeployPdbAPI.class, (Throwable)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        Logger.warn(DeployPdbAPI.class, (Throwable)e);
                    }
                }
                this._tLogger = null;
            }
        }
        return sb.toString();
    }

    protected void eLog(String msg) {
        if (this._tLogger != null) {
            this._tLogger.log(msg);
        }
    }

    protected void eLogException(Exception e) {
        if (this._tLogger != null) {
            this._tLogger.logException((Throwable)e);
        }
    }
}

