/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.export.service;

import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.common.ddl.DDLFormat;
import oracle.dbtools.common.ddl.DDLTypes;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.export.service.ExportParms;
import oracle.dbtools.export.service.ExportService;
import oracle.dbtools.extract.ExtractReconciler;
import oracle.dbtools.extract.models.ExtractDataFormat;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.raptor.utils.IToolRunMode;
import oracle.dbtools.util.Logger;

public class XSCart
extends ExportService {
    private ExportParms _eParms;
    private boolean _isCleanConnNls;
    private Map<String, HashMap<String, String>> nlsHashMap;

    protected final String INIT_APEX_SQL() {
        return "declare\nsgid number := 0;\nappid number := wwv_flow_utilities.minimum_free_flow;\nbegin\nfor r in ( select workspace_id,schema from apex_workspace_schemas ) loop\nwwv_flow_application_install.set_workspace_id(r.workspace_id);\nwwv_flow_application_install.set_schema(r.schema);\nwwv_flow_application_install.set_image_prefix( wwv_flow_global.g_image_prefix );\nsgid := r.workspace_id;\nend loop;\nwwv_flow_application_install.set_application_id(appid);\nwwv_flow_api.set_security_group_id( sgid);\nwwv_flow_application_install.set_application_alias(appid);\nwwv_flow_application_install.generate_offset;\nend;\n/\n";
    }

    @Override
    public ExitCode start(ExportParms eParms, IToolRunMode tRunMode) {
        this._eParms = eParms;
        super.start(eParms, tRunMode);
        ExtractListModel listModel = new ExtractListModel();
        listModel.setSelectedExtractObjects(this._eParms.getSourceExtractObjectList());
        listModel.setSchemas();
        DDLFormat ddlFormat = this._eParms.getDDLFormat();
        this.setDDLFormat(ddlFormat);
        listModel.setDDLFormat(ddlFormat);
        DDLTypes _ddlTypes = listModel.getDDLTypes();
        List<ExtractObject> dboEOList = listModel.getList(0, new int[]{100, 101});
        List<ExtractObject> preSelectedEOList = ExtractListModel.getList(dboEOList, new int[]{107});
        _ddlTypes.setTypes(preSelectedEOList);
        _ddlTypes.setShowConstraint(true);
        _ddlTypes.setShowRefConstraint(true);
        _ddlTypes.setConstraint(ddlFormat.getConstraint());
        _ddlTypes.setRefConstraint(ddlFormat.getRefConstraint());
        listModel.setDDLTypes(_ddlTypes);
        ExtractDataFormat dataFormat = this._eParms.getDataFormat();
        dataFormat.isExportEnabled(this._eParms.isIncludeData());
        listModel.setDataFormat(dataFormat);
        for (ExtractObject eo : this._eParms.getSourceExtractObjectList()) {
            if (eo.isTypeDataFile() && (eo.isExtractMetaData() || eo.isExtractData())) {
                eo.getGenFile();
            }
            eo.setListModel(listModel);
        }
        this.setTargetFormat(this._eParms.getTargetFormat());
        listModel.setReconcileType(ExtractReconciler.ReconcileType.OBJECTS);
        this.setExtractListModel(listModel);
        return ExitCode.EXIT_SUCCESS;
    }

    @Override
    public ExitCode validate() {
        return ExitCode.EXIT_SUCCESS;
    }

    @Override
    public void export() throws Exception {
        if (!this.isCancel() && this.getTargetFormat().isDeployCloud()) {
            List<ExtractObject> nlsObjects = this.getListModel().getList(0, new int[]{100, 8});
            this.loadAndSetConnNls(nlsObjects);
            this.isCleanConnNls(true);
        }
        super.export();
    }

    @Override
    public ExitCode finish() {
        if (this.isCleanConnNls() && this.getTargetFormat().isDeployCloud()) {
            this.unsetConnNls();
        }
        return super.finish();
    }

    protected void isCleanConnNls(boolean value) {
        this._isCleanConnNls = value;
    }

    protected boolean isCleanConnNls() {
        return this._isCleanConnNls;
    }

    protected void loadAndSetConnNls(List<ExtractObject> nlsObjects) {
        this.nlsHashMap = new HashMap<String, HashMap<String, String>>();
        for (ExtractObject o : nlsObjects) {
            String conName = o.getSourceConnName();
            if (!this.nlsHashMap.containsKey(conName)) {
                this.nlsHashMap.put(conName, new HashMap());
                Map<String, String> values = this.getConNlsValues(conName);
                values.put("NLS_LANGUAGE", this.getNlsValue(conName, "NLS_LANGUAGE"));
                values.put("NLS_TERRITORY", this.getNlsValue(conName, "NLS_TERRITORY"));
                values.put("NLS_CALENDAR", this.getNlsValue(conName, "NLS_CALENDAR"));
            }
            this.setCloudNLS(conName, "NLS_LANGUAGE", "AMERICAN");
            this.setCloudNLS(conName, "NLS_TERRITORY", "AMERICA");
            this.setCloudNLS(conName, "NLS_CALENDAR", "GREGORIAN");
        }
    }

    private Map<String, String> getConNlsValues(String conName) {
        return this.nlsHashMap.get(conName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNlsValue(String conName, String parm) {
        String sql = "SELECT value FROM NLS_DATABASE_PARAMETERS where parameter = :PARAM";
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.clear();
        binds.put("PARAM", parm);
        String ret = null;
        boolean lockAcquired = false;
        Connection conn = null;
        try {
            conn = ConnectionResolver.getConnection((String)conName);
            if (conn != null && (lockAcquired = LockManager.lock((Connection)conn))) {
                ret = DBUtil.getInstance((Connection)conn).executeReturnOneCol(sql, binds);
            }
        }
        catch (Exception e) {
            Logger.severe(this.getClass(), (Throwable)e);
            this.eLogException(e);
        }
        finally {
            if (conn != null && lockAcquired) {
                LockManager.unlock((Connection)conn);
            }
        }
        return ret;
    }

    protected void unsetConnNls() {
        for (String conn : this.nlsHashMap.keySet()) {
            Map<String, String> values = this.getConNlsValues(conn);
            for (String param : values.keySet()) {
                String value = values.get(param);
                this.setCloudNLS(conn, param, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCloudNLS(String conName, String param, String value) {
        String sql = "ALTER SESSION SET " + param + "=:VALUE";
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.clear();
        binds.put("VALUE", value);
        Connection conn = null;
        boolean lockAcquired = false;
        try {
            conn = ConnectionResolver.getConnection((String)conName);
            if (conn != null && (lockAcquired = LockManager.lock((Connection)conn))) {
                DBUtil.getInstance((Connection)conn).executeUpdate(sql, binds);
            }
        }
        catch (Exception e) {
            Logger.severe(this.getClass(), (Throwable)e);
            this.eLogException(e);
        }
        finally {
            if (conn != null && lockAcquired) {
                LockManager.unlock((Connection)conn);
            }
        }
    }
}

