/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compare;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import oracle.ide.Ide;
import oracle.ide.config.FileTypesRecognizer;
import oracle.ide.config.Preferences;
import oracle.ide.model.ContentType;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareType;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.compare.CompareManager;
import oracle.jdeveloper.compare.CompareMethod;
import oracle.jdeveloper.compare.StreamType;
import oracle.jdevimpl.compare.CompareInvocation;
import oracle.jdevimpl.compare.CompareOptions;
import oracle.jdevimpl.compare.CompareUtil2;
import oracle.jdevimpl.resource.CompareArb;

public class CompareUtil {
    private CompareUtil() {
    }

    public static final CompareMethod getCompareMethodForType(CompareType type) {
        return CompareUtil2.getCompareMethodForType((CompareType)type);
    }

    public static final CompareInvocation createInvocationContext(Element contextNode, CompareContributor left, CompareContributor right) {
        return CompareUtil.createInvocationContext(contextNode, left, right, null);
    }

    public static final CompareInvocation createInvocationContext(Element contextNode, CompareContributor left, CompareContributor right, StreamType streamType) {
        ArrayList<CompareMethod> compareMethods = new ArrayList<CompareMethod>();
        for (CompareMethod compareMethod : CompareManager.getCompareManager().getCompareMethods()) {
            if (!compareMethod.canCompare(contextNode, left, right, streamType)) continue;
            compareMethods.add(compareMethod);
        }
        return new CompareInvocation(contextNode, compareMethods);
    }

    public static final StreamType getStreamType(CompareContributor contributor) {
        return CompareUtil2.getStreamType((CompareContributor)contributor);
    }

    public static final CompareModel createCompareModel(Node contextNode, CompareContributor left, CompareContributor right, CompareType type) throws CompareFailedException {
        CompareInvocation invocationContext = new CompareInvocation((Element)contextNode, Collections.singleton(CompareUtil.getCompareMethodForType(type)));
        return CompareUtil.createCompareModel(left, right, invocationContext);
    }

    public static final CompareModel createCompareModel(Node contextNode, CompareContributor left, CompareContributor right) throws CompareFailedException {
        return CompareUtil.createCompareModel(left, right, CompareUtil.createInvocationContext((Element)contextNode, left, right));
    }

    public static final CompareModel createCompareModel(CompareContributor left, CompareContributor right, CompareInvocation invocationContext) throws CompareFailedException {
        return CompareUtil2.createCompareModel((CompareContributor)left, (CompareContributor)right, (CompareInvocation)invocationContext);
    }

    public static final boolean confirmIdenticalCompare() {
        CompareOptions compareOptions = CompareUtil.getCompareOptions();
        String message = compareOptions.getIgnoreWhitespace() ? CompareArb.get("COMPARE_IDENTICAL_MESSAGE_NO_WHITESPACE") : CompareArb.get("COMPARE_IDENTICAL_MESSAGE");
        return MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)message, (String)CompareArb.get("COMPARE_IDENTICAL_TITLE"), null, (boolean)true);
    }

    public static final boolean isContentTypeBinary(URL url) {
        return FileTypesRecognizer.getNonNullContentTypeForExtension((String)URLFileSystem.getSuffix((URL)(JarUtil.isJarURL((URL)url) ? JarUtil.getJarFileURL((URL)url) : url))) == ContentType.BINARY;
    }

    static boolean isValidCompareURL(URL url) {
        if (url == null) {
            return false;
        }
        if (CompareUtil.SQLCompareURL(url)) {
            return true;
        }
        if (!URLFileSystem.isLocal((URL)url) || !URLFileSystem.exists((URL)url)) {
            return false;
        }
        if (URLFileSystem.isDirectoryPath((URL)url)) {
            return true;
        }
        return CompareManager.getCompareManager().isContentComparable(url);
    }

    private static final CompareOptions getCompareOptions() {
        return CompareOptions.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    private static boolean SQLCompareURL(URL url) {
        String urlString = url.toExternalForm();
        return urlString.contains("sqldev.nav") && (urlString.contains("PROCEDURE") || urlString.contains("FUNCTION") || urlString.contains("PACKAGE") || urlString.contains("TRIGGER") || urlString.contains("TYPE"));
    }
}

