/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compare;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystemHelper;
import oracle.javatools.compare.CompareContributor;
import oracle.jdevimpl.compare.CompareNode;
import oracle.jdevimpl.resource.CompareArb;

public class CompareURLHelper
extends URLFileSystemHelper {
    private static final String SEPARATOR = "///";
    public static final String PROTOCOL = "ide.compare";

    public static URL newCompareURL(CompareContributor source, CompareContributor target, int sequence) {
        return URLFactory.newURL((String)PROTOCOL, (String)(source.getLongLabel() + SEPARATOR + target.getLongLabel() + SEPARATOR + String.valueOf(sequence)));
    }

    public static int getSequence(URL url) {
        return Integer.parseInt(url.getPath().split(SEPARATOR)[2]);
    }

    public String getFileName(URL url) {
        String path = url.getPath();
        String[] parts = path.split(SEPARATOR);
        if (parts.length < 2) {
            return "";
        }
        return CompareArb.format("COMPARE_SHORT_NAME", parts[2]);
    }

    public URL getParent(URL url) {
        String path = url.getPath();
        String[] parts = path.split(SEPARATOR);
        if (parts.length == 0) {
            return null;
        }
        String[] paths = parts[0].split("/");
        StringBuilder sb = new StringBuilder();
        for (int c = 0; c < paths.length - 1; ++c) {
            sb.append('/');
            sb.append(paths[c]);
        }
        sb.append('/');
        return URLFactory.newURL((String)url.getProtocol(), (String)sb.toString());
    }

    public String getPlatformPathName(URL url) {
        try {
            CompareNode cn = (CompareNode)NodeFactory.find((URL)url);
            if (cn != null) {
                return CompareArb.format("COMPARE_LONG_NAME", cn.getSource().getLongLabel(), cn.getTarget().getLongLabel());
            }
            return CompareArb.get("COMPARE_UNKNOWN");
        }
        catch (Exception e) {
            return "";
        }
    }

    public InputStream openInputStream(URL url) {
        return new ByteArrayInputStream(new byte[0]);
    }
}

