/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLNode;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLSchemaHelper;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLTree;
import oracle.dbtools.rdfgraph.r2rml.language.TermMapNode;
import oracle.dbtools.rdfgraph.r2rml.language.TriplesMapNode;
import oracle.dbtools.rdfgraph.utils.RDFStatement;
import oracle.dbtools.rdfgraph.utils.RDFStatementIterator;
import oracle.dbtools.util.Logger;

public class R2RMLTreeBuilder {
    private RDFStatementIterator iterator;
    private LinkedHashMap<String, R2RMLNode> triplesMaps = new LinkedHashMap();
    private LinkedHashMap<String, R2RMLNode> allNodes = new LinkedHashMap();
    final String ROOT_EDGE_URI = "<root-edge>";

    public void setIterator(RDFStatementIterator rDFStatementIterator) {
        this.iterator = rDFStatementIterator;
    }

    public RDFStatementIterator getIterator() {
        return this.iterator;
    }

    public R2RMLTreeBuilder() {
    }

    public R2RMLTreeBuilder(RDFStatementIterator rDFStatementIterator) {
        this();
        this.iterator = rDFStatementIterator;
    }

    /*
     * WARNING - void declaration
     */
    public R2RMLTree buildTree() {
        Object object;
        String string;
        Object object3;
        R2RMLTree r2RMLTree = new R2RMLTree();
        ArrayList<Iterator<R2RMLNode>> arrayList = new ArrayList<Iterator<R2RMLNode>>();
        if (this.iterator == null) {
            throw new IllegalStateException("RDFStatement Iterator is null");
        }
        while (this.iterator.hasNext()) {
            void var5_14;
            void var5_17;
            void object4;
            Constructor<? extends R2RMLNode> constructor;
            Class<? extends R2RMLNode> clazz;
            void var4_7;
            object3 = this.iterator.next();
            arrayList.add((Iterator<R2RMLNode>)object3);
            Object var4_5 = null;
            Object var5_15 = null;
            string = ((RDFStatement)object3).getRDFTerms()[0];
            object = ((RDFStatement)object3).getRDFTerms()[1];
            String string2 = ((RDFStatement)object3).getRDFTerms()[2];
            R2RMLSchemaHelper.DomainRange domainRange = R2RMLSchemaHelper.getDomainRange((String)object);
            if (this.allNodes.containsKey(string)) {
                R2RMLNode r2RMLNode = this.allNodes.get(string);
            }
            if (var4_7 == null || var4_7.getClass().equals(R2RMLNode.class) || var4_7.getClass().equals(TermMapNode.class)) {
                try {
                    clazz = domainRange.getDomainClass();
                    constructor = clazz.getConstructor(String.class);
                    R2RMLNode r2RMLNode = constructor.newInstance(string);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    Logger.severe(this.getClass(), (String)RdfgraphArb.getString("R2RMLTreeBuilder.ErrorBuildTree"), (Throwable)reflectiveOperationException);
                }
                this.allNodes.put(string, (R2RMLNode)object4);
            }
            if (object4 instanceof TriplesMapNode && !this.triplesMaps.containsKey(string)) {
                this.triplesMaps.put(string, (R2RMLNode)object4);
            }
            if (this.allNodes.containsKey(string2)) {
                R2RMLNode r2RMLNode = this.allNodes.get(string2);
            }
            if (var5_17 != null && !var5_17.getClass().equals(R2RMLNode.class) && !var5_17.getClass().equals(TermMapNode.class)) continue;
            try {
                clazz = domainRange.getRangeClass();
                constructor = clazz.getConstructor(String.class);
                R2RMLNode r2RMLNode = constructor.newInstance(string2);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                Logger.severe(this.getClass(), (String)RdfgraphArb.getString("R2RMLTreeBuilder.ErrorBuildTree"), (Throwable)reflectiveOperationException);
            }
            this.allNodes.put(string2, (R2RMLNode)var5_14);
        }
        for (RDFStatement rDFStatement : arrayList) {
            R2RMLNode r2RMLNode = this.allNodes.get(rDFStatement.getRDFTerms()[0]);
            string = rDFStatement.getRDFTerms()[1];
            object = this.allNodes.get(rDFStatement.getRDFTerms()[2]);
            r2RMLNode.addChildEdge(string, (R2RMLNode)object);
        }
        for (R2RMLNode r2RMLNode : this.allNodes.values()) {
            r2RMLNode.compile();
        }
        object3 = r2RMLTree.getRoot();
        for (Map.Entry<String, R2RMLNode> entry : this.triplesMaps.entrySet()) {
            ((R2RMLNode)object3).addChildEdge("<root-edge>", entry.getValue());
        }
        return r2RMLTree;
    }
}

