/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.ui.AbstractRDFActionDialog;
import oracle.dbtools.rdfgraph.utils.RDFStringUtils;

public class CreateRegularModelActionDialog
extends AbstractRDFActionDialog {
    private TextBoxActionControl txtModelName;
    private SqlComboBoxActionControl selectAppTable;
    private SqlComboBoxActionControl selectColumnName;
    private SqlComboBoxActionControl selectTablespace;
    private boolean is_19_3_OrAfter = false;
    private boolean is_19_x_butNot_012 = false;

    protected List<ActionControl> createControls(final Connection connection) {
        Object object;
        Object object2;
        this.setConnection(connection);
        this.txtModelName = new TextBoxActionControl("model_name", RdfgraphArb.getString("MODEL_NAME"), "");
        if (this.is19cOrAfter) {
            object2 = this.nodeObj.getDBVersion();
            try {
                object = connection.getMetaData();
                object2 = object.getDatabaseProductVersion();
                int n = ((String)object2).toUpperCase().indexOf("VERSION ");
                if (n > -1) {
                    object2 = "Oracle Database " + ((String)object2).substring(n);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (((String)object2).indexOf(" 19.0") <= -1 && ((String)object2).indexOf(" 19.1.") <= -1 && ((String)object2).indexOf(" 19.2.") <= -1) {
                this.is_19_3_OrAfter = true;
            }
            if (((String)object2).indexOf(" 19.") > -1 && ((String)object2).indexOf(" 19.0") <= -1 && ((String)object2).indexOf(" 19.1.") <= -1 && ((String)object2).indexOf(" 19.2.") <= -1) {
                this.is_19_x_butNot_012 = true;
            }
        }
        object2 = "SELECT tablespace_name FROM user_tablespaces order by tablespace_name";
        this.selectTablespace = new SqlComboBoxActionControl("tablespace_name", RdfgraphArb.getString("TABLESPACE"), connection, (String)object2, "");
        this.selectTablespace.enableEditBox();
        if (!this.is_19_3_OrAfter || this.txtNetworkOwner.getValue().get().equalsIgnoreCase("MDSYS")) {
            object = "SELECT '* Create new <Model_Name>_TPL table *' FROM SYS.DUAL \n                         UNION ALL \n                         (SELECT DISTINCT t.TABLE_NAME \n                          FROM USER_TABLES t, USER_TAB_COLUMNS c\n                          WHERE t.TABLE_NAME = c.TABLE_NAME\n                          AND c.DATA_TYPE = 'SDO_RDF_TRIPLE_S')";
            this.selectAppTable = new SqlComboBoxActionControl("application_table", RdfgraphArb.getString("APPLICATION_TABLE"), connection, (String)object, "");
            this.selectAppTable.enableEditBox();
            this.selectAppTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = "select 'TRIPLE' \nfrom sys.dual\nwhere " + RDFStringUtils.enquoteLiteral(CreateRegularModelActionDialog.this.selectAppTable.getValue().get()) + " = '* Create new <Model_Name>_TPL table *'\nunion all\nselect column_name\nfrom    user_tab_columns \nwhere table_name = " + RDFStringUtils.enquoteLiteral(CreateRegularModelActionDialog.this.selectAppTable.getValue().get()) + "\nAND data_type = 'SDO_RDF_TRIPLE_S'";
                    CreateRegularModelActionDialog.this.selectColumnName.resetQuery(connection, string, null, null);
                }
            });
            String string = "select 'TRIPLE' from sys.dual";
            this.selectColumnName = new SqlComboBoxActionControl("column_name", RdfgraphArb.getString("COLUMN_NAME"), connection, string, "");
            this.selectColumnName.enableEditBox();
            ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){
                {
                    this.add(CreateRegularModelActionDialog.this.txtNetworkOwner);
                    this.add(CreateRegularModelActionDialog.this.txtNetworkName);
                    this.add(CreateRegularModelActionDialog.this.txtModelName);
                    this.add(CreateRegularModelActionDialog.this.selectAppTable);
                    this.add(CreateRegularModelActionDialog.this.selectColumnName);
                    this.add(CreateRegularModelActionDialog.this.selectTablespace);
                }
            };
            return arrayList;
        }
        object = new ArrayList<ActionControl>(){
            {
                this.add(CreateRegularModelActionDialog.this.txtNetworkOwner);
                this.add(CreateRegularModelActionDialog.this.txtNetworkName);
                this.add(CreateRegularModelActionDialog.this.txtModelName);
                this.add(CreateRegularModelActionDialog.this.selectTablespace);
            }
        };
        return object;
    }

    protected String getScript(ActionDialog.Values values) {
        String string = this.getQuery(this.connection, "CREATE_REGULAR_MODEL");
        if (this.is_19_x_butNot_012) {
            string = "BEGIN\n  IF (#network_owner# = 'MDSYS') THEN\n    IF ('#application_table#' = '* Create new <Model_Name>_TPL table *') THEN\n      EXECUTE IMMEDIATE\n          'CREATE TABLE #model_name#_TPL(TRIPLE SDO_RDF_TRIPLE_S) #COMPRESS#';\n      EXECUTE IMMEDIATE\n          'GRANT INSERT ON #model_name#_TPL TO MDSYS';\n      EXECUTE IMMEDIATE\n          'CREATE INDEX #model_name#_IDX$ ON #model_name#_TPL app (\n              BITAND(app.TRIPLE.rdf_m_id,79228162514264337589248983040)/4294967296,\n              app.TRIPLE.rdf_s_id,\n              app.TRIPLE.rdf_p_id,\n              app.TRIPLE.rdf_c_id)\n              #COMPRESS#';\n      SEM_APIS.CREATE_SEM_MODEL('#model_name#', '#model_name#_TPL', 'TRIPLE', '#tablespace_name#',network_owner=>#network_owner#,network_name=>#network_name#); \n    ELSE                  \n      SEM_APIS.CREATE_SEM_MODEL('#model_name#', '#application_table#', '#column_name#', '#tablespace_name#',network_owner=>#network_owner#,network_name=>#network_name#); \n    END IF;  \n  ELSE\n    SEM_APIS.CREATE_SEM_MODEL('#model_name#', null, null, '#tablespace_name#',network_owner=>#network_owner#,network_name=>#network_name#);\n  END IF;\nEND;";
        }
        string = RDFStringUtils.updateScriptCompression(string, this.isCompressionEnabled);
        string = this.updateScriptNetworkInfo(string, values);
        string = string.replaceAll("#model_name#", values.get("model_name"));
        string = string.replaceAll("#tablespace_name#", values.get("tablespace_name"));
        String string2 = values.get("network_owner");
        if (!this.is_19_3_OrAfter || string2 != null && string2.equalsIgnoreCase("MDSYS")) {
            string = string.replaceAll("#application_table#", values.get("application_table"));
            string = string.replaceAll("#column_name#", values.get("column_name"));
        }
        return string;
    }

    protected String getTitle() {
        return RdfgraphArb.getString("CreateRegularModelActionDialog.CREATE_REGULAR_MODEL");
    }
}

