/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.ui;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.PropertyPanelActionControl;
import oracle.dbtools.raptor.ui.controls.StringShuttleControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.ui.AbstractRDFActionDialog;
import oracle.dbtools.rdfgraph.ui.RDFSourceTable;
import oracle.dbtools.rdfgraph.utils.ParamListGenerator;

public class CreateRDFViewDMAction
extends AbstractRDFActionDialog {
    private TextBoxActionControl txtModelName;
    private TextBoxActionControl txtURLPrefix;
    private BooleanCheckBoxActionControl chkCONFORMANCE;
    private BooleanCheckBoxActionControl chkGENERATE_ONLY;
    private BooleanCheckBoxActionControl chkKEY_BASED_REF_PROPERTY;
    private BooleanCheckBoxActionControl chkSCALAR_COLUMNS_ONLY;
    private TextBoxActionControl txtAddtionalFlags;
    List<RDFSourceTable> selectedTables;
    StringShuttleControl shtTables;
    String userName;

    protected List<ActionDialogTab> createAdditionalTabs() {
        final ActionDialogTab actionDialogTab = new ActionDialogTab("source_tables", RdfgraphArb.getString("CreateRDFViewDMAction.SOURCE_TABLES")){

            protected List<ActionControl> createControls(final Connection connection) {
                ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){
                    {
                        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                        String string = "SELECT table_name from user_tables where table_name not like '%#%' and table_name not like '%$%' and table_name not like 'SYS_%'";
                        List list = dBUtil.executeReturnList(string, Collections.emptyMap()).stream().map(map -> (String)map.get("TABLE_NAME")).collect(Collectors.toList());
                        CreateRDFViewDMAction.this.shtTables = new StringShuttleControl("tables", "", list, Collections.emptyList());
                        this.add(CreateRDFViewDMAction.this.shtTables);
                    }
                };
                return arrayList;
            }
        };
        ArrayList<ActionDialogTab> arrayList = new ArrayList<ActionDialogTab>(){
            {
                this.add(actionDialogTab);
            }
        };
        return arrayList;
    }

    protected List<ActionControl> createControls(Connection connection) {
        this.setConnection(connection);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("NAME", this.getObjectName());
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        this.userName = dBUtil.executeOracleReturnOneCol(this.getQuery(connection, "getUser"), hashMap);
        this.txtModelName = new TextBoxActionControl("model_name", RdfgraphArb.getString("CreateRDFViewDMAction.MODEL_NAME"), "modelDM");
        this.txtURLPrefix = new TextBoxActionControl("url_prefix", RdfgraphArb.getString("CreateRDFViewDMAction.URL_PREFIX"), "http://example.org/");
        final PropertyPanelActionControl propertyPanelActionControl = new PropertyPanelActionControl("options", null);
        JPanel jPanel = propertyPanelActionControl.getUI();
        jPanel.setBorder(BorderFactory.createTitledBorder(RdfgraphArb.getString("OPTIONS")));
        this.chkCONFORMANCE = new BooleanCheckBoxActionControl("CONFORMANCE", "CONFORMANCE=T", false, false);
        this.chkGENERATE_ONLY = new BooleanCheckBoxActionControl("GENERATE_ONLY", "GENERATE_ONLY=T", false, false);
        this.chkKEY_BASED_REF_PROPERTY = new BooleanCheckBoxActionControl("KEY_BASED_REF_PROPERTY", "KEY_BASED_REF_PROPERTY=T", false, false);
        this.chkSCALAR_COLUMNS_ONLY = new BooleanCheckBoxActionControl("SCALAR_COLUMNS_ONLY", "SCALAR_COLUMNS_ONLY=T", false, false);
        this.txtAddtionalFlags = new TextBoxActionControl("additional_flags", RdfgraphArb.getString("CreateRDFViewDMAction.ADDITIONAL_FLAGS"), "");
        propertyPanelActionControl.addChildControls((List)new ArrayList<ActionControl>(){
            {
                this.add(CreateRDFViewDMAction.this.chkCONFORMANCE);
                this.add(CreateRDFViewDMAction.this.chkGENERATE_ONLY);
                this.add(CreateRDFViewDMAction.this.chkKEY_BASED_REF_PROPERTY);
                this.add(CreateRDFViewDMAction.this.chkSCALAR_COLUMNS_ONLY);
                this.add(CreateRDFViewDMAction.this.txtAddtionalFlags);
            }
        });
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){
            {
                this.add(CreateRDFViewDMAction.this.txtNetworkOwner);
                this.add(CreateRDFViewDMAction.this.txtNetworkName);
                this.add(CreateRDFViewDMAction.this.txtModelName);
                this.add(CreateRDFViewDMAction.this.txtURLPrefix);
                this.add(propertyPanelActionControl);
            }
        };
        return arrayList;
    }

    public String getScript(ActionDialog.Values values) {
        String string = this.getQuery(this.connection, "CREATE_RDFVIEW_DM");
        string = this.updateScriptNetworkInfo(string, values);
        string = string.replaceAll("#model_name#", values.get("model_name"));
        List list = this.shtTables.getValue().getList("selected");
        this.selectedTables = new ArrayList<RDFSourceTable>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                this.selectedTables.add(new RDFSourceTable(this.userName, (String)list.get(i)));
            }
        }
        string = string.replaceAll("#table_list#", ParamListGenerator.getSelectedTablesODCIVarchar2List(this.selectedTables));
        string = string.replaceAll("#prefix#", values.get("url_prefix"));
        string = string.replaceAll("#options#", this.getOptionsString(values));
        return string;
    }

    public String getOptionsString(ActionDialog.Values values) {
        StringBuilder stringBuilder = new StringBuilder();
        if (values.get("options/KEY_BASED_REF_PROPERTY").equals("true")) {
            stringBuilder.append(" KEY_BASED_REF_PROPERTY ");
        }
        if (values.get("options/SCALAR_COLUMNS_ONLY").equals("true")) {
            stringBuilder.append(" SCALAR_COLUMNS_ONLY=T ");
        }
        if (values.get("options/CONFORMANCE").equals("true")) {
            stringBuilder.append(" CONFORMANCE=T ");
        }
        if (values.get("options/GENERATE_ONLY").equals("true")) {
            stringBuilder.append(" GENERATE_ONLY=T ");
        }
        if (values.get("options/additional_flags").trim().length() > 0) {
            stringBuilder.append(" " + values.get("options/additional_flags").trim() + " ");
        }
        if (stringBuilder.length() == 0) {
            return "null";
        }
        return "'" + stringBuilder.toString() + "'";
    }

    protected String getTitle() {
        return RdfgraphArb.getString("CreateRDFViewDMAction.CREATE_RDFVIEW_USING_DIRECT_MAPPING");
    }
}

