/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.ui;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SpinnerActionControl;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.ui.actions.LongActionDialog;
import oracle.dbtools.rdfgraph.utils.PLSQLBlockTemplate;
import oracle.dbtools.rdfgraph.utils.RDFDBUtils;
import oracle.dbtools.rdfgraph.utils.RDFStringUtils;

public class BulkLoadFromStagingActionDialog
extends LongActionDialog {
    private String title;
    String uname = "";
    Connection conn;
    boolean is19cOrAfter = false;
    boolean isCompressionEnabled = false;
    DBObject nodeObj = null;
    Map<String, Object> dict = null;
    TextBoxActionControl txtNetworkOwner = null;
    TextBoxActionControl txtNetworkName = null;
    SqlComboBoxActionControl txtModelName;
    BooleanCheckBoxActionControl chkCreateModel;
    TextBoxActionControl txtTableOwner;
    SqlComboBoxActionControl txtTableName;
    SpinnerActionControl spinDOP;
    SpinnerActionControl spinMBVParts;
    BooleanCheckBoxActionControl chkDelDups;
    BooleanCheckBoxActionControl chkMBVMethod;
    BooleanCheckBoxActionControl chkParse;
    TextBoxActionControl txtFlags;
    BooleanCheckBoxActionControl chkIdxRebuild;
    BooleanCheckBoxActionControl chkDebug;
    BooleanCheckBoxActionControl chkDebugETAB;
    TextBoxActionControl txtStartComment;
    TextBoxActionControl txtEndComment;

    public void setTitle(String string) {
        this.title = string;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setUname(String string) {
        this.uname = string;
    }

    public String getUname() {
        return this.uname;
    }

    public void setConn(Connection connection) {
        this.conn = connection;
        this.nodeObj = this.getDBObject();
        String string = this.nodeObj.getDBVersion();
        this.is19cOrAfter = RDFStringUtils.isOracle19cOrAfter(string);
        this.isCompressionEnabled = RDFDBUtils.isCompressionEnabled(connection);
        this.dict = this.nodeObj.getDictionary();
        this.initializeCoreUIComponents();
    }

    public Connection getConn() {
        return this.conn;
    }

    private void initializeCoreUIComponents() {
        String string = (String)this.dict.get("NETWORK_OWNER");
        String string2 = (String)this.dict.get("NETWORK_NAME");
        if (string.equalsIgnoreCase("MDSYS")) {
            string2 = "";
        }
        this.txtNetworkOwner = new TextBoxActionControl("network_owner", RdfgraphArb.getString("NETWORK_OWNER"), string);
        this.txtNetworkOwner.setEditable(false);
        this.txtNetworkName = new TextBoxActionControl("network_name", RdfgraphArb.getString("NETWORK_NAME"), string2);
        this.txtNetworkName.setEditable(false);
    }

    public BulkLoadFromStagingActionDialog(String string) {
        this.title = string;
    }

    public BulkLoadFromStagingActionDialog() {
        this(RdfgraphArb.getString("BULK_LOAD_MODEL_FROM_STAGING_TABLE"));
    }

    @Override
    protected List<ActionControl> createControls(Connection connection) {
        this.setConn(connection);
        HashMap hashMap = new HashMap();
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        this.uname = dBUtil.executeOracleReturnOneCol(this.getQuery(connection, "getUser"), hashMap);
        String string = (String)this.dict.get("NETWORK_OWNER");
        String string2 = (String)this.dict.get("NETWORK_NAME");
        Object object = "MDSYS.RDF_MODEL$";
        if (!string.toUpperCase().equals("MDSYS")) {
            object = RDFStringUtils.enquoteName(string) + "." + RDFStringUtils.enquoteName(string2 + "#RDF_MODEL$");
        }
        String string3 = "SELECT model_name FROM " + (String)object;
        this.txtModelName = new SqlComboBoxActionControl("model_name", RdfgraphArb.getString("MODEL"), connection, string3, "");
        this.txtModelName.enableEditBox();
        this.chkCreateModel = new BooleanCheckBoxActionControl("create_model", RdfgraphArb.getString("BulkLoadFromStagingActionDialog.CREATE_MODEL"), false);
        this.txtTableOwner = new TextBoxActionControl("table_owner", RdfgraphArb.getString("BulkLoadFromStagingActionDialog.STAGING_TABLE_OWNER_"), this.uname);
        String string4 = "select table_name from (select table_name, listagg(column_name,',') within group(order by column_name) cols from user_tab_cols group by table_name)  where  cols in ('RDF$STC_GRAPH,RDF$STC_OBJ,RDF$STC_PRED,RDF$STC_SUB','RDF$STC_OBJ,RDF$STC_PRED,RDF$STC_SUB')  order by table_name";
        this.txtTableName = new SqlComboBoxActionControl("table_name", RdfgraphArb.getString("BulkLoadFromStagingActionDialog.STAGING_TABLE_NAME_"), connection, string4);
        this.spinDOP = new SpinnerActionControl("dop", "PARALLEL", Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(512), Integer.valueOf(1));
        this.spinMBVParts = new SpinnerActionControl("mbv_parts", "MBV_PARTITIONS", Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(512), Integer.valueOf(1));
        this.chkDelDups = new BooleanCheckBoxActionControl("del_dups", "DEL_BATCH_DUPS=USE_INSERT", false);
        this.chkMBVMethod = new BooleanCheckBoxActionControl("mbv_method", "MBV_METHOD=SHADOW", false);
        this.chkParse = new BooleanCheckBoxActionControl("parse", "PARSE=T", true);
        this.chkParse.getUI().setEnabled(false);
        this.txtFlags = new TextBoxActionControl("flags", "Additional flags:", " ");
        this.chkDebugETAB = new BooleanCheckBoxActionControl("create_et_tab", RdfgraphArb.getString("BulkLoadFromStagingActionDialog.CREATE_EVENT_TRACE_TABLE"), false);
        this.chkIdxRebuild = new BooleanCheckBoxActionControl("atabIdxRebuild", "Rebuild application table indexes:", true);
        this.chkDebug = new BooleanCheckBoxActionControl("debug", RdfgraphArb.getString("BulkLoadFromStagingActionDialog.DEBUG_"), false);
        this.txtStartComment = new TextBoxActionControl("start_comment", RdfgraphArb.getString("START_COMMENT_"), "");
        this.txtEndComment = new TextBoxActionControl("end_comment", RdfgraphArb.getString("END_COMMENT_"), "");
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){
            {
                this.add(BulkLoadFromStagingActionDialog.this.txtNetworkOwner);
                this.add(BulkLoadFromStagingActionDialog.this.txtNetworkName);
                this.add(BulkLoadFromStagingActionDialog.this.txtModelName);
                this.add(BulkLoadFromStagingActionDialog.this.chkCreateModel);
                this.add(BulkLoadFromStagingActionDialog.this.txtTableOwner);
                this.add(BulkLoadFromStagingActionDialog.this.txtTableName);
                this.add(BulkLoadFromStagingActionDialog.this.spinDOP);
                this.add(BulkLoadFromStagingActionDialog.this.chkMBVMethod);
                this.add(BulkLoadFromStagingActionDialog.this.chkDelDups);
                this.add(BulkLoadFromStagingActionDialog.this.spinMBVParts);
                this.add(BulkLoadFromStagingActionDialog.this.chkParse);
                this.add(BulkLoadFromStagingActionDialog.this.chkIdxRebuild);
                this.add(BulkLoadFromStagingActionDialog.this.txtFlags);
                this.add(BulkLoadFromStagingActionDialog.this.chkDebugETAB);
                this.add(BulkLoadFromStagingActionDialog.this.chkDebug);
                this.add(BulkLoadFromStagingActionDialog.this.txtStartComment);
                this.add(BulkLoadFromStagingActionDialog.this.txtEndComment);
            }
        };
        return arrayList;
    }

    @Override
    protected String getScript(LongActionDialog.Values values) {
        int n;
        Object object;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = values.get("create_model").equals("true");
        boolean bl2 = values.get("create_et_tab").equals("true");
        boolean bl3 = values.get("atabIdxRebuild").equals("true");
        boolean bl4 = values.get("del_dups").equals("true");
        boolean bl5 = values.get("mbv_method").equals("true");
        boolean bl6 = values.get("parse").equals("true");
        boolean bl7 = false;
        boolean bl8 = false;
        if (this.is19cOrAfter) {
            object2 = this.nodeObj.getDBVersion();
            try {
                object = this.conn.getMetaData();
                object2 = object.getDatabaseProductVersion();
                int n2 = ((String)object2).toUpperCase().indexOf("VERSION ");
                if (n2 > -1) {
                    object2 = "Oracle Database " + ((String)object2).substring(n2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (((String)object2).indexOf(" 19.0") <= -1 && ((String)object2).indexOf(" 19.1.") <= -1 && ((String)object2).indexOf(" 19.2.") <= -1) {
                bl7 = true;
            }
            if (((String)object2).indexOf(" 19.") > -1 && ((String)object2).indexOf(" 19.0") <= -1 && ((String)object2).indexOf(" 19.1.") <= -1 && ((String)object2).indexOf(" 19.2.") <= -1) {
                bl8 = true;
            }
        }
        object2 = new PLSQLBlockTemplate(this.getQuery(this.conn, "CREATE_ET_TAB"));
        if (bl2) {
            stringBuilder.append(((PLSQLBlockTemplate)object2).toString());
        }
        object = this.getQuery(this.conn, "FULL_SIMPLE_CREATE_SEM_MODEL");
        if (bl8) {
            object = "BEGIN\n  IF (#network_owner# = 'MDSYS') THEN\n    EXECUTE IMMEDIATE\n      'CREATE TABLE #model_name#_TPL (TRIPLE SDO_RDF_TRIPLE_S) #COMPRESS#';\n    \n    EXECUTE IMMEDIATE\n      'CREATE INDEX #model_name#_IDX$ ON #model_name#_TPL app (\n        BITAND(app.TRIPLE.rdf_m_id,79228162514264337589248983040)/4294967296,\n        app.TRIPLE.rdf_s_id,\n        app.TRIPLE.rdf_p_id,\n        app.TRIPLE.rdf_c_id)\n      #COMPRESS#';\n    \n    EXECUTE IMMEDIATE\n      'GRANT INSERT on  #model_name#_TPL to MDSYS'; \n    \n    SEM_APIS.CREATE_SEM_MODEL(\n         model_name  => '#model_name#',\n         table_name  => '#model_name#_TPL',\n         column_name => 'TRIPLE',\n         network_owner => #network_owner#,\n         network_name => #network_name#);    \n  ELSE\n    SEM_APIS.CREATE_SEM_MODEL(\n      model_name  => '#model_name#',\n      table_name  => null,\n      column_name => null,\n      network_owner => #network_owner#,\n      network_name => #network_name#); \n  END IF;\nEND;";
        }
        object = RDFStringUtils.updateScriptCompression((String)object, this.isCompressionEnabled);
        PLSQLBlockTemplate pLSQLBlockTemplate = new PLSQLBlockTemplate((String)object);
        pLSQLBlockTemplate.replaceToken("#model_name#", values.get("model_name"), PLSQLBlockTemplate.ParamType.RAW);
        String string = values.get("network_owner");
        String string2 = values.get("network_name");
        if (this.is19cOrAfter) {
            if (string == null || string.trim().isEmpty() || string.equalsIgnoreCase("MDSYS")) {
                pLSQLBlockTemplate.replaceToken("#network_owner#", "MDSYS", PLSQLBlockTemplate.ParamType.STRING);
                pLSQLBlockTemplate.replaceToken("#network_name#", "null", PLSQLBlockTemplate.ParamType.RAW);
            } else {
                pLSQLBlockTemplate.replaceToken("#network_owner#", string, PLSQLBlockTemplate.ParamType.STRING);
                pLSQLBlockTemplate.replaceToken("#network_name#", string2, PLSQLBlockTemplate.ParamType.STRING);
            }
        }
        pLSQLBlockTemplate.setEndingSlash(true);
        if (bl) {
            stringBuilder.append(pLSQLBlockTemplate.toString());
        }
        Object object3 = "MDSYS.RDF_MODEL";
        if (string != null && !string.equalsIgnoreCase("MDSYS")) {
            object3 = string + "." + string2 + "#RDF_MODEL";
        }
        if (!bl7 || this.txtNetworkOwner.getValue().get().equalsIgnoreCase("MDSYS")) {
            PLSQLBlockTemplate pLSQLBlockTemplate2 = new PLSQLBlockTemplate(this.getQuery(this.conn, "APP_TAB_IDX_UNUSABLE"));
            pLSQLBlockTemplate2.replaceToken("#models_table#", (String)object3, PLSQLBlockTemplate.ParamType.RAW);
            pLSQLBlockTemplate2.replaceToken("#model_name#", values.get("model_name"), PLSQLBlockTemplate.ParamType.STRING);
            pLSQLBlockTemplate2.setEndingSlash(true);
            if (bl3) {
                stringBuilder.append(pLSQLBlockTemplate2.toString());
            }
        }
        int n3 = Integer.parseInt(values.get("dop"));
        Object object4 = values.get("flags");
        if (n3 > 1) {
            object4 = (String)object4 + " PARALLEL=" + n3 + " ";
        }
        if ((n = Integer.parseInt(values.get("mbv_parts"))) > 1) {
            object4 = (String)object4 + " MBV_PARTITIONS=" + n + " ";
        }
        if (bl4) {
            object4 = (String)object4 + " DEL_BATCH_DUPS=USE_INSERT ";
        }
        if (bl5) {
            object4 = (String)object4 + " MBV_METHOD=SHADOW ";
        }
        if (bl6) {
            object4 = (String)object4 + " PARSE ";
        }
        PLSQLBlockTemplate pLSQLBlockTemplate3 = new PLSQLBlockTemplate(this.getQuery(this.conn, "BULK_LOAD_FROM_STAGING_TABLE"));
        if (this.is19cOrAfter) {
            if (string == null || string.trim().isEmpty() || string.equalsIgnoreCase("MDSYS")) {
                pLSQLBlockTemplate3.replaceToken("#network_owner#", "MDSYS", PLSQLBlockTemplate.ParamType.STRING);
                pLSQLBlockTemplate3.replaceToken("#network_name#", "null", PLSQLBlockTemplate.ParamType.RAW);
            } else {
                pLSQLBlockTemplate3.replaceToken("#network_owner#", string, PLSQLBlockTemplate.ParamType.STRING);
                pLSQLBlockTemplate3.replaceToken("#network_name#", string2, PLSQLBlockTemplate.ParamType.STRING);
            }
        }
        pLSQLBlockTemplate3.replaceToken("#model_name#", values.get("model_name"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate3.replaceToken("#table_owner#", values.get("table_owner"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate3.replaceToken("#table_name#", values.get("table_name"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate3.replaceToken("#table_owner_raw#", values.get("table_owner"), PLSQLBlockTemplate.ParamType.RAW);
        pLSQLBlockTemplate3.replaceToken("#table_name_raw#", values.get("table_name"), PLSQLBlockTemplate.ParamType.RAW);
        pLSQLBlockTemplate3.replaceToken("#flags#", (String)object4, PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate3.replaceToken("#start_comment#", values.get("start_comment"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate3.replaceToken("#end_comment#", values.get("end_comment"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate3.setEndingSlash(true);
        stringBuilder.append(pLSQLBlockTemplate3.toString());
        if (!bl7 || this.txtNetworkOwner.getValue().get().equalsIgnoreCase("MDSYS")) {
            String string3 = this.getQuery(this.conn, "APP_TAB_IDX_REBUILD");
            string3 = RDFStringUtils.updateScriptCompression(string3, this.isCompressionEnabled);
            PLSQLBlockTemplate pLSQLBlockTemplate4 = new PLSQLBlockTemplate(string3);
            pLSQLBlockTemplate4.replaceToken("#models_table#", (String)object3, PLSQLBlockTemplate.ParamType.RAW);
            pLSQLBlockTemplate4.replaceToken("#model_name#", values.get("model_name"), PLSQLBlockTemplate.ParamType.STRING);
            pLSQLBlockTemplate4.replaceToken("#parallel#", Integer.toString(n3), PLSQLBlockTemplate.ParamType.STRING);
            pLSQLBlockTemplate4.setEndingSlash(true);
            if (bl3) {
                stringBuilder.append(pLSQLBlockTemplate4.toString());
            }
        }
        return stringBuilder.toString();
    }

    @Override
    protected String getHelpId() {
        return "rdfplugin-intro__GUID-55FCF41F-62F0-4B5E-BEF6-2C43A280C02F";
    }
}

