/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.sparql.language;

import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.plsql.SqlTokens;

public class SPARQLBraceLexer
extends AbstractLexer
implements SqlTokens {
    protected int startOffset = -1;
    protected int endOffset = -1;
    protected int lastToken;

    public SPARQLBraceLexer() {
        this.setTextBuffer(null);
        this.setPosition(0);
    }

    public int lex(LexerToken lexerToken) {
        block14: {
            this.lastToken = 0;
            try {
                while (true) {
                    this.startOffset = this.currentPos;
                    char c = this.textBuffer.getChar(this.currentPos++);
                    switch (c) {
                        case '#': {
                            this.skipSingleLineComment();
                            break;
                        }
                        case '\"': {
                            this.skipDoubleQuoteLiteral();
                            break;
                        }
                        case '\'': {
                            this.skipSingleQuoteLiteral();
                            break;
                        }
                        case '(': {
                            this.lastToken = 80;
                            break block14;
                        }
                        case ')': {
                            this.lastToken = 92;
                            break block14;
                        }
                        case '{': {
                            this.lastToken = 78;
                            break block14;
                        }
                        case '}': {
                            this.lastToken = 91;
                            break block14;
                        }
                        case '[': {
                            this.lastToken = 78;
                            break block14;
                        }
                        case ']': {
                            this.lastToken = 91;
                            break block14;
                        }
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.currentPos = this.textBuffer.getLength();
                if (this.lastToken != 0) break block14;
                this.startOffset = this.currentPos;
            }
        }
        this.endOffset = this.currentPos;
        return this.fillLexerToken(lexerToken);
    }

    private int fillLexerToken(LexerToken lexerToken) {
        if (lexerToken == null) {
            return this.lastToken;
        }
        AbstractLexer.DefaultLexerToken defaultLexerToken = (AbstractLexer.DefaultLexerToken)lexerToken;
        defaultLexerToken.setToken(this.lastToken);
        defaultLexerToken.setStartOffset(this.startOffset);
        defaultLexerToken.setEndOffset(this.endOffset);
        return this.lastToken;
    }

    public void backup() {
    }

    private void skipSingleLineComment() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos);
            switch (c) {
                case '\n': 
                case '\r': {
                    return;
                }
            }
            ++this.currentPos;
        }
    }

    private void skipDoubleQuoteLiteral() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case '\"': {
                    c = this.textBuffer.getChar(this.currentPos);
                    if (c != '\"') {
                        return;
                    }
                    ++this.currentPos;
                }
            }
        }
    }

    private void skipSingleQuoteLiteral() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case '\'': {
                    c = this.textBuffer.getChar(this.currentPos);
                    if (c != '\'') {
                        return;
                    }
                    ++this.currentPos;
                }
            }
        }
    }
}

