/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.sparql.editor;

public final class SPARQLErrorInfo {
    private int _line = 0;
    private int _col = 0;
    private int _abs_offset_begin = 0;
    private int _abs_offset_end = 0;
    private String _errMsg = null;
    private String _errorType = null;
    public static final String COMPILED_WITH_ERROR = "COMPILED_WITH_ERROR";
    public static final String COMPILED_WITH_WARNING = "COMPILED_WITH_WARNING";
    public static final String UNABLE_TO_COMPILE = "UNABLE_TO_COMPILE";

    public SPARQLErrorInfo(int n, int n2, int n3, int n4, String string) {
        this(n, n2, n3, n4, string, COMPILED_WITH_ERROR);
    }

    public SPARQLErrorInfo(int n, int n2, int n3, int n4, String string, String string2) {
        this._line = n;
        this._col = n2;
        this._errMsg = string;
        this._errorType = string2;
        this._abs_offset_begin = n3;
        this._abs_offset_end = n4;
    }

    public int getLineNumber() {
        return this._line;
    }

    public int getColumn() {
        return this._col;
    }

    public int getAbsolulteOffsetBegin() {
        return this._abs_offset_begin;
    }

    public int getAbsolulteOffsetEnd() {
        return this._abs_offset_end;
    }

    public String getErrorMessage() {
        return null == this._errMsg ? "" : this._errMsg;
    }

    public boolean isWarning() {
        boolean bl = false;
        if (this._errorType.equalsIgnoreCase(COMPILED_WITH_WARNING)) {
            bl = true;
        }
        return bl;
    }

    public boolean isFatal() {
        boolean bl = false;
        if (this._errorType.equalsIgnoreCase(UNABLE_TO_COMPILE)) {
            bl = true;
        }
        return bl;
    }
}

