/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.sparql.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.panels.ShuttlePanel;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.sparql.SPARQLArb;

public class ModelSelectionDialog
extends JDialog
implements LayoutControl {
    private List<String> sources;
    private List<String> initialList = null;
    private JButton okButton;
    private JButton cancelButton;
    private JButton helpButton;
    private Action okAction;
    private Action cancelAction;
    private Action helpAction;
    private ShuttlePanel shuttle;
    private Connection connection;
    private String networkOwner;
    private String networkName;
    private String helpTopicID;
    private JPanel panel;

    private ModelSelectionDialog(Window window, Component component, List<String> list, Connection connection, String string, String string2) {
        super(window);
        this.connection = connection;
        this.initialList = list;
        this.networkOwner = string;
        this.networkName = string2;
        this.setName("ModelSelectionDialog");
        this.setModal(true);
        this.setLocationRelativeTo(component);
        this.setTitle(SPARQLArb.getString("MODEL_S"));
        this.initUI();
    }

    private void initUI() {
        this.okAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelSelectionDialog.this.sources = ModelSelectionDialog.this.shuttle.getSelected();
                ModelSelectionDialog.this.setVisible(false);
            }
        };
        this.cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelSelectionDialog.this.sources = ModelSelectionDialog.this.initialList;
                ModelSelectionDialog.this.dispose();
            }
        };
        this.helpAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        this.okButton = new JButton();
        this.okButton.setName("okButton");
        this.cancelButton = new JButton();
        this.cancelButton.setName("cancelButton");
        this.helpButton = new JButton();
        this.helpButton.setName("helpButton");
        this.shuttle = this.initShuttle();
        this.shuttle.setName("shuttle");
        this.helpButton.setAction(this.helpAction);
        this.helpButton.setText(StringUtils.stripMnemonic((String)RdfgraphArb.getString("DIALOG_HELP_BUTTON_TEXT")));
        this.helpButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)RdfgraphArb.get("DIALOG_HELP_BUTTON_TEXT")));
        this.okButton.setAction(this.okAction);
        this.okButton.setText(RdfgraphArb.getString("DIALOG_OK_BUTTON_TEXT"));
        this.cancelButton.setAction(this.cancelAction);
        this.cancelButton.setText(RdfgraphArb.getString("DIALOG_CANCEL_BUTTON_TEXT"));
        this.panel = new JPanel();
        this.panel.setName("panel");
        this.getContentPane().add(LayoutControl.GBC.createDialogMainPanel((Component)this.panel));
        this.panel.setLayout(new GridBagLayout());
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        dialogButtonBar.add((Component)this.okButton, DialogButtonBar.CONSTRAINT_APPLY);
        dialogButtonBar.add((Component)this.cancelButton, DialogButtonBar.CONSTRAINT_CANCEL);
        dialogButtonBar.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
        GridBagConstraints gridBagConstraints = LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panel.add((Component)this.shuttle.getPanel(), gridBagConstraints);
        gridBagConstraints = LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X);
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.panel.add((Component)dialogButtonBar, gridBagConstraints);
    }

    private ShuttlePanel initShuttle() {
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.getConnection());
        Object object = "SELECT model_name from MDSYS.RDF_MODEL$";
        if (this.networkOwner != null && !this.networkOwner.equalsIgnoreCase("MDSYS")) {
            object = "SELECT model_name from " + this.networkOwner + "." + this.networkName + "#RDF_MODEL$";
        }
        List list = dBUtil.executeReturnList((String)object, Collections.emptyMap()).stream().map(map -> (String)map.get("MODEL_NAME")).collect(Collectors.toList());
        list.removeAll(this.initialList);
        this.shuttle = new ShuttlePanel(list, this.initialList);
        return this.shuttle;
    }

    public static List<String> showDialog(Window window, Component component, List<String> list, Connection connection, String string, String string2) {
        ModelSelectionDialog modelSelectionDialog = new ModelSelectionDialog(window, component, list, connection, string, string2);
        modelSelectionDialog.pack();
        modelSelectionDialog.setVisible(true);
        return modelSelectionDialog.getSelectedSources();
    }

    private List<String> getSelectedSources() {
        return this.sources;
    }

    public Connection getConnection() {
        return this.connection;
    }
}

