/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.r2rml.language;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import oracle.dbtools.rdfgraph.r2rml.R2RMLArb;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLNode;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLRootNode;
import oracle.dbtools.rdfgraph.r2rml.language.TriplesMapNode;
import oracle.dbtools.rdfgraph.utils.RDFPrefixManager;
import oracle.dbtools.rdfgraph.utils.RDFStatement;
import oracle.dbtools.util.Pair;

public class R2RMLTree {
    R2RMLNode root = new R2RMLRootNode(R2RMLArb.getString("R2RML_MAPPING"));

    public void setRoot(R2RMLNode r2RMLNode) {
        this.root = r2RMLNode;
    }

    public R2RMLNode getRoot() {
        return this.root;
    }

    public String genR2RMLNTriples(R2RMLNode r2RMLNode) {
        StringBuffer stringBuffer = new StringBuffer();
        Stack<R2RMLNode> stack = new Stack<R2RMLNode>();
        HashMap<R2RMLNode, Iterator> hashMap = new HashMap<R2RMLNode, Iterator>();
        R2RMLNode r2RMLNode2 = r2RMLNode;
        stack.add(r2RMLNode2);
        while (!stack.isEmpty()) {
            Iterator iterator;
            R2RMLNode r2RMLNode3 = (R2RMLNode)stack.pop();
            if (hashMap.containsKey(r2RMLNode3)) {
                iterator = (Iterator)hashMap.get(r2RMLNode3);
            } else {
                iterator = r2RMLNode3.getChildEdges().iterator();
                hashMap.put(r2RMLNode3, iterator);
            }
            if (!iterator.hasNext()) continue;
            Pair pair = (Pair)iterator.next();
            String string = (String)pair.first();
            R2RMLNode r2RMLNode4 = (R2RMLNode)pair.second();
            if (!(r2RMLNode3 instanceof R2RMLRootNode)) {
                stringBuffer.append(r2RMLNode3.getValue() + " " + string + " " + r2RMLNode4.getValue() + " .  \n");
            }
            if (iterator.hasNext()) {
                stack.add(r2RMLNode3);
            }
            if (r2RMLNode3 != r2RMLNode2 && r2RMLNode4 instanceof TriplesMapNode) continue;
            stack.add(r2RMLNode4);
        }
        return stringBuffer.toString();
    }

    public List<RDFStatement> getRDFStatements(R2RMLNode r2RMLNode) {
        ArrayList<RDFStatement> arrayList = new ArrayList<RDFStatement>();
        Stack<R2RMLNode> stack = new Stack<R2RMLNode>();
        HashMap<R2RMLNode, Iterator> hashMap = new HashMap<R2RMLNode, Iterator>();
        R2RMLNode r2RMLNode2 = r2RMLNode;
        stack.add(r2RMLNode2);
        while (!stack.isEmpty()) {
            Iterator iterator;
            R2RMLNode r2RMLNode3 = (R2RMLNode)stack.pop();
            if (hashMap.containsKey(r2RMLNode3)) {
                iterator = (Iterator)hashMap.get(r2RMLNode3);
            } else {
                iterator = r2RMLNode3.getChildEdges().iterator();
                hashMap.put(r2RMLNode3, iterator);
            }
            if (!iterator.hasNext()) continue;
            Pair pair = (Pair)iterator.next();
            String string = (String)pair.first();
            R2RMLNode r2RMLNode4 = (R2RMLNode)pair.second();
            if (!(r2RMLNode3 instanceof R2RMLRootNode)) {
                arrayList.add(new RDFStatement(r2RMLNode3.getValue(), string, r2RMLNode4.getValue()));
            }
            if (iterator.hasNext()) {
                stack.add(r2RMLNode3);
            }
            if (r2RMLNode3 != r2RMLNode2 && r2RMLNode4 instanceof TriplesMapNode) continue;
            stack.add(r2RMLNode4);
        }
        return arrayList;
    }

    public boolean isBnode(String string) {
        return string.startsWith("_:");
    }

    public String getSimpleTurtle(R2RMLNode r2RMLNode) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        List<RDFStatement> list = this.getRDFStatements(r2RMLNode);
        Stack<String> stack = new Stack<String>();
        int n2 = 0;
        stringBuffer.append("@prefix rr: <http://www.w3.org/ns/r2rml#>.");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("@prefix xsd: <http://www.w3.org/2001/XMLSchema> .");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append(System.getProperty("line.separator"));
        String string = null;
        for (RDFStatement rDFStatement : list) {
            int n3;
            if (stack.isEmpty()) {
                n2 = 0;
                stringBuffer.append(RDFPrefixManager.shortenURI(rDFStatement.getRDFTerms()[0]) + " " + RDFPrefixManager.shortenURI(rDFStatement.getRDFTerms()[1]) + " ");
                if (this.isBnode(rDFStatement.getRDFTerms()[2])) {
                    stack.push(rDFStatement.getRDFTerms()[2]);
                    ++n2;
                    stringBuffer.append("[ \n");
                    continue;
                }
                stringBuffer.append(RDFPrefixManager.shortenURI(rDFStatement.getRDFTerms()[2]) + " ; \n");
                continue;
            }
            string = (String)stack.peek();
            if (!this.isBnode(rDFStatement.getRDFTerms()[0])) {
                String string2;
                while (!stack.isEmpty()) {
                    string2 = new String(new char[--n2 * 2]).replace("\u0000", " ");
                    stringBuffer.append(string2 + "]");
                    string = (String)stack.pop();
                    if (stack.empty()) {
                        stringBuffer.append(" . ");
                    }
                    stringBuffer.append("\n");
                }
                string2 = new String(new char[n2 * 2]).replace("\u0000", " ");
                stringBuffer.append(string2 + RDFPrefixManager.shortenURI(rDFStatement.getRDFTerms()[0]) + " " + RDFPrefixManager.shortenURI(rDFStatement.getRDFTerms()[1]) + " ");
            }
            if (this.isBnode(rDFStatement.getRDFTerms()[0]) && string.equals(rDFStatement.getRDFTerms()[0])) {
                String string3 = new String(new char[n2 * 2]).replace("\u0000", " ");
                stringBuffer.append(string3 + RDFPrefixManager.shortenURI(rDFStatement.getRDFTerms()[1]) + " ");
            }
            if (this.isBnode(rDFStatement.getRDFTerms()[0]) && !string.equals(rDFStatement.getRDFTerms()[0]) && (n3 = stack.search(rDFStatement.getRDFTerms()[0])) > -1) {
                String string4 = new String(new char[--n2 * 2]).replace("\u0000", " ");
                stringBuffer.append(string4 + "] ; \n");
                string = (String)stack.pop();
                string4 = new String(new char[n2 * 2]).replace("\u0000", " ");
                stringBuffer.append(string4 + RDFPrefixManager.shortenURI(rDFStatement.getRDFTerms()[1]) + " ");
            }
            if (this.isBnode(rDFStatement.getRDFTerms()[2])) {
                stack.push(rDFStatement.getRDFTerms()[2]);
                ++n2;
                stringBuffer.append("[ \n");
            } else {
                stringBuffer.append(RDFPrefixManager.shortenURI(rDFStatement.getRDFTerms()[2]) + " ; \n");
            }
            ++n;
        }
        while (!stack.isEmpty()) {
            String string5 = new String(new char[--n2 * 2]).replace("\u0000", " ");
            stringBuffer.append((String)string5 + "] \n");
            string = (String)stack.pop();
        }
        stringBuffer.append(".");
        return stringBuffer.toString();
    }

    public TriplesMapNode getTriplesMapByURI(String string) {
        return this.getRoot().getChildren().stream().filter(r2RMLNode -> r2RMLNode.getValue().equals(string)).findFirst().orElse(null);
    }

    public String genR2RMLNTriples() {
        return this.genR2RMLNTriples(this.getRoot());
    }
}

