/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.r2rml.editor.triplesmap;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import oracle.dbtools.rdfgraph.navigator.RdfgraphNavigatorResource;
import oracle.dbtools.rdfgraph.r2rml.R2RMLArb;
import oracle.dbtools.rdfgraph.r2rml.editor.datasource.LogicalTableNodeEditor;
import oracle.dbtools.rdfgraph.r2rml.editor.triplesmap.TriplesMapEditor;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLTree;
import oracle.dbtools.rdfgraph.r2rml.language.TriplesMapNode;
import oracle.javatools.icons.OracleIcons;

public class TriplesMapEditorDialog
extends JDialog
implements ActionListener {
    TriplesMapEditor tmapEditor;
    LogicalTableNodeEditor ltEditor;
    R2RMLTree tree;
    TriplesMapNode tmap;
    Connection connection;
    Frame parent;
    protected EventListenerList listenerList = new EventListenerList();

    public TriplesMapNode getTmap() {
        return this.tmap;
    }

    public void addDataSourceChangeEventListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeDataSourceChangeEventListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    public TriplesMapEditorDialog(Frame frame, R2RMLTree r2RMLTree, TriplesMapNode triplesMapNode, Connection connection) {
        super(frame);
        this.parent = frame;
        this.tree = r2RMLTree;
        this.tmap = triplesMapNode;
        this.connection = connection;
        this.initUI();
    }

    private void initUI() {
        this.setIconImage(RdfgraphNavigatorResource.getImage("RDFGRAPH_ICON"));
        this.tmapEditor = new TriplesMapEditor(this.tree, this.tmap, this.connection);
        this.tmapEditor.addDataSourceChangeEventListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tmapEditor, "Center");
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle(R2RMLArb.getString("TriplesMapEditorDialog.TRIPLESMAP_EDITOR_") + this.tmap.getValue());
        this.setSize(800, 600);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(this.getParent());
        JPanel jPanel = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton(R2RMLArb.getString("TriplesMapEditorDialog.DONE_EDITING"), OracleIcons.getIcon((String)"check.png"));
        jButton.addActionListener(actionEvent -> this.dispose());
        jPanel.add(jButton);
        this.add((Component)jPanel, "South");
    }

    void fireDataSourceChangeEvent(ActionEvent actionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ActionListener.class) continue;
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        actionEvent.setSource(this);
        this.fireDataSourceChangeEvent(actionEvent);
    }
}

