/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.r2rml.editor.triplesmap;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.rdfgraph.r2rml.R2RMLArb;
import oracle.dbtools.rdfgraph.r2rml.editor.datasource.LogicalTableNodeEditor;
import oracle.dbtools.rdfgraph.r2rml.editor.pomap.POMapListEditor;
import oracle.dbtools.rdfgraph.r2rml.editor.subjectmap.SubjectMapNodeEditor;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLTree;
import oracle.dbtools.rdfgraph.r2rml.language.TriplesMapNode;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.language.LanguageModule;

public class TriplesMapEditor
extends JPanel
implements ActionListener,
LayoutControl {
    private R2RMLTree tree;
    private TriplesMapNode tmap;
    private Connection connection;
    private BasicEditorPane rawR2RMLEditor;
    protected EventListenerList listenerList = new EventListenerList();

    public TriplesMapNode getTmap() {
        return this.tmap;
    }

    public void addDataSourceChangeEventListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeDataSourceChangeEventListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    public TriplesMapEditor(R2RMLTree r2RMLTree, TriplesMapNode triplesMapNode, Connection connection) {
        this.tree = r2RMLTree;
        this.tmap = triplesMapNode;
        this.connection = connection;
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new GridBagLayout());
        CustomTabbedPane customTabbedPane = new CustomTabbedPane();
        LogicalTableNodeEditor logicalTableNodeEditor = new LogicalTableNodeEditor(this.tmap.getLogicalTableNode(), this.connection);
        logicalTableNodeEditor.addDataSourceChangeEventListener(this);
        customTabbedPane.addTab(null, R2RMLArb.getString("TriplesMapEditor.DATA_SOURCE"), (Component)LayoutControl.GBC.createTabPanel((Component)logicalTableNodeEditor));
        SubjectMapNodeEditor subjectMapNodeEditor = new SubjectMapNodeEditor(this.tmap, this.tmap.getSubjectMapNode(), this.connection);
        customTabbedPane.addTab(null, R2RMLArb.getString("SUBJECT_MAP"), (Component)LayoutControl.GBC.createTabPanel((Component)subjectMapNodeEditor));
        POMapListEditor pOMapListEditor = new POMapListEditor(this.tree, this.tmap, this.connection);
        customTabbedPane.addTab(null, R2RMLArb.getString("TriplesMapEditor.PREDICATE_OBJECT_MAPS"), (Component)LayoutControl.GBC.createTabPanel((Component)pOMapListEditor));
        this.rawR2RMLEditor = new BasicEditorPane();
        BasicDocument basicDocument = (BasicDocument)this.rawR2RMLEditor.getDocument();
        basicDocument.setLanguageSupport(LanguageModule.createSupportForFileType((String)".sparql"));
        final R2RMLTree r2RMLTree = new R2RMLTree();
        this.rawR2RMLEditor.setText(r2RMLTree.getSimpleTurtle(this.tmap));
        final JScrollPane jScrollPane = new JScrollPane((Component)this.rawR2RMLEditor);
        customTabbedPane.addTab(null, R2RMLArb.getString("R2RML"), (Component)jScrollPane);
        customTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CustomTabbedPane customTabbedPane = (CustomTabbedPane)changeEvent.getSource();
                int n = customTabbedPane.getSelectedIndex();
                if (n == customTabbedPane.getPanelIndex((Component)jScrollPane)) {
                    TriplesMapEditor.this.rawR2RMLEditor.setText(r2RMLTree.getSimpleTurtle(TriplesMapEditor.this.tmap));
                }
            }
        });
        this.add((Component)customTabbedPane, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
    }

    void fireDataSourceChangeEvent(ActionEvent actionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ActionListener.class) continue;
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.removeAll();
        this.initUI();
        this.validate();
    }
}

