/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.r2rml.editor.pomap;

import javax.swing.table.AbstractTableModel;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.r2rml.R2RMLArb;
import oracle.dbtools.rdfgraph.r2rml.language.ColumnNameNode;
import oracle.dbtools.rdfgraph.r2rml.language.GraphMapNode;
import oracle.dbtools.rdfgraph.r2rml.language.PredicateObjectMap;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLNode;
import oracle.dbtools.rdfgraph.r2rml.language.StringTemplateNode;
import oracle.dbtools.rdfgraph.utils.RDFStringUtils;

public class POMapGraphMapTableModel
extends AbstractTableModel {
    private final String[] headers = new String[]{R2RMLArb.getString("GRAPH_MAP_VALUE"), RdfgraphArb.getString("TYPE")};
    private final PredicateObjectMap node;

    public POMapGraphMapTableModel(PredicateObjectMap predicateObjectMap) {
        this.node = predicateObjectMap;
    }

    @Override
    public int getRowCount() {
        return this.node.getGraphMaps().size();
    }

    @Override
    public int getColumnCount() {
        return this.headers.length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                GraphMapNode graphMapNode = (GraphMapNode)this.node.getGraphMaps().get(n);
                return graphMapNode.getSimpleValue();
            }
            case 1: {
                GraphMapNode graphMapNode = (GraphMapNode)this.node.getGraphMaps().get(n);
                return graphMapNode.getMappingType();
            }
        }
        return "NULL";
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        String string = "";
        String string2 = "";
        string = n2 == 0 ? (String)object : (String)this.getValueAt(n, 0);
        string2 = n2 == 1 ? (String)object : (String)this.getValueAt(n, 1);
        GraphMapNode graphMapNode = (GraphMapNode)this.node.getGraphMaps().get(n);
        if (string2.equals(R2RMLArb.getString("CONSTANT")) && graphMapNode.isShortcut()) {
            this.node.getGraphMaps().get(n).setValue(string);
        }
        if (string2.equals(R2RMLArb.getString("CONSTANT")) && !graphMapNode.isShortcut()) {
            this.node.removeChild(graphMapNode);
            graphMapNode = new GraphMapNode("_:" + RDFStringUtils.generateRandomId());
            this.node.addChildEdge("<http://www.w3.org/ns/r2rml#graphMap>", graphMapNode);
            graphMapNode.addChildEdge("<http://www.w3.org/ns/r2rml#constant>", new R2RMLNode(string));
        }
        if (string2.equals(R2RMLArb.getString("TEMPLATE"))) {
            this.node.removeChild(graphMapNode);
            graphMapNode = new GraphMapNode("_:" + RDFStringUtils.generateRandomId());
            this.node.addChildEdge("<http://www.w3.org/ns/r2rml#graphMap>", graphMapNode);
            graphMapNode.addChildEdge("<http://www.w3.org/ns/r2rml#template>", new StringTemplateNode(string));
        }
        if (string2.equals(R2RMLArb.getString("COLUMN"))) {
            this.node.removeChild(graphMapNode);
            graphMapNode = new GraphMapNode("_:" + RDFStringUtils.generateRandomId());
            this.node.addChildEdge("<http://www.w3.org/ns/r2rml#graphMap>", graphMapNode);
            graphMapNode.addChildEdge("<http://www.w3.org/ns/r2rml#column>", new ColumnNameNode(string));
        }
        this.fireTableDataChanged();
    }

    public void removeRow(int n) {
        R2RMLNode r2RMLNode = this.node.getGraphMaps().get(n);
        this.node.removeChild(r2RMLNode);
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    @Override
    public String getColumnName(int n) {
        return this.headers[n];
    }
}

