/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.r2rml.editor.objectmap;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.r2rml.R2RMLArb;
import oracle.dbtools.rdfgraph.r2rml.editor.objectmap.JoinConditionColumnValueCellEditor;
import oracle.dbtools.rdfgraph.r2rml.editor.objectmap.JoinConditionTableModel;
import oracle.dbtools.rdfgraph.r2rml.language.JoinConditionNode;
import oracle.dbtools.rdfgraph.r2rml.language.ObjectMapNode;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLStringNode;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLTree;
import oracle.dbtools.rdfgraph.r2rml.language.TriplesMapNode;
import oracle.dbtools.rdfgraph.utils.RDFStringUtils;
import oracle.javatools.icons.OracleIcons;

public class JoinConditionListEditor
extends JPanel
implements ItemListener {
    Connection connection;
    R2RMLTree tree;
    TriplesMapNode tmap;
    private JToolBar toolbar;
    private JoinConditionTableModel tmodel;
    private JTable table;
    private ObjectMapNode node;
    private final int VALUE_CHILD_COL_IDX = 0;
    private final int VALUE_PARENT_COL_IDX = 1;

    public JoinConditionListEditor(Connection connection, R2RMLTree r2RMLTree, TriplesMapNode triplesMapNode, ObjectMapNode objectMapNode) {
        this.connection = connection;
        this.tree = r2RMLTree;
        this.tmap = triplesMapNode;
        this.node = objectMapNode;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(R2RMLArb.getString("JOIN_CONDITIONS")));
        this.initUI();
    }

    private void initUI() {
        this.tmodel = new JoinConditionTableModel(this.node);
        this.table = new JTable(this.tmodel);
        this.add((Component)new JScrollPane(this.table), "Center");
        this.toolbar = this.createToolBar();
        this.add((Component)this.toolbar, "North");
        this.table.getColumnModel().getColumn(0).setCellEditor(new JoinConditionColumnValueCellEditor(this.tmap, this.connection));
        this.table.getColumnModel().getColumn(1).setCellEditor(new JoinConditionColumnValueCellEditor((TriplesMapNode)this.node.getParentTriplesMap(), this.connection));
    }

    private JToolBar createToolBar() {
        this.toolbar = new JToolBar();
        this.toolbar.add(Box.createHorizontalGlue());
        JButton jButton = new JButton(UiResources.getString((String)"ADD_BUTTON_LABEL"), OracleIcons.getIcon((String)"add.png"));
        this.toolbar.add(jButton);
        jButton.addActionListener(actionEvent -> {
            JoinConditionNode joinConditionNode = new JoinConditionNode("_:" + RDFStringUtils.generateRandomId());
            joinConditionNode.addChildEdge("<http://www.w3.org/ns/r2rml#child>", new R2RMLStringNode("\"\\\"CHILD_COL\"\\\""));
            joinConditionNode.addChildEdge("<http://www.w3.org/ns/r2rml#parent>", new R2RMLStringNode("\"\\\"PARENT_COL\"\\\""));
            this.node.addChildEdge("<http://www.w3.org/ns/r2rml#joinCondition>", joinConditionNode);
            this.tmodel.fireTableDataChanged();
        });
        JButton jButton2 = new JButton(RdfgraphArb.getString("DELETE"), OracleIcons.getIcon((String)"delete.png"));
        this.toolbar.add(jButton2);
        jButton2.addActionListener(actionEvent -> {
            if (this.table.getSelectedRow() != -1) {
                int n = this.table.getSelectedRow();
                this.table.clearSelection();
                if (this.table.isEditing()) {
                    this.table.getCellEditor().stopCellEditing();
                }
                this.tmodel.removeRow(n);
            }
        });
        return this.toolbar;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            String string = (String)itemEvent.getItem();
            TriplesMapNode triplesMapNode = this.tree.getTriplesMapByURI(string);
            this.node.removeChildEdge("<http://www.w3.org/ns/r2rml#parentTriplesMap>");
            this.node.addChildEdge("<http://www.w3.org/ns/r2rml#parentTriplesMap>", triplesMapNode);
            this.table.clearSelection();
            if (this.table.isEditing()) {
                this.table.getCellEditor().stopCellEditing();
            }
            this.table.getColumnModel().getColumn(1).setCellEditor(new JoinConditionColumnValueCellEditor((TriplesMapNode)this.node.getParentTriplesMap(), this.connection));
            this.tmodel.fireTableDataChanged();
        }
    }
}

