/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.r2rml.editor.datasource;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.EventListenerList;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.actions.SQLScriptProcessor;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.r2rml.R2RMLArb;
import oracle.dbtools.rdfgraph.r2rml.language.LogicalTableNode;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLNode;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLStringNode;
import oracle.dbtools.rdfgraph.r2rml.language.TableNameNode;
import oracle.dbtools.rdfgraph.ui.TableSearchAndSelectActionControl;
import oracle.dbtools.rdfgraph.utils.RDFStringUtils;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.icons.OracleIcons;

public class LogicalTableNodeEditor
extends JPanel
implements LayoutControl {
    static String TITLE_LOGICAL_TABLE = R2RMLArb.getString("LOGICAL_TABLE");
    static String TITLE_TABLE_OR_VIEW = R2RMLArb.getString("LogicalTableNodeEditor.TABLE_OR_VIEW_NAME");
    static String TITLE_DATASOURCE_TYPE = R2RMLArb.getString("LogicalTableNodeEditor.DATA_SOURCE_TYPE");
    static final int OBJ_NAME_IDX = 1;
    static final int OBJ_OWNER_IDX = 0;
    protected EventListenerList listenerList = new EventListenerList();
    LogicalTableNode node;
    Connection connection;
    JComboBox selSourceType;
    JTextField txtTableName;
    SqlComboBoxActionControl sqlSelectTableView;
    JButton btnSelect;
    CardLayout sourceCard;
    JPanel sourcePanel;
    BasicEditorPane sqlEditor;
    ResultSetTable rsTable;
    TableSearchAndSelectActionControl srcSelector;

    public void addDataSourceChangeEventListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeDataSourceChangeEventListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    public LogicalTableNodeEditor(LogicalTableNode logicalTableNode, Connection connection) {
        this.node = logicalTableNode;
        this.connection = connection;
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new GridBagLayout());
        this.addSourceTypeSelectionControls();
        this.add((Component)this.createSourcePanel(), LayoutControl.GBC.gbc((int)0, (int)1, (int)0, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.TITLED_SUB_PANEL, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
    }

    private void addSourceTypeSelectionControls() {
        JPanel jPanel = LayoutControl.GBC.createPanel();
        String[] stringArray = new String[]{RdfgraphArb.getString("TABLE"), RdfgraphArb.getString("VIEW"), RdfgraphArb.getString("QUERY")};
        this.selSourceType = new JComboBox<String>(stringArray);
        this.selSourceType.setSelectedItem(this.node.getSourceType());
        this.selSourceType.addActionListener(actionEvent -> {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            String string = (String)jComboBox.getSelectedItem();
            if (string.equalsIgnoreCase(RdfgraphArb.getString("TABLE")) || string.equalsIgnoreCase(RdfgraphArb.getString("VIEW"))) {
                this.sourceCard.show(this.sourcePanel, TITLE_TABLE_OR_VIEW);
            } else {
                this.sourceCard.show(this.sourcePanel, RdfgraphArb.getString("QUERY"));
            }
        });
        this.add((Component)new JLabel(TITLE_DATASOURCE_TYPE + ": "), LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        this.add((Component)this.selSourceType, LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP));
    }

    private JPanel createSourcePanel() {
        this.sourcePanel = new JPanel();
        this.sourceCard = new CardLayout();
        this.sourcePanel.setLayout(this.sourceCard);
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(TITLE_TABLE_OR_VIEW));
        jPanel.add((Component)new JLabel(R2RMLArb.getString("LogicalTableNodeEditor.SELECTED_SOURCE_")), LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        this.txtTableName = new JTextField(R2RMLNode.stripQuotes(this.node.getTableName()));
        this.txtTableName.setEditable(false);
        jPanel.add((Component)this.txtTableName, LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        this.srcSelector = new TableSearchAndSelectActionControl(R2RMLArb.getString("LogicalTableNodeEditor.DATA_SOURCE_SELECTOR"), this.connection);
        jPanel.add(this.srcSelector.getUI(), LayoutControl.GBC.gbc((int)0, (int)1, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
        this.btnSelect = new JButton(R2RMLArb.getString("LogicalTableNodeEditor.SELECT"), OracleIcons.getIcon((String)"filesave.png"));
        this.btnSelect.setAlignmentX(1.0f);
        jPanel.add((Component)this.btnSelect, LayoutControl.GBC.gbc((int)0, (int)2, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE, (LayoutControl.GBC.Anchor)LayoutControl.GBC.Anchor.LINE_END));
        this.btnSelect.addActionListener(actionEvent -> {
            if (this.srcSelector.getSelectedRow() == null) {
                return;
            }
            String string = this.srcSelector.getSelectedRow().getValue(0);
            String string2 = this.srcSelector.getSelectedRow().getValue(1);
            String string3 = string + "." + string2;
            String string4 = "\\\"" + string + "\\\".\\\"" + string2 + "\\\"";
            string4 = "\"" + string4 + "\"";
            this.txtTableName.setText(string3);
            this.node.removeChildEdge("<http://www.w3.org/ns/r2rml#tableName>");
            this.node.addChildEdge("<http://www.w3.org/ns/r2rml#tableName>", new TableNameNode(string4));
            MessageDialog.information((Component)this.getTopLevelAncestor(), (Object)(R2RMLArb.getString("LogicalTableNodeEditor.CHANGED_DATA_SOURCE_TO_") + string2), (String)R2RMLArb.getString("LogicalTableNodeEditor.TRIPLESMAP_DATA_SOURCE"), null);
            this.fireDataSourceChangeEvent(new ActionEvent(this, 1, "DATA_SOURCE_CHANGED"));
        });
        this.sourcePanel.add((Component)jPanel, TITLE_TABLE_OR_VIEW);
        SQLScriptProcessor sQLScriptProcessor = new SQLScriptProcessor();
        this.sqlEditor = sQLScriptProcessor.getEditorPane();
        String string = "table_name";
        if (this.node.getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#tableName>") != null) {
            string = this.node.getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#tableName>").getValue();
            string = RDFStringUtils.stripSQLName(string);
        }
        this.sqlEditor.setText("SELECT * from " + string);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(R2RMLArb.getString("LogicalTableNodeEditor.QUERY_DEFINITION")));
        this.rsTable = new ResultSetTable();
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setTopComponent(new JScrollPane((Component)this.sqlEditor));
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setResizeWeight(0.5);
        jSplitPane.setBottomComponent(new JScrollPane((Component)this.rsTable));
        jPanel2.add((Component)jSplitPane, "Center");
        JToolBar jToolBar = new JToolBar();
        JButton jButton = new JButton(RdfgraphArb.getString("SAVE"), OracleIcons.getIcon((String)"filesave.png"));
        jButton.addActionListener(actionEvent -> {
            this.node.removeChildEdge("<http://www.w3.org/ns/r2rml#tableName>");
            this.node.removeChildEdge("<http://www.w3.org/ns/r2rml#sqlQuery>");
            String string = this.sqlEditor.getText();
            String string2 = RDFStringUtils.escapeJavaString(string, false, false);
            string2 = RDFStringUtils.addWrappingQuotes(string2);
            this.node.addChildEdge("<http://www.w3.org/ns/r2rml#sqlQuery>", new R2RMLStringNode(string2));
            MessageDialog.information((Component)this.getTopLevelAncestor(), (Object)R2RMLArb.getString("LogicalTableNodeEditor.CHANGED_SOURCE_QUERY"), (String)R2RMLArb.getString("LogicalTableNodeEditor.TRIPLESMAP_DATA_SOURCE"), null);
            this.fireDataSourceChangeEvent(new ActionEvent(this, 1, "DATA_SOURCE_CHANGED"));
        });
        jToolBar.add(jButton);
        JButton jButton2 = new JButton(R2RMLArb.getString("LogicalTableNodeEditor.PREVIEW"), OracleIcons.getIcon((String)"run.png"));
        jToolBar.add(jButton2);
        jButton2.addActionListener(actionEvent -> {
            String string = Connections.getInstance().getDatabase(this.connection).getQualifiedName();
            this.rsTable.setQuery(string, this.sqlEditor.getText(), null, null);
            try {
                this.rsTable.refresh();
            }
            catch (ExecutionException executionException) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)executionException.getMessage(), (String)R2RMLArb.getString("LogicalTableNodeEditor.QUERY_ERROR"), null);
            }
        });
        jPanel2.add((Component)jToolBar, "North");
        this.sourcePanel.add((Component)jPanel2, RdfgraphArb.getString("QUERY"));
        if (this.node.getSourceType().equalsIgnoreCase(RdfgraphArb.getString("QUERY"))) {
            this.sourceCard.show(this.sourcePanel, RdfgraphArb.getString("QUERY"));
            String string2 = RDFStringUtils.unescapeJavaString(this.node.getSQLQuery());
            string2 = RDFStringUtils.removeWrappingQuotes(string2);
            this.sqlEditor.setText(string2);
        }
        return this.sourcePanel;
    }

    void fireDataSourceChangeEvent(ActionEvent actionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ActionListener.class) continue;
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }
}

