/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.r2rml.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.raptor.oviewer.base.AsynchronousViewerEditor;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.r2rml.R2RMLArb;
import oracle.dbtools.rdfgraph.r2rml.editor.ButtonColumn;
import oracle.dbtools.rdfgraph.r2rml.editor.R2RMLEditorNode;
import oracle.dbtools.rdfgraph.r2rml.editor.treeview.R2RMLTreeCellRenderer;
import oracle.dbtools.rdfgraph.r2rml.editor.treeview.R2RMLTreeTableModel;
import oracle.dbtools.rdfgraph.r2rml.editor.triplesmap.TriplesMapEditor;
import oracle.dbtools.rdfgraph.r2rml.editor.triplesmap.TriplesMapEditorDialog;
import oracle.dbtools.rdfgraph.r2rml.language.LogicalTableNode;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLNode;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLTree;
import oracle.dbtools.rdfgraph.r2rml.language.SubjectMapNode;
import oracle.dbtools.rdfgraph.r2rml.language.SubjectTemplateNode;
import oracle.dbtools.rdfgraph.r2rml.language.TableNameNode;
import oracle.dbtools.rdfgraph.r2rml.language.TriplesMapNode;
import oracle.dbtools.rdfgraph.utils.PLSQLBlockTemplate;
import oracle.dbtools.rdfgraph.utils.R2RMLTreeBuilder;
import oracle.dbtools.rdfgraph.utils.RDFDBUtils;
import oracle.dbtools.rdfgraph.utils.RDFStatement;
import oracle.dbtools.rdfgraph.utils.RDFStatementIterator;
import oracle.dbtools.rdfgraph.utils.RDFStringUtils;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.controls.Toolbar;
import oracle.ide.net.URLFilter;
import oracle.ide.net.WildcardURLFilter;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.treetable.JTreeTable;
import oracle.javatools.ui.treetable.TreeTableModel;
import oracle.javatools.ui.treetable.TreeTableModelAdapter;

public class R2RMLEditor
extends AsynchronousViewerEditor
implements ActionListener,
LayoutControl {
    private JPanel mpanel;
    private BasicEditorPane rawR2RMLEditor;
    private BasicEditorPane turtleR2RMLEditor;
    private JTreeTable treeView;
    private R2RMLTreeTableModel treeModel;
    private JScrollPane treeViewPane;
    private String modelName = null;
    private Connection connection;
    private String networkOwner;
    private String networkName;
    private boolean isDB19cOrAfter = false;
    private boolean isCompressionEnabled = false;
    private JMenuBar menuBar;
    private URLFileChooser chooser;
    private final WildcardURLFilter NTFILTER = new WildcardURLFilter("*.nt", false, "N-Triples");
    private final WildcardURLFilter NQFILTER = new WildcardURLFilter("*.nq", false, "N-Quads");
    private final WildcardURLFilter TTLFILTER = new WildcardURLFilter("*.ttl", false, "Turtle");
    CustomTabbedPane tabPane;
    String sR2RML = "";
    R2RMLTree tree;

    public void setConnection(Connection connection) {
        this.connection = connection;
        this.isCompressionEnabled = RDFDBUtils.isCompressionEnabled(connection);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setTree(R2RMLTree r2RMLTree) {
        this.tree = r2RMLTree;
    }

    public R2RMLTree getTree() {
        return this.tree;
    }

    public void setModelName(String string) {
        this.modelName = string;
    }

    public String getModelName() {
        return this.modelName;
    }

    public R2RMLEditor() {
    }

    public R2RMLEditor(String string, String string2) {
        this.modelName = string2;
        this.sR2RML = string;
        this.initComponents();
    }

    private void initComponents() {
        this.setEditorAttribute("scrollable", false);
        this.rawR2RMLEditor = new BasicEditorPane();
        this.rawR2RMLEditor.setText(this.sR2RML);
        this.buildTree();
        this.sR2RML = this.tree.genR2RMLNTriples();
        this.buildTree();
        this.initTreeView();
        this.tabPane = new CustomTabbedPane();
        this.tabPane.addTab(null, R2RMLArb.getString("R2RMLEditor.TreeView"), (Component)this.getTreeViewPanel());
        this.tabPane.addTab(null, R2RMLArb.getString("R2RMLEditor.R2RML_NT_TAB"), (Component)new JScrollPane((Component)this.rawR2RMLEditor));
        JScrollPane jScrollPane = new JScrollPane(this.getTurtlePanel());
        jScrollPane.setVerticalScrollBarPolicy(22);
        this.tabPane.addTab(null, R2RMLArb.getString("R2RMLEditor.R2RML_TTL_TAB"), (Component)jScrollPane);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setViewportView(this.iconsPanel());
        this.tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CustomTabbedPane customTabbedPane = (CustomTabbedPane)changeEvent.getSource();
                int n = customTabbedPane.getSelectedIndex();
                if (n == 0) {
                    return;
                }
                if (n == 1) {
                    String string = R2RMLEditor.this.tree.genR2RMLNTriples();
                    R2RMLEditor.this.rawR2RMLEditor.setText(string);
                    return;
                }
                if (n == 2) {
                    String string = R2RMLEditor.this.tree.getSimpleTurtle(R2RMLEditor.this.tree.getRoot());
                    R2RMLEditor.this.turtleR2RMLEditor.setText(string);
                    return;
                }
            }
        });
        this.mpanel = LayoutControl.GBC.createTabPanel((Component)this.tabPane);
        this.mpanel.add((Component)this.tabPane, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
        SwingUtilities.invokeLater(() -> this.addToolbar());
    }

    private void initTreeView() {
        this.treeModel = new R2RMLTreeTableModel(this.getTree().getRoot());
        this.treeView = new JTreeTable((TreeTableModel)this.treeModel);
        this.treeView.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                JTree jTree = R2RMLEditor.this.treeView.getTree();
                TreePath treePath = jTree.getLeadSelectionPath();
                if (treePath == null) {
                    return;
                }
                boolean bl = ((TreeTableModelAdapter)R2RMLEditor.this.treeView.getModel()).getTreeTableModel().isLeaf(treePath.getLastPathComponent());
                int n = R2RMLEditor.this.treeView.getSelectedColumn();
                switch (keyEvent.getKeyCode()) {
                    case 107: {
                        jTree.expandPath(treePath);
                        jTree.setSelectionPath(treePath);
                        break;
                    }
                    case 109: {
                        jTree.collapsePath(treePath);
                        jTree.setSelectionPath(treePath);
                        break;
                    }
                    case 39: {
                        if (n != 0 || bl || jTree.isExpanded(treePath)) break;
                        jTree.expandPath(treePath);
                        keyEvent.consume();
                        jTree.setSelectionPath(treePath);
                        R2RMLEditor.this.treeView.setColumnSelectionInterval(0, 0);
                        break;
                    }
                    case 37: {
                        if (n != 0 || bl || !jTree.isExpanded(treePath)) break;
                        jTree.collapsePath(treePath);
                        keyEvent.consume();
                        jTree.setSelectionPath(treePath);
                        R2RMLEditor.this.treeView.setColumnSelectionInterval(0, 0);
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.treeView.getColumnModel().getColumn(0).setPreferredWidth(140);
        this.treeView.getColumnModel().getColumn(1).setPreferredWidth(400);
        this.treeView.getColumnModel().getColumn(2).setPreferredWidth(50);
        this.treeView.getColumnModel().getColumn(2).setMaxWidth(50);
        this.treeView.getTree().setCellRenderer(new R2RMLTreeCellRenderer());
        this.treeView.updateUI();
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTreeTable jTreeTable = (JTreeTable)actionEvent.getSource();
                int n = Integer.valueOf(actionEvent.getActionCommand());
                R2RMLNode r2RMLNode = (R2RMLNode)jTreeTable.getTree().getPathForRow(n).getLastPathComponent();
                TriplesMapNode triplesMapNode = (TriplesMapNode)r2RMLNode;
                TriplesMapEditor triplesMapEditor = new TriplesMapEditor(R2RMLEditor.this.tree, triplesMapNode, R2RMLEditor.this.getConnection());
                JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)triplesMapEditor, (String)(R2RMLArb.getString("TriplesMapEditorDialog.TRIPLESMAP_EDITOR_") + triplesMapNode.getValue()), null, (int)5);
                jEWTDialog.runDialog();
            }
        };
        new ButtonColumn((JTable)this.treeView, abstractAction, 2);
    }

    private JPanel getTreeViewPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.treeViewPane = new JScrollPane((Component)this.treeView);
        jPanel.add((Component)this.treeViewPane, "Center");
        jPanel.add((Component)this.getTreeToolbar(), "North");
        return jPanel;
    }

    private void buildTree() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.sR2RML.getBytes(StandardCharsets.UTF_8));
        RDFStatementIterator rDFStatementIterator = new RDFStatementIterator(byteArrayInputStream);
        R2RMLTreeBuilder r2RMLTreeBuilder = new R2RMLTreeBuilder(rDFStatementIterator);
        this.setTree(r2RMLTreeBuilder.buildTree());
    }

    public JPanel iconsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        Field[] fieldArray = OracleIcons.class.getDeclaredFields();
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Field field : fieldArray) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            arrayList.add(field);
        }
        Collections.sort(arrayList, new Comparator<Field>(){

            @Override
            public int compare(Field field, Field field2) {
                return field.getName().compareTo(field2.getName());
            }
        });
        for (Field field : arrayList) {
            if (field.getType() != String.class) continue;
            try {
                JLabel jLabel = new JLabel(field.getName() + "=" + (String)field.get(null), OracleIcons.getIcon((String)((String)field.get(null))), 2);
                jPanel.add(jLabel);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.severe(this.getClass(), (Throwable)illegalAccessException);
            }
        }
        return jPanel;
    }

    public BufferedImage createImage(JPanel jPanel) {
        int n = jPanel.getWidth();
        int n2 = jPanel.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        jPanel.paint(graphics2D);
        return bufferedImage;
    }

    private JToolBar getTreeToolbar() {
        JToolBar jToolBar = new JToolBar(R2RMLArb.getString("R2RMLEditor.TreeViewToolbar"));
        jToolBar.add(Box.createHorizontalGlue());
        JButton jButton = new JButton(R2RMLArb.getString("R2RMLEditor.AddTriplesMap"), OracleIcons.getIcon((String)"add.png"));
        jButton.addActionListener(actionEvent -> {
            TriplesMapNode triplesMapNode = new TriplesMapNode(RDFStringUtils.generateRandomTMAP());
            LogicalTableNode logicalTableNode = new LogicalTableNode(RDFStringUtils.generateRandomBNode());
            logicalTableNode.addChildEdge("<http://www.w3.org/ns/r2rml#tableName>", new TableNameNode("\"MY_TABLE\""));
            triplesMapNode.addChildEdge("<http://www.w3.org/ns/r2rml#logicalTable>", logicalTableNode);
            SubjectMapNode subjectMapNode = new SubjectMapNode(RDFStringUtils.generateRandomBNode());
            subjectMapNode.addChildEdge("<http://www.w3.org/ns/r2rml#template>", new SubjectTemplateNode("<http://data.example.com/path/{COL}>"));
            triplesMapNode.addChildEdge("<http://www.w3.org/ns/r2rml#subjectMap>", subjectMapNode);
            this.tree.getRoot().addChildEdge("<root-edge>", triplesMapNode);
            this.refreshTreeView();
        });
        jToolBar.add(jButton);
        JButton jButton2 = new JButton(R2RMLArb.getString("R2RMLEditor.Delete"), OracleIcons.getIcon((String)"delete.png"));
        jButton2.addActionListener(actionEvent -> {
            int n = this.treeView.getSelectedRow() - 1;
            if (n == -1) {
                return;
            }
            String string = this.tree.getRoot().getChildren().get(n).getValue();
            boolean bl = MessageDialog.confirm((Component)this.mpanel.getTopLevelAncestor(), (Object)R2RMLArb.format("R2RMLEditor.DeleteTriplesMap", string), (String)R2RMLArb.getString("R2RMLEditor.ConfirmDeletion"), null);
            if (bl) {
                this.treeView.clearSelection();
                if (this.treeView.isEditing()) {
                    this.treeView.getCellEditor().stopCellEditing();
                }
                this.treeModel.removeRow(n);
                this.refreshTreeView();
            }
        });
        jToolBar.add(jButton2);
        return jToolBar;
    }

    private void refreshTreeView() {
        this.refreshTreeView(this.tree.genR2RMLNTriples());
    }

    private void refreshTreeView(String string) {
        this.sR2RML = string;
        this.buildTree();
        this.treeModel = new R2RMLTreeTableModel(this.getTree().getRoot());
        this.treeView = new JTreeTable((TreeTableModel)this.treeModel);
        this.treeView.getColumnModel().getColumn(0).setPreferredWidth(140);
        this.treeView.getColumnModel().getColumn(1).setPreferredWidth(400);
        this.treeView.getColumnModel().getColumn(2).setPreferredWidth(50);
        this.treeView.getColumnModel().getColumn(2).setMaxWidth(50);
        this.treeView.getTree().setCellRenderer(new R2RMLTreeCellRenderer());
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTreeTable jTreeTable = (JTreeTable)actionEvent.getSource();
                int n = Integer.valueOf(actionEvent.getActionCommand());
                R2RMLNode r2RMLNode = (R2RMLNode)jTreeTable.getTree().getPathForRow(n).getLastPathComponent();
                TriplesMapEditorDialog triplesMapEditorDialog = new TriplesMapEditorDialog((Frame)SwingUtilities.getWindowAncestor(R2RMLEditor.this.mpanel), R2RMLEditor.this.tree, (TriplesMapNode)r2RMLNode, R2RMLEditor.this.getConnection());
                triplesMapEditorDialog.addDataSourceChangeEventListener(R2RMLEditor.this);
                triplesMapEditorDialog.setVisible(true);
            }
        };
        new ButtonColumn((JTable)this.treeView, abstractAction, 2);
        this.treeViewPane.setViewportView((Component)this.treeView);
    }

    private JToolBar addToolbar() {
        Toolbar toolbar = this.getToolbar();
        AbstractAction abstractAction = new AbstractAction(R2RMLArb.getString("R2RMLEditor.LoadMappingFromFile") + "..", OracleIcons.getIcon((String)"open.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                R2RMLEditor.this.chooser = new URLFileChooser();
                R2RMLEditor.this.chooser.setSelectionScope(0);
                R2RMLEditor.this.chooser.setSelectionMode(0);
                R2RMLEditor.this.chooser.clearChooseableURLFilters();
                R2RMLEditor.this.chooser.addChooseableURLFilter((URLFilter)R2RMLEditor.this.NTFILTER);
                R2RMLEditor.this.chooser.addChooseableURLFilter((URLFilter)R2RMLEditor.this.NQFILTER);
                R2RMLEditor.this.chooser.setCheckIfFileExists(true);
                if (R2RMLEditor.this.chooser.showOpenDialog((Component)R2RMLEditor.this.mpanel) == 0 && R2RMLEditor.this.chooser.getSelectedFile() != null) {
                    File file = R2RMLEditor.this.chooser.getSelectedFile();
                    Scanner scanner = null;
                    try {
                        scanner = new Scanner(file);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        MessageDialog.error((Component)SwingUtilities.getWindowAncestor(R2RMLEditor.this.mpanel), (Object)fileNotFoundException.getMessage(), (String)R2RMLArb.getString("R2RMLEditor.UnableToOpen"), null);
                    }
                    String string = scanner.useDelimiter("\\A").next();
                    scanner.close();
                    R2RMLEditor.this.refreshTreeView(string);
                }
            }
        };
        toolbar.add(abstractAction);
        AbstractAction abstractAction2 = new AbstractAction(RdfgraphArb.getString("SAVE_TO_ACTION"), OracleIcons.getIcon((String)"filesave.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                R2RMLEditor.this.chooser = new URLFileChooser();
                R2RMLEditor.this.chooser.setSelectionScope(0);
                R2RMLEditor.this.chooser.setSelectionMode(0);
                R2RMLEditor.this.chooser.clearChooseableURLFilters();
                R2RMLEditor.this.chooser.addChooseableURLFilter((URLFilter)R2RMLEditor.this.NTFILTER);
                R2RMLEditor.this.chooser.addChooseableURLFilter((URLFilter)R2RMLEditor.this.TTLFILTER);
                R2RMLEditor.this.chooser.setCheckIfFileExists(false);
                if (R2RMLEditor.this.chooser.showSaveDialog((Component)R2RMLEditor.this.mpanel) == 0 && R2RMLEditor.this.chooser.getSelectedFile() != null) {
                    String string = R2RMLEditor.this.chooser.getSelectedFile().getName();
                    String string2 = string.substring(string.lastIndexOf("."), string.length());
                    URLFilter uRLFilter = R2RMLEditor.this.chooser.getSelectedFilter();
                    try (PrintWriter printWriter = new PrintWriter(R2RMLEditor.this.chooser.getSelectedFile());){
                        if (string2.equalsIgnoreCase("ttl") || uRLFilter.equals((Object)R2RMLEditor.this.TTLFILTER)) {
                            printWriter.println(R2RMLEditor.this.tree.getSimpleTurtle(R2RMLEditor.this.tree.getRoot()));
                        } else {
                            printWriter.println(R2RMLEditor.this.tree.genR2RMLNTriples());
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        MessageDialog.error((Component)SwingUtilities.getWindowAncestor(R2RMLEditor.this.mpanel), (Object)fileNotFoundException.getMessage(), (String)R2RMLArb.getString("R2RMLEditor.UnableToSaveMapping"), null);
                    }
                }
            }
        };
        toolbar.add(abstractAction2);
        JButton jButton = new JButton(R2RMLArb.getString("R2RMLEditor.RefreshTree"), OracleIcons.getIcon((String)"refresh.png"));
        toolbar.add(jButton);
        jButton.addActionListener(actionEvent -> this.refreshTreeView());
        JButton jButton2 = new JButton(R2RMLArb.getString("R2RMLEditor.CommitMappingTo"), OracleIcons.getIcon((String)"commit.png"));
        toolbar.add(jButton2);
        final JTextField jTextField = new JTextField();
        jTextField.setSize(300, 100);
        if (this.getModelName() != null) {
            jTextField.setText(this.getModelName().trim());
        }
        toolbar.add(jTextField);
        JLabel jLabel = new JLabel(RdfgraphArb.getString("OPTIONS"));
        toolbar.add(jLabel);
        final JTextField jTextField2 = new JTextField(" CREATE_ANYWAY=T ");
        jLabel.setLabelFor(jTextField2);
        toolbar.add(jTextField2);
        jButton2.addActionListener(actionEvent -> {
            boolean bl;
            String string;
            final String string2 = jTextField.getText().trim();
            DBUtil dBUtil = DBUtil.getInstance((Connection)this.connection);
            ArrayList<String> arrayList = new ArrayList<String>(){
                {
                    this.add(string2.toUpperCase());
                }
            };
            Object object = "SELECT model_name FROM MDSYS.RDF_MODEL$ WHERE model_name=:1";
            if (this.isDB19cOrAfter && this.networkOwner != null && !this.networkOwner.equalsIgnoreCase("MDSYS")) {
                object = "SELECT model_name FROM " + this.networkOwner + "." + this.networkName + "#RDF_MODEL$ WHERE model_name=:1";
            }
            if ((string = dBUtil.executeReturnOneCol((String)object, (List)arrayList)) == null && !(bl = MessageDialog.confirm((Component)SwingUtilities.getWindowAncestor(this.mpanel), (Object)R2RMLArb.format("R2RMLEditor.ModelDoesntExist", string2), (String)R2RMLArb.getString("R2RMLEditor.CommitMappingCheckModel"), null))) {
                return;
            }
            RaptorTask raptorTask = new RaptorTask(R2RMLArb.getString("R2RMLEditor.CommitMapping"), true, IRaptorTaskRunMode.MODAL){

                protected Object doWork() throws TaskException {
                    String string = jTextField.getText().trim();
                    if (string.isEmpty()) {
                        return null;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    Connection connection = R2RMLEditor.this.getConnection();
                    String string2 = Utils.getQuery(((Object)((Object)this)).getClass(), (Connection)connection, (String)"STAGING_TABLE_QUADS_SCRIPT");
                    string2 = RDFStringUtils.updateScriptCompression(string2, R2RMLEditor.this.isCompressionEnabled);
                    String string3 = "R2RML_" + PLSQLBlockTemplate.shortUUID();
                    PLSQLBlockTemplate pLSQLBlockTemplate = new PLSQLBlockTemplate(string2);
                    pLSQLBlockTemplate.replaceToken("#stage_table_name#", string3, PLSQLBlockTemplate.ParamType.TABLE_NAME);
                    stringBuilder.append(pLSQLBlockTemplate.toString());
                    try {
                        R2RMLEditor.this.processScript(stringBuilder.toString());
                        R2RMLEditor.this.insertR2RMLTriplesToStaging(string3);
                    }
                    catch (Exception exception) {
                        MessageDialog.error((Component)SwingUtilities.getWindowAncestor(R2RMLEditor.this.mpanel), (Object)exception.getMessage(), (String)R2RMLArb.getString("R2RMLEditor.CommitMappingCreateStaging"), null);
                        return null;
                    }
                    stringBuilder = new StringBuilder();
                    String string4 = Utils.getQuery(((Object)((Object)this)).getClass(), (Connection)connection, (String)"DEPLOY_MAPPING");
                    PLSQLBlockTemplate pLSQLBlockTemplate2 = new PLSQLBlockTemplate(string4);
                    pLSQLBlockTemplate2.replaceToken("#model_name#", string, PLSQLBlockTemplate.ParamType.TABLE_NAME_PARAM);
                    pLSQLBlockTemplate2.replaceToken("#r2rml_table_name#", string3, PLSQLBlockTemplate.ParamType.TABLE_NAME_PARAM);
                    pLSQLBlockTemplate2.replaceToken("#options#", " " + jTextField2.getText() + " ", PLSQLBlockTemplate.ParamType.STRING);
                    if (R2RMLEditor.this.isDB19cOrAfter) {
                        if (R2RMLEditor.this.networkOwner != null && !R2RMLEditor.this.networkOwner.equalsIgnoreCase("MDSYS")) {
                            pLSQLBlockTemplate2.replaceToken("#network_owner#", R2RMLEditor.this.networkOwner, PLSQLBlockTemplate.ParamType.STRING);
                            pLSQLBlockTemplate2.replaceToken("#network_name#", R2RMLEditor.this.networkName, PLSQLBlockTemplate.ParamType.STRING);
                        } else {
                            pLSQLBlockTemplate2.replaceToken("#network_owner#", "MDSYS", PLSQLBlockTemplate.ParamType.STRING);
                            pLSQLBlockTemplate2.replaceToken("#network_name#", "null", PLSQLBlockTemplate.ParamType.RAW);
                        }
                    }
                    stringBuilder.append(pLSQLBlockTemplate2.toString());
                    try {
                        R2RMLEditor.this.processScript(stringBuilder.toString());
                    }
                    catch (Exception exception) {
                        MessageDialog.error((Component)SwingUtilities.getWindowAncestor(R2RMLEditor.this.mpanel), (Object)exception.getMessage(), (String)R2RMLArb.getString("R2RMLEditor.CommitMappingCreateRDFView"), null);
                        return null;
                    }
                    String string5 = System.getProperty("line.separator") + stringBuilder.toString();
                    MessageDialog.information((Component)SwingUtilities.getWindowAncestor(R2RMLEditor.this.mpanel), (Object)R2RMLArb.format("R2RMLEditor.MappingDeployed", string, string5), (String)R2RMLArb.getString("R2RMLEditor.CommitMapping"), null);
                    return null;
                }
            };
            RaptorTaskManager.getInstance().addTask(raptorTask);
        });
        return toolbar;
    }

    private void insertR2RMLTriplesToStaging(String string) throws SQLException {
        Connection connection = this.getConnection();
        boolean bl = connection.getAutoCommit();
        connection.setAutoCommit(false);
        String string2 = Utils.getQuery(this.getClass(), (Connection)this.connection, (String)"STAGING_TABLE_INSERT_QUAD");
        string2 = string2.replaceAll("##STAGING_TABLE##", string.toUpperCase());
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        int n = 1000;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.tree.genR2RMLNTriples().getBytes(StandardCharsets.UTF_8));
        int n2 = 0;
        RDFStatementIterator rDFStatementIterator = new RDFStatementIterator(byteArrayInputStream);
        while (rDFStatementIterator.hasNext()) {
            RDFStatement rDFStatement = rDFStatementIterator.next();
            preparedStatement.setString(1, rDFStatement.getRDFTerms()[0]);
            preparedStatement.setString(2, rDFStatement.getRDFTerms()[1]);
            preparedStatement.setString(3, rDFStatement.getRDFTerms()[2]);
            preparedStatement.setString(4, null);
            preparedStatement.addBatch();
            if (++n2 % n != 0) continue;
            preparedStatement.executeBatch();
        }
        preparedStatement.executeBatch();
        this.getConnection().commit();
        connection.setAutoCommit(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processScript(String string) throws Exception {
        Connection connection = this.getConnection();
        ScriptParser scriptParser = new ScriptParser(string, connection);
        scriptParser.parse();
        ISQLCommand[] iSQLCommandArray = scriptParser.getSqlStatements();
        if (Connections.getInstance().lock(connection)) {
            try {
                for (ISQLCommand iSQLCommand : iSQLCommandArray) {
                    String string2 = iSQLCommand.getSql().replace("\r", " ");
                    try (PreparedStatement preparedStatement = connection.prepareStatement(string2);){
                        preparedStatement.execute();
                    }
                }
            }
            catch (SQLException sQLException) {
                try {
                    connection.rollback();
                }
                catch (Exception exception) {
                    Logger.info(this.getClass(), (Throwable)exception);
                }
                throw sQLException;
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
    }

    private Component getTurtlePanel() {
        this.turtleR2RMLEditor = new BasicEditorPane();
        BasicDocument basicDocument = (BasicDocument)this.turtleR2RMLEditor.getDocument();
        basicDocument.setLanguageSupport(LanguageModule.createSupportForFileType((String)".sparql"));
        this.turtleR2RMLEditor.setText(this.tree.getSimpleTurtle(this.tree.getRoot()));
        return this.turtleR2RMLEditor;
    }

    public JMenuBar createMenuBar() {
        this.menuBar = new JMenuBar();
        JFrame jFrame = (JFrame)SwingUtilities.getWindowAncestor(this.mpanel);
        JMenu jMenu = new JMenu(R2RMLArb.getString("R2RMLEditor.File"));
        jMenu.setMnemonic(70);
        jMenu.getAccessibleContext().setAccessibleDescription(R2RMLArb.getString("R2RMLEditor.FileMenu"));
        this.menuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem(R2RMLArb.getString("R2RMLEditor.LoadMappingFromFile") + "...", 79);
        jMenuItem.getAccessibleContext().setAccessibleDescription(R2RMLArb.getString("R2RMLEditor.LoadMappingFromFile"));
        this.chooser = new URLFileChooser();
        this.chooser.setSelectionScope(0);
        this.chooser.setSelectionMode(0);
        jMenuItem.addActionListener(actionEvent -> {
            this.chooser.clearChooseableURLFilters();
            this.chooser.addChooseableURLFilter((URLFilter)this.NTFILTER);
            this.chooser.addChooseableURLFilter((URLFilter)this.NQFILTER);
            this.chooser.setCheckIfFileExists(true);
            if (this.chooser.showOpenDialog((Component)this.mpanel) == 0 && this.chooser.getSelectedFile() != null) {
                File file = this.chooser.getSelectedFile();
                Scanner scanner = null;
                try {
                    scanner = new Scanner(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    MessageDialog.error((Component)SwingUtilities.getWindowAncestor(this.mpanel), (Object)fileNotFoundException.getMessage(), (String)R2RMLArb.getString("R2RMLEditor.UnableToOpen"), null);
                }
                String string = scanner.useDelimiter("\\A").next();
                scanner.close();
                this.refreshTreeView(string);
            }
        });
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(R2RMLArb.getString("R2RMLEditor.SaveMappingAs"), 65);
        jMenuItem2.addActionListener(actionEvent -> {
            this.chooser.clearChooseableURLFilters();
            this.chooser.addChooseableURLFilter((URLFilter)this.NTFILTER);
            this.chooser.addChooseableURLFilter((URLFilter)this.TTLFILTER);
            this.chooser.setCheckIfFileExists(false);
            if (this.chooser.showSaveDialog((Component)this.mpanel) == 0 && this.chooser.getSelectedFile() != null) {
                String string = this.chooser.getSelectedFile().getName();
                String string2 = string.substring(string.lastIndexOf("."), string.length());
                URLFilter uRLFilter = this.chooser.getSelectedFilter();
                try (PrintWriter printWriter = new PrintWriter(this.chooser.getSelectedFile());){
                    if (string2.equalsIgnoreCase("ttl") || uRLFilter.equals((Object)this.TTLFILTER)) {
                        printWriter.println(this.tree.getSimpleTurtle(this.tree.getRoot()));
                    } else {
                        printWriter.println(this.tree.genR2RMLNTriples());
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    MessageDialog.error((Component)SwingUtilities.getWindowAncestor(this.mpanel), (Object)fileNotFoundException.getMessage(), (String)R2RMLArb.getString("R2RMLEditor.UnableToSaveMapping"), null);
                }
            }
        });
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(R2RMLArb.getString("R2RMLEditor.Exit"), 69);
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        jMenuItem3.addActionListener(actionEvent -> jFrame.dispose());
        jMenu.add(jMenuItem3);
        this.menuBar.add(jMenu);
        return this.menuBar;
    }

    public String getR2RML(String string, String string2, String string3, boolean bl) {
        Connection connection = this.getConnection();
        String string4 = Utils.getQuery(this.getClass(), (Connection)connection, (String)"R2RML_DUMP");
        string4 = string4.replaceAll(":NAME", "'" + string + "'");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("NAME", string);
        if (bl) {
            if (string2 != null && !string2.equalsIgnoreCase("MDSYS")) {
                string4 = string4.replaceAll(":NETWORK_OWNER", "'" + Matcher.quoteReplacement(string2) + "'");
                string4 = string4.replaceAll(":NETWORK_NAME", "'" + Matcher.quoteReplacement(string3) + "'");
            } else {
                string4 = string4.replaceAll(":NETWORK_OWNER", "'MDSYS'");
                string4 = string4.replaceAll(":NETWORK_NAME", "null");
            }
        }
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        List list = dBUtil.executeReturnList(string4, hashMap);
        StringBuffer stringBuffer = new StringBuffer();
        for (Map map : list) {
            stringBuffer.append(map.get("LINE") + " \n");
        }
        return stringBuffer.toString();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        TriplesMapEditor triplesMapEditor = (TriplesMapEditor)actionEvent.getSource();
        TriplesMapNode triplesMapNode = triplesMapEditor.getTmap();
        triplesMapEditor.setVisible(false);
        TriplesMapEditor triplesMapEditor2 = new TriplesMapEditor(this.tree, triplesMapNode, this.getConnection());
        JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)LayoutControl.GBC.createDialogMainPanel((Component)triplesMapEditor2), (String)(R2RMLArb.getString("TriplesMapEditorDialog.TRIPLESMAP_EDITOR_") + triplesMapNode.getValue()), null);
        jEWTDialog.runDialog();
    }

    protected JComponent createViewerUI() {
        Context context = this.getContext();
        if (context.getNode() instanceof R2RMLEditorNode) {
            R2RMLEditorNode r2RMLEditorNode = (R2RMLEditorNode)context.getNode();
            Connection connection = r2RMLEditorNode.getDBObject().getConnection();
            this.setConnection(connection);
            String string = r2RMLEditorNode.getDBObject().getObjectType();
            if (r2RMLEditorNode.getRDFModelName() != null) {
                this.modelName = r2RMLEditorNode.getRDFModelName();
                this.networkOwner = r2RMLEditorNode.getRDFNetworkOwner();
                this.networkName = r2RMLEditorNode.getRDFNetworkName();
                this.isDB19cOrAfter = r2RMLEditorNode.isDB19cOrAfter();
                this.sR2RML = this.getR2RML(this.modelName, this.networkOwner, this.networkName, this.isDB19cOrAfter);
            } else {
                String string2;
                Connection connection2 = this.getConnection();
                this.sR2RML = string2 = Utils.getQuery(this.getClass(), (Connection)connection2, (String)"R2RML_EXAMPLE");
            }
        }
        this.initComponents();
        this.setContentModelLoaded(true);
        return this.mpanel;
    }

    protected void updateContent(boolean bl) {
    }

    protected void cleanUp() {
    }

    public Object getPrintable() {
        return this.turtleR2RMLEditor;
    }

    public String getTabLabel() {
        Context context = this.getContext();
        R2RMLEditorNode r2RMLEditorNode = (R2RMLEditorNode)context.getNode();
        if (r2RMLEditorNode.getRDFModelName() != null) {
            return String.format("%s - R2RML", r2RMLEditorNode.getRDFModelName());
        }
        return R2RMLArb.getString("R2RMLEditor.Title");
    }
}

