/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.ide.util.MetaClass;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogRunnerCallback;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.SizeKeeperCallback;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.library.LibraryList;
import oracle.jdeveloper.library.ListWrapper;
import oracle.jdevimpl.library.LibraryArb;
import oracle.jdevimpl.library.LibraryPanel;
import oracle.jdevimpl.library.ManageLibraryUIHook;

public class LibraryManagementPanel
extends JPanel {
    private GridBagLayout mainLayout = new GridBagLayout();
    private JTabbedPane tabbedPanel = new JTabbedPane();
    private List<LazyLibraryPanel> panels = new ArrayList<LazyLibraryPanel>(4);
    private LazyLibraryPanel _currentPanel;
    private ListWrapper[] libLists;

    public static boolean runDialog(LibraryList[] lists) {
        try {
            final LibraryManagementPanel panel = new LibraryManagementPanel();
            ListWrapper[] metaLists = new ListWrapper[lists.length];
            for (int i = 0; i < lists.length; ++i) {
                metaLists[i] = new ListWrapper(lists[i]);
            }
            panel.libLists = metaLists;
            LazyLibraryPanel lazyPanel = (LazyLibraryPanel)panel.tabbedPanel.getComponent(0);
            lazyPanel.onEntry(panel.libLists);
            HelpSystem.getHelpSystem().registerTopic((JComponent)panel, lazyPanel.getHelpId());
            panel.setPreferredSize(new Dimension(800, 600));
            VetoableChangeListener l = new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                    String propName = evt.getPropertyName();
                    Object newValue = evt.getNewValue();
                    if (propName.equals("closed") && Boolean.TRUE.equals(newValue) && !panel.commitChanges(evt)) {
                        throw new PropertyVetoException("veto", evt);
                    }
                }
            };
            return OnePageWizardDialogFactory.runDialog((Component)panel, (Component)panel, (String)LibraryArb.getString(1), (int)7, (VetoableChangeListener)l, (DialogRunnerCallback)new SizeKeeperCallback("manage.libraries"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private LibraryManagementPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e);
            throw new IllegalStateException();
        }
    }

    private boolean commitChanges(PropertyChangeEvent evt) throws PropertyVetoException {
        Iterator listWrapperIterator;
        ArrayList<ListWrapper> changes = new ArrayList<ListWrapper>();
        Iterator<LazyLibraryPanel> iter = this.panels.iterator();
        if (iter != null) {
            while (iter.hasNext()) {
                LazyLibraryPanel panel = iter.next();
                if (!panel.commitChanges()) {
                    return false;
                }
                ListWrapper[] lists = panel.getLibraryLists();
                if (lists == null) continue;
                for (int i = 0; i < lists.length; ++i) {
                    if (changes.contains(lists[i])) continue;
                    changes.add(lists[i]);
                }
            }
        }
        if ((listWrapperIterator = changes.iterator()) != null) {
            while (listWrapperIterator.hasNext()) {
                ListWrapper list = (ListWrapper)listWrapperIterator.next();
                list.commit(true);
            }
        }
        return true;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.mainLayout);
        this.setFocusable(false);
        final LibraryManagementPanel ref = this;
        Collection<Pair<String, MetaClass>> declarativelyRegisteredPanels = ManageLibraryUIHook.getRegisteredManageLibraryUIPanels();
        for (Pair<String, MetaClass> pair : declarativelyRegisteredPanels) {
            LazyLibraryPanel panel = new LazyLibraryPanel((MetaClass)pair.getSecond());
            this.panels.add(panel);
            this.tabbedPanel.addTab((String)pair.getFirst(), panel);
        }
        this.add((Component)this.tabbedPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tabbedPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                LazyLibraryPanel newPanel = (LazyLibraryPanel)LibraryManagementPanel.this.tabbedPanel.getSelectedComponent();
                newPanel.onEntry(LibraryManagementPanel.this.libLists);
                if (ModelUtil.areDifferent((Object)LibraryManagementPanel.this._currentPanel, (Object)newPanel)) {
                    if (LibraryManagementPanel.this._currentPanel != null && !LibraryManagementPanel.this._currentPanel.commitChanges()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LibraryManagementPanel.this.tabbedPanel.setSelectedComponent(LibraryManagementPanel.this._currentPanel);
                            }
                        });
                        return;
                    }
                    LibraryManagementPanel.this._currentPanel = newPanel;
                    HelpSystem.getHelpSystem().registerTopic(ref, LibraryManagementPanel.this._currentPanel.getHelpId());
                }
            }
        });
    }

    private static class LazyLibraryPanel
    extends JPanel {
        private MetaClass _metaClass;
        private LibraryPanel _libraryPanel;

        public LazyLibraryPanel(MetaClass metaClass) {
            this._metaClass = metaClass;
            this.setLayout(new BorderLayout());
        }

        public void onEntry(ListWrapper[] lists) {
            if (this._libraryPanel == null && lists != null) {
                try {
                    this._libraryPanel = (LibraryPanel)this._metaClass.newInstance();
                    this._libraryPanel.initPanel(lists);
                    this.add((Component)this._libraryPanel, "Center");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public boolean commitChanges() {
            if (this._libraryPanel == null) {
                return true;
            }
            return this._libraryPanel.commitChanges();
        }

        public ListWrapper[] getLibraryLists() {
            if (this._libraryPanel == null) {
                return null;
            }
            return this._libraryPanel.getLibraryLists();
        }

        public String getHelpId() {
            if (this._libraryPanel == null) {
                return null;
            }
            return this._libraryPanel.getHelpId();
        }
    }
}

