/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.migration.XMLMigrator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.FileCopyUtil;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JDKNode;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryList;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.JLibraryNode;
import oracle.jdeveloper.library.LegacyJDK;
import oracle.jdeveloper.library.LegacyLibrary;
import oracle.jdeveloper.library.LegacyLibraryList;
import oracle.jdeveloper.resource.LibraryArb;

public class LibraryMigrator
extends XMLMigrator {
    private static final int USER_LIBRARIES = 0;
    private static final int USER_J2SES = 1;
    private static final int SYSTEM_LIBRARIES = 2;
    private static final int SYSTEM_J2SES = 3;
    private List<File> sourceFileList;

    public LibraryMigrator() {
        super(new int[]{0, 1, 2, 3});
    }

    protected String getFileName() {
        return "libraries.xml";
    }

    protected String getNamespaceURI() {
        return LegacyLibraryList.NAMESPACE_URI;
    }

    protected String getRootTag() {
        return "JLibraryList";
    }

    public String getDescription(int category) {
        switch (category) {
            case 0: {
                return LibraryArb.getString(23);
            }
            case 1: {
                return LibraryArb.getString(24);
            }
            case 2: {
                return LibraryArb.getString(18);
            }
            case 3: {
                return LibraryArb.getString(19);
            }
        }
        return null;
    }

    protected Object readObject(File sourceDir, File destDir) throws Exception {
        Object retval;
        block2: {
            File file = this.getSourceFile(sourceDir, destDir);
            URL url = URLFactory.newFileURL((File)file);
            retval = null;
            try {
                retval = this.getObjectStore().toObject(url, ((Object)((Object)this)).getClass().getClassLoader());
            }
            catch (Exception ex) {
                if (url.toString().endsWith("libraries.xml")) break block2;
                throw ex;
            }
        }
        return retval;
    }

    public boolean canMigrate(int category, File sourceDir) {
        if (this.sourceFileList == null && this.isValidCategory(category) && sourceDir != null) {
            if (!sourceDir.getName().toLowerCase().startsWith("system") && (sourceDir = sourceDir.getParentFile()) == null) {
                return false;
            }
            this.sourceFileList = new ArrayList<File>();
            LibraryFilter filter = new LibraryFilter(new String[]{".library", ".jdk"});
            File[] dirs = sourceDir.listFiles();
            if (dirs != null) {
                for (File dir : dirs) {
                    File[] fileList = dir.listFiles(filter);
                    if (fileList == null || fileList.length <= 0) continue;
                    for (File file : fileList) {
                        this.sourceFileList.add(file);
                    }
                }
            }
            return this.sourceFileList != null && !this.sourceFileList.isEmpty();
        }
        return false;
    }

    public String[] migrate(File sourceDir, File destDir) {
        if (this.isAnyCategorySelected()) {
            try {
                ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
                URL systemUrl = er.getSystemDirectory(Ide.getProductID());
                File systemDir = new File(systemUrl.getPath());
                for (File file : this.sourceFileList) {
                    FileCopyUtil.copyFile((File)file, (File)new File(systemDir, file.getName()));
                }
            }
            catch (Exception e) {
                this.getLogger().logOtherException((Throwable)e);
            }
        }
        return this.getLogger().getErrors();
    }

    protected void prepareToMigrate() {
        Object2Dom.registerTransform((String)JLibraryList.class.getName(), (String)"http://xmlns.oracle.com/jdeveloper/903/jlibrary-list", (String)this.getRootTag(), (URL)URLFactory.newFileURL((File)new File(Ide.getProductHomeDirectory(), "bin/libraries-10120-to-10130.xsl")));
        Object2Dom.registerTransform((String)JLibraryList.class.getName(), (String)"http://xmlns.oracle.com/jdeveloper/904/jlibrary-list", (String)this.getRootTag(), (URL)URLFactory.newFileURL((File)new File(Ide.getProductHomeDirectory(), "bin/libraries-10120-to-10130.xsl")));
        Object2Dom.registerTransform((String)JLibraryList.class.getName(), (String)"http://xmlns.oracle.com/jdeveloper/905/jlibrary-list", (String)this.getRootTag(), (URL)URLFactory.newFileURL((File)new File(Ide.getProductHomeDirectory(), "bin/libraries-10120-to-10130.xsl")));
        Object2Dom.registerTransform((String)JLibraryList.class.getName(), (String)"http://xmlns.oracle.com/jdeveloper/9051/jlibrary-list", (String)this.getRootTag(), (URL)URLFactory.newFileURL((File)new File(Ide.getProductHomeDirectory(), "bin/libraries-10120-to-10130.xsl")));
        Object2Dom.registerTransform((String)JLibraryList.class.getName(), (String)"http://xmlns.oracle.com/jdeveloper/10120/jlibrary-list", (String)this.getRootTag(), (URL)URLFactory.newFileURL((File)new File(Ide.getProductHomeDirectory(), "bin/libraries-10120-to-10130.xsl")));
    }

    protected Object adjustObject(File sourceDir, File destDir, Object obj) throws Exception {
        JLibraryList userLibs;
        Iterator iter;
        List list;
        LegacyLibraryList legacy = (LegacyLibraryList)((Object)obj);
        ArrayList<LegacyLibrary> libraries = new ArrayList<LegacyLibrary>();
        ArrayList<LegacyJDK> jdks = new ArrayList<LegacyJDK>();
        if (this.isSelected(0)) {
            list = legacy != null ? legacy.getLibraryList() : null;
            Iterator iterator = iter = list != null ? list.iterator() : null;
            if (iter != null) {
                while (iter.hasNext()) {
                    LegacyLibrary lib = (LegacyLibrary)((Object)iter.next());
                    if (!this._isValidLibrary(lib)) continue;
                    libraries.add(lib);
                }
            }
        }
        if (this.isSelected(1)) {
            list = legacy != null ? legacy.getJdkList() : null;
            Iterator iterator = iter = list != null ? list.iterator() : null;
            if (iter != null) {
                while (iter.hasNext()) {
                    LegacyJDK jdk = (LegacyJDK)((Object)iter.next());
                    if (!this._isValidJDK(jdk)) continue;
                    jdks.add(jdk);
                }
            }
        }
        if (this.isSelected(2) || this.isSelected(3)) {
            Iterator iter2;
            List list2;
            String install = Ide.getInstallDirectory((File)sourceDir);
            legacy = null;
            if (install != null && install.length() > 0) {
                try {
                    sourceDir = new File(install);
                    sourceDir = sourceDir.getParentFile();
                    sourceDir = new File(sourceDir, "lib");
                    legacy = (LegacyLibraryList)((Object)this.readObject(sourceDir, destDir));
                }
                catch (Exception e) {
                    legacy = null;
                    this.getLogger().logInformation(e.getLocalizedMessage());
                }
            }
            if (this.isSelected(2)) {
                list2 = legacy != null ? legacy.getLibraryList() : null;
                Iterator iterator = iter2 = list2 != null ? list2.iterator() : null;
                if (iter2 != null) {
                    while (iter2.hasNext()) {
                        LegacyLibrary lib = (LegacyLibrary)((Object)iter2.next());
                        if (!this._isValidLibrary(lib)) continue;
                        libraries.add(lib);
                    }
                }
            }
            if (this.isSelected(3)) {
                list2 = legacy != null ? legacy.getJdkList() : null;
                Iterator iterator = iter2 = list2 != null ? list2.iterator() : null;
                if (iter2 != null) {
                    while (iter2.hasNext()) {
                        LegacyJDK jdk = (LegacyJDK)((Object)iter2.next());
                        if (!this._isValidJDK(jdk)) continue;
                        jdks.add(jdk);
                    }
                }
            }
        }
        if ((userLibs = JLibraryManager.getUserLibraries()) != null) {
            URL url;
            if (libraries.size() > 0) {
                for (LegacyLibrary lib : libraries) {
                    if (JLibraryManager.findLibrary(lib.getName()) == null) {
                        try {
                            url = URLFactory.newURL((URL)userLibs.getURL(), (String)(lib.getName() + ".library"));
                            JLibrary newLib = userLibs.addLibrary(lib.getName(), url);
                            if (newLib == null) continue;
                            newLib.setClassPath(lib.getClassPath());
                            newLib.setSourcePath(lib.getSourcePath());
                            newLib.setDocPath(lib.getDocPath());
                            newLib.setLocked(lib.isLocked());
                            newLib.setDeployedByDefault(lib.getDeployedByDefault());
                            ((JLibraryNode)newLib).save();
                        }
                        catch (Exception x) {
                            this.getLogger().logInformation(LibraryArb.format(12, new String[]{lib.getName()}));
                        }
                        continue;
                    }
                    this.getLogger().logInformation(LibraryArb.format(16, new String[]{LibraryArb.getString(10), lib.getName()}));
                }
            }
            if (jdks.size() > 0) {
                for (LegacyJDK jdk : jdks) {
                    if (JLibraryManager.findJDK(jdk.getName()) == null) {
                        try {
                            url = URLFactory.newURL((URL)userLibs.getURL(), (String)(jdk.getName() + ".jdk"));
                            JDK newJDK = userLibs.addJDK(jdk.getName(), jdk.getJavaExecutable(), url);
                            if (newJDK == null) continue;
                            newJDK.setClassPath(jdk.getClassPath());
                            newJDK.setSourcePath(jdk.getSourcePath());
                            newJDK.setDocPath(jdk.getDocPath());
                            newJDK.setLocked(jdk.isLocked());
                            newJDK.setJavaExecutable(jdk.getJavaExecutable());
                            newJDK.setInstalledVMs(jdk.getInstalledVMs());
                            newJDK.setJavaVersion(jdk.getJavaVersion());
                            newJDK.setSDKBinDir(jdk.getSDKBinDir());
                            ((JDKNode)newJDK).save();
                        }
                        catch (Exception x) {
                            this.getLogger().logInformation(LibraryArb.format(12, new String[]{jdk.getName()}));
                        }
                        continue;
                    }
                    this.getLogger().logInformation(LibraryArb.format(16, new String[]{LibraryArb.getString(11), jdk.getName()}));
                }
            }
        }
        return null;
    }

    private boolean _isValidLibrary(LegacyLibrary lib) {
        boolean valid = false;
        URLPath path = lib.getClassPath();
        if (path.size() > 0) {
            valid = this._pathContainsValidEntry(path);
        } else {
            path = lib.getSourcePath();
            if (path.size() > 0) {
                valid = this._pathContainsValidEntry(path);
            } else {
                path = lib.getDocPath();
                if (path.size() > 0) {
                    valid = this._pathContainsValidEntry(path);
                }
            }
        }
        return valid;
    }

    private boolean _pathContainsValidEntry(URLPath path) {
        Iterator iter;
        Iterator iterator = iter = path != null ? path.iterator() : null;
        if (iter != null) {
            while (iter.hasNext()) {
                URL entry = (URL)iter.next();
                if (!URLFileSystem.exists((URL)entry)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean _isValidJDK(LegacyJDK jdk) {
        if (jdk != null) {
            URL url = jdk.getJavaExecutable();
            return url != null && URLFileSystem.exists((URL)url);
        }
        return false;
    }

    class LibraryFilter
    implements FilenameFilter {
        private final String[] ext;

        public LibraryFilter(String[] ext) {
            this.ext = ext;
        }

        @Override
        public boolean accept(File dir, String name) {
            for (String s : this.ext) {
                if (!name.endsWith(s)) continue;
                return true;
            }
            return false;
        }
    }
}

