/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import java.util.Properties;
import javax.swing.Icon;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.VersionNumber;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.library.AbstractLibrary;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JDKUtil;
import oracle.jdeveloper.library.Library;

public final class AddinJDK
extends AbstractLibrary
implements JDK {
    private final String _name;
    private final URLPath _clsPath;
    private final URLPath _expandedClsPath;
    private final URLPath _srcPath;
    private final URLPath _expandedSrcPath;
    private final URLPath _docPath;
    private final URL _exeURL;
    private final VersionNumber _version;
    private final URL _sdkBinDir;
    private String[] _VMs;

    public AddinJDK(String name, URLPath clsPath, URLPath srcPath, URLPath docPath, URL exeURL, VersionNumber version, URL sdkBinDir) {
        this(name, clsPath, clsPath, srcPath, srcPath, docPath, exeURL, version, sdkBinDir);
    }

    public AddinJDK(String name, URLPath clsPath, URLPath expandedClsPath, URLPath srcPath, URLPath expandedSrcPath, URLPath docPath, URL exeURL, VersionNumber version, URL sdkBinDir) {
        this._name = name;
        this._clsPath = new URLPath(clsPath);
        this._expandedClsPath = new URLPath(expandedClsPath);
        this._srcPath = new URLPath(srcPath);
        this._expandedSrcPath = new URLPath(expandedSrcPath);
        this._docPath = new URLPath(docPath);
        this._exeURL = exeURL;
        this._version = version;
        this._sdkBinDir = sdkBinDir;
    }

    @Deprecated
    public AddinJDK(String name, URLPath clsPath, URLPath modulePath, URLPath srcPath, URLPath docPath, URL exeURL, VersionNumber version, URL sdkBinDir) {
        this._name = name;
        this._clsPath = new URLPath(clsPath);
        this._clsPath.add(new URLPath(modulePath));
        this._expandedClsPath = new URLPath(this._clsPath);
        this._srcPath = new URLPath(srcPath);
        this._expandedSrcPath = new URLPath(this._srcPath);
        this._docPath = new URLPath(docPath);
        this._exeURL = exeURL;
        this._version = version;
        this._sdkBinDir = sdkBinDir;
    }

    @Override
    public boolean equivalent(Library library) {
        boolean result = super.equivalent(library);
        if (result && library instanceof JDK) {
            if (ModelUtil.areDifferent((Object)((JDK)library).getExpandedClassPath(), (Object)this.getExpandedClassPath())) {
                return false;
            }
            if (ModelUtil.areDifferent((Object)((JDK)library).getExpandedSourcePath(), (Object)this.getExpandedSourcePath())) {
                return false;
            }
        }
        return result;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public URLPath getClassPath() {
        return this._clsPath;
    }

    @Override
    public URLPath getExpandedClassPath() {
        return this._expandedClsPath;
    }

    @Override
    public void setExpandedClassPath(URLPath path) {
    }

    @Override
    public URLPath getSourcePath() {
        return this._srcPath;
    }

    @Override
    public URLPath getExpandedSourcePath() {
        return this._expandedSrcPath;
    }

    @Override
    public void setExpandedSourcePath(URLPath path) {
    }

    @Override
    public URLPath getDocPath() {
        return this._docPath;
    }

    @Override
    public URL getJavaExecutable() {
        return this._exeURL;
    }

    @Override
    public void setJavaExecutable(URL url) {
    }

    @Override
    public synchronized String[] getInstalledVMs() {
        URL url;
        if (this._VMs == null && (url = this.getSDKBinDir()) != null) {
            this._VMs = JDKUtil.getVMChoices(url, false);
        }
        return this._VMs != null ? this._VMs : new String[]{};
    }

    @Override
    public void setInstalledVMs(String[] installedVMs) {
    }

    @Override
    public VersionNumber getJavaVersion() {
        return this._version;
    }

    @Override
    public void setJavaVersion(VersionNumber ver) {
    }

    @Override
    public URL getSDKBinDir() {
        return this._sdkBinDir;
    }

    @Override
    public void setSDKBinDir(URL url) {
    }

    @Override
    public String getSDKBinJavaExecutableNoConsole() {
        URL url = this.getSDKBinDir();
        if (url != null) {
            return JDKUtil.getJavaExecutableNoConsolePath(url);
        }
        return null;
    }

    @Override
    public String getJavaExecutableNoConsole() {
        URL url = this.getJavaExecutable();
        if (url != null && (url = URLFileSystem.getParent((URL)url)) != null) {
            return JDKUtil.getJavaExecutableNoConsolePath(url);
        }
        return null;
    }

    @Override
    public String getShortLabel() {
        return this._name;
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    @Override
    public Icon getIcon() {
        return OracleIcons.getIcon((String)"library.png");
    }

    @Override
    public Properties getSystemProperties() {
        return JDKUtil.getSystemProperties(this);
    }

    @Override
    @Deprecated
    public URLPath getModulePath() {
        VersionNumber javaVersion = this.getJavaVersion();
        if (javaVersion != null && javaVersion.isAfter("9", true)) {
            return this.getClassPath();
        }
        return new URLPath();
    }

    @Override
    @Deprecated
    public void setModulePath(URLPath modulePath) {
    }
}

