/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.translation;

import oracle.pgql.lang.ir.OrderByElem;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryExpressionVisitor;
import oracle.pgql.lang.util.AbstractQueryExpressionVisitor;

public abstract class SubqueryVisitor
extends AbstractQueryExpressionVisitor {
    public abstract void visitVarRef(QueryExpression.VarRef var1);

    public abstract void visitPropertyAccess(QueryExpression.PropertyAccess var1);

    public abstract void visitIdOrLabelFunction(QueryExpression.FunctionCall var1);

    public abstract void visitKeyColumnsFunction(QueryExpression.FunctionCall var1);

    public abstract void visitVarRefSubqueryFunction(QueryExpression.FunctionCall var1);

    public abstract void visitIsSourceOrIsDestOfFunction(QueryExpression.FunctionCall var1);

    public abstract void visitSrcDstPredicate(QueryExpression.SourceDestinationPredicate var1);

    public abstract void visitHasLabelFunction(QueryExpression.FunctionCall var1);

    public abstract void visitAggregation(QueryExpression.Aggregation.AbstractAggregation var1);

    public void visit(QueryExpression.VarRef varRef) {
        this.visitVarRef(varRef);
    }

    public void visit(QueryExpression.PropertyAccess propAccess) {
        this.visitPropertyAccess(propAccess);
    }

    public void visit(QueryExpression.FunctionCall functionCall) {
        if (functionCall.getFunctionName().equalsIgnoreCase("id") || functionCall.getFunctionName().equalsIgnoreCase("label")) {
            this.visitIdOrLabelFunction(functionCall);
        } else if (functionCall.getFunctionName().equalsIgnoreCase("_ora_comp_key_f_")) {
            this.visitKeyColumnsFunction(functionCall);
        } else if (functionCall.getFunctionName().equalsIgnoreCase("_ora_varref_function_")) {
            this.visitVarRefSubqueryFunction(functionCall);
        } else if (functionCall.getFunctionName().equalsIgnoreCase("is_source_of") || functionCall.getFunctionName().equalsIgnoreCase("is_destination_of")) {
            this.visitIsSourceOrIsDestOfFunction(functionCall);
        } else if (functionCall.getFunctionName().equalsIgnoreCase("has_label")) {
            this.visitHasLabelFunction(functionCall);
        } else {
            functionCall.getArgs().forEach(arg -> arg.accept((QueryExpressionVisitor)this));
        }
    }

    public void visit(QueryExpression.SourceDestinationPredicate sourceDestinationPredicate) {
        this.visitSrcDstPredicate(sourceDestinationPredicate);
    }

    public void visit(QueryExpression.Aggregation.AggrCount aggrCount) {
        this.visitAggregation((QueryExpression.Aggregation.AbstractAggregation)aggrCount);
    }

    public void visit(QueryExpression.Aggregation.AggrListagg aggrListagg) {
        this.visitAggregation((QueryExpression.Aggregation.AbstractAggregation)aggrListagg);
    }

    public void visit(QueryExpression.Aggregation.AggrJsonArrayagg aggrJsonArrayagg) {
        this.visitAggregation((QueryExpression.Aggregation.AbstractAggregation)aggrJsonArrayagg);
        for (OrderByElem orderByElem : aggrJsonArrayagg.getOrderBy().getElements()) {
            orderByElem.getExp().accept((QueryExpressionVisitor)this);
        }
    }

    public void visit(QueryExpression.Aggregation.AggrMin aggrMin) {
        this.visitAggregation((QueryExpression.Aggregation.AbstractAggregation)aggrMin);
    }

    public void visit(QueryExpression.Aggregation.AggrMax aggrMax) {
        this.visitAggregation((QueryExpression.Aggregation.AbstractAggregation)aggrMax);
    }

    public void visit(QueryExpression.Aggregation.AggrSum aggrSum) {
        this.visitAggregation((QueryExpression.Aggregation.AbstractAggregation)aggrSum);
    }

    public void visit(QueryExpression.Aggregation.AggrAvg aggrAvg) {
        this.visitAggregation((QueryExpression.Aggregation.AbstractAggregation)aggrAvg);
    }

    public void visit(QueryExpression.Aggregation.AggrArrayAgg aggrArrayagg) {
        this.visitAggregation((QueryExpression.Aggregation.AbstractAggregation)aggrArrayagg);
    }
}

