/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.translation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import oracle.pg.rdbms.pgql.PgqlUtils;
import oracle.pg.rdbms.pgql.QueryContext;
import oracle.pg.rdbms.pgql.pgview.metadata.MetadataConnector;
import oracle.pg.rdbms.pgql.pgview.translation.ExpressionToVarRefReplacer;
import oracle.pg.rdbms.pgql.pgview.translation.ExpressionTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.GraphPatternTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.ModifyTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.OuterExpressionsGetter;
import oracle.pg.rdbms.pgql.pgview.translation.PathTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.SubqueryInfo;
import oracle.pg.rdbms.pgql.pgview.translation.SubqueryVisitor;
import oracle.pg.rdbms.pgql.pgview.translation.VarRefReplacer;
import oracle.pg.rdbms.pgql.pgview.translation.expression.Projection;
import oracle.pg.rdbms.pgql.pgview.translation.expression.TableExpression;
import oracle.pg.rdbms.pgql.pgview.util.Pair;
import oracle.pgql.lang.ir.DerivedTable;
import oracle.pgql.lang.ir.ExpAsVar;
import oracle.pgql.lang.ir.GraphPattern;
import oracle.pgql.lang.ir.GraphQuery;
import oracle.pgql.lang.ir.OrderByElem;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryExpressionVisitor;
import oracle.pgql.lang.ir.QueryPath;
import oracle.pgql.lang.ir.QueryType;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.QueryVertex;
import oracle.pgql.lang.ir.SelectQuery;
import oracle.pgql.lang.ir.TableExpressionType;
import oracle.pgql.lang.ir.VertexPairConnection;
import oracle.pgql.lang.ir.modify.ModifyQuery;
import oracle.pgql.lang.util.AbstractQueryExpressionVisitor;
import oracle.pgql.lang.util.ReplaceExpressions;

public class QueryTranslator {
    private static final int NOT_FOUND = 1000000;
    private static final String WITH_CLAUSE = QueryTranslator.getWithClause(false);
    private static final String WITH_CLAUSE_12C = QueryTranslator.getWithClause(true);

    public static TableExpression translateQuery(GraphQuery graphQuery, MetadataConnector metadataConnector, QueryContext ctx) {
        return QueryTranslator.translateQuery(graphQuery, metadataConnector, ctx, new SubqueryInfo(new HashMap<String, Pair<Boolean, QueryVariable>>(), null, new HashSet<VertexPairConnection>(), false, null, false));
    }

    static TableExpression translateQuery(GraphQuery graphQuery, MetadataConnector metadataConnector, QueryContext ctx, SubqueryInfo subqueryInfo) {
        return QueryTranslator.translateQuery(graphQuery, metadataConnector, ctx, subqueryInfo, new LateralInfo(false, new HashMap<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo>()));
    }

    static TableExpression translateQuery(GraphQuery graphQuery, MetadataConnector metadataConnector, QueryContext ctx, SubqueryInfo subqueryInfo, LateralInfo lateralInfo) {
        boolean isDistinct;
        List<ExpAsVar> selectElements;
        if (graphQuery.getQueryType() == QueryType.SELECT) {
            SelectQuery selectQuery = (SelectQuery)graphQuery;
            selectElements = selectQuery.getProjection().getElements();
            isDistinct = selectQuery.getProjection().isDistinct();
        } else if (graphQuery.getQueryType() == QueryType.MODIFY) {
            selectElements = ModifyTranslator.generateSelectElements((ModifyQuery)graphQuery, metadataConnector);
            isDistinct = false;
        } else {
            throw new UnsupportedOperationException("Query type not supported:" + graphQuery.getQueryType());
        }
        Set constraints = graphQuery.getConstraints();
        List<ExpAsVar> groupByElements = new ArrayList();
        if (graphQuery.getGroupBy() != null) {
            groupByElements = graphQuery.getGroupBy().getElements();
        }
        List orderByElems = graphQuery.getOrderBy().getElements();
        QueryExpression havingExp = graphQuery.getHaving();
        List tableExpressions = graphQuery.getTableExpressions();
        boolean containsLateral = tableExpressions.stream().anyMatch(t -> t.getTableExpressionType() == TableExpressionType.DERIVED_TABLE);
        if (containsLateral) {
            QueryExpression qe;
            for (ExpAsVar eav : selectElements) {
                qe = eav.getExp();
                if (qe.getExpType() != QueryExpression.ExpressionType.VARREF) continue;
                ((QueryExpression.VarRef)qe).getVariable().setAnonymous(false);
            }
            for (ExpAsVar eav : groupByElements) {
                qe = eav.getExp();
                if (qe.getExpType() != QueryExpression.ExpressionType.VARREF) continue;
                ((QueryExpression.VarRef)qe).getVariable().setAnonymous(false);
            }
        }
        HashMap matchVariables = new HashMap();
        tableExpressions.stream().filter(t -> t.getTableExpressionType() == TableExpressionType.GRAPH_PATTERN).map(t -> (GraphPattern)t).forEach(t -> matchVariables.putAll(QueryTranslator.getVerticesAndEdges(t)));
        HashSet<String> dtProjectedVerticesAndEdges = new HashSet<String>();
        HashSet<String> dtAndMatchProjectedVerticesAndEdges = new HashSet<String>(matchVariables.keySet());
        HashMap<String, Set<QueryExpression>> allOuterExpressions = new HashMap<String, Set<QueryExpression>>();
        HashMap<String, Set<QueryExpression>> dtOuterExpressions = new HashMap<String, Set<QueryExpression>>();
        HashMap commonVariables = new HashMap();
        ArrayList<Map<String, QueryVariable>> verticesAndEdges = new ArrayList<Map<String, QueryVariable>>();
        final HashMap<String, Boolean> projectedVariables = new HashMap<String, Boolean>();
        for (oracle.pgql.lang.ir.TableExpression t2 : tableExpressions) {
            Map<String, Set<QueryExpression>> outerExpressions;
            Map<String, QueryVariable> variables;
            switch (t2.getTableExpressionType()) {
                case DERIVED_TABLE: {
                    DerivedTable dt = (DerivedTable)t2;
                    variables = QueryTranslator.getVerticesAndEdges(dt);
                    outerExpressions = OuterExpressionsGetter.getOuterExpressions((QueryExpression)dt, variables, dtAndMatchProjectedVerticesAndEdges);
                    dtOuterExpressions.putAll(outerExpressions);
                    allOuterExpressions.putAll(outerExpressions);
                    variables.keySet().forEach(v -> {
                        if (matchVariables.containsKey(v)) {
                            commonVariables.put(v, (QueryVariable)matchVariables.get(v));
                        }
                    });
                    Set<ExpAsVar> projectedVerticesAndEdges = QueryTranslator.getProjectedVerticesAndEdges(dt.getQuery());
                    Set projectedVars = projectedVerticesAndEdges.stream().map(QueryVariable::getName).collect(Collectors.toSet());
                    dtProjectedVerticesAndEdges.addAll(projectedVars);
                    dtAndMatchProjectedVerticesAndEdges.addAll(projectedVars);
                    dt.accept((QueryExpressionVisitor)new AbstractQueryExpressionVisitor(){

                        public void visit(GraphPattern graphPattern) {
                            QueryTranslator.findJoinVariables(graphPattern, projectedVariables);
                        }
                    });
                    projectedVerticesAndEdges.forEach(var -> {
                        if (!projectedVariables.containsKey(var.getName())) {
                            projectedVariables.put(var.getName(), false);
                        }
                    });
                    break;
                }
                case GRAPH_PATTERN: {
                    GraphPattern gp = (GraphPattern)t2;
                    variables = QueryTranslator.getVerticesAndEdges(gp);
                    outerExpressions = OuterExpressionsGetter.getOuterExpressions(gp, variables, dtProjectedVerticesAndEdges);
                    allOuterExpressions.putAll(outerExpressions);
                    QueryTranslator.findJoinVariables(gp, projectedVariables);
                    variables.values().forEach(var -> {
                        if (!projectedVariables.containsKey(var.getName())) {
                            projectedVariables.put(var.getName(), false);
                        }
                    });
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Table expression not supported: " + t2.getTableExpressionType());
                }
            }
            verticesAndEdges.add(variables);
            HashSet<QueryExpression> replacedExpressions = new HashSet<QueryExpression>();
            outerExpressions.forEach((var, exp) -> replacedExpressions.addAll((Collection<QueryExpression>)exp));
            if (replacedExpressions.isEmpty()) continue;
            t2.accept((QueryExpressionVisitor)new ExpressionToVarRefReplacer(replacedExpressions));
        }
        HashSet<String> previousProjected = new HashSet<String>();
        ArrayList<TableExpression> translations = new ArrayList<TableExpression>();
        Set<String> joinVariables = projectedVariables.keySet().stream().filter(projectedVariables::get).collect(Collectors.toSet());
        final HashSet<String> observedJoinVariables = new HashSet<String>();
        for (int i = 0; i < tableExpressions.size(); ++i) {
            TableExpression translation;
            oracle.pgql.lang.ir.TableExpression t3 = (oracle.pgql.lang.ir.TableExpression)tableExpressions.get(i);
            Map variables = (Map)verticesAndEdges.get(i);
            switch (t3.getTableExpressionType()) {
                case DERIVED_TABLE: {
                    Object q2;
                    DerivedTable dt = (DerivedTable)t3;
                    Set<ExpAsVar> projectedVerticesAndEdges = QueryTranslator.getProjectedVerticesAndEdges(dt.getQuery());
                    QueryTranslator.pushSubSelectElements(selectElements, constraints, groupByElements, orderByElems, havingExp, dt.getQuery(), projectedVerticesAndEdges, matchVariables.keySet(), metadataConnector, joinVariables);
                    Map<String, QueryVariable> renamedVariables = QueryTranslator.getRenamedVariables(projectedVerticesAndEdges, groupByElements);
                    Set<String> subSelectVars = dt.getQuery().getProjection().getElements().stream().map(e -> PgqlUtils.escapeAndEnquoteIdentifier(e.getExp().toString())).collect(Collectors.toSet());
                    for (String variable : allOuterExpressions.keySet()) {
                        if (!variables.containsKey(variable) && !renamedVariables.containsKey(variable)) continue;
                        for (Object q2 : (Set)allOuterExpressions.get(variable)) {
                            GraphPatternTranslator.addSubSelectExpression((QueryExpression)q2, subSelectVars, (List<ExpAsVar>)dt.getQuery().getProjection().getElements());
                        }
                    }
                    if (renamedVariables.size() > 0) {
                        for (ExpAsVar expAsVar : dt.getQuery().getProjection().getElements()) {
                            QueryTranslator.replaceRenamedVariables(expAsVar, renamedVariables);
                        }
                    }
                    dt.accept((QueryExpressionVisitor)new AbstractQueryExpressionVisitor(){

                        public void visit(GraphPattern graphPattern) {
                            QueryTranslator.addJoinConstraints(graphPattern, observedJoinVariables);
                        }
                    });
                    if (previousProjected.size() > 0) {
                        VarRefReplacer.replaceExpressions((QueryExpression)dt, previousProjected);
                    }
                    HashSet<String> previousVariables = new HashSet<String>(subqueryInfo.variables.keySet());
                    translation = QueryTranslator.translateQuery((GraphQuery)dt.getQuery(), metadataConnector, ctx, subqueryInfo, new LateralInfo(dt.isLateral(), lateralInfo.pathAggregations));
                    translation.needsAliasWrap();
                    HashSet<String> newVariables = new HashSet<String>(subqueryInfo.variables.keySet());
                    newVariables.removeAll(previousVariables);
                    Set projected = dt.getQuery().getProjection().getElements().stream().map(QueryVariable::getName).collect(Collectors.toSet());
                    q2 = newVariables.iterator();
                    while (q2.hasNext()) {
                        String key = (String)q2.next();
                        if (projected.contains(key)) continue;
                        subqueryInfo.variables.remove(key);
                    }
                    previousProjected.addAll(projected);
                    projectedVerticesAndEdges.forEach(var -> observedJoinVariables.add(var.getName()));
                    break;
                }
                case GRAPH_PATTERN: {
                    Set<String> subSelectVars;
                    GraphPattern gp = (GraphPattern)t3;
                    ArrayList<ExpAsVar> subSelectElements = new ArrayList<ExpAsVar>();
                    if (tableExpressions.size() == 1) {
                        subSelectElements.addAll(selectElements);
                    } else {
                        subSelectVars = QueryTranslator.addSubSelectElements(gp, variables, selectElements, subSelectElements);
                        for (String variable : dtOuterExpressions.keySet()) {
                            if (!variables.containsKey(variable)) continue;
                            for (QueryExpression q : (Set)dtOuterExpressions.get(variable)) {
                                GraphPatternTranslator.addSubSelectExpression(q, subSelectVars, subSelectElements);
                            }
                        }
                        for (String variable : commonVariables.keySet()) {
                            if (!variables.containsKey(variable)) continue;
                            QueryVariable q = (QueryVariable)commonVariables.get(variable);
                            int numKeyColumns = QueryTranslator.getCompatibleKeyColumns((QueryVertex)q, PgqlUtils.buildList(gp), metadataConnector);
                            if (numKeyColumns != -1) {
                                GraphPatternTranslator.addSubSelectExpression(new ExpAsVar((QueryExpression)new QueryExpression.FunctionCall("_ora_comp_key_f_", PgqlUtils.buildList(new QueryExpression.VarRef(q))), "_ora_comp_key_" + q.getName() + "_" + numKeyColumns, false), subSelectVars, subSelectElements);
                                continue;
                            }
                            GraphPatternTranslator.addSubSelectExpression((QueryExpression)new QueryExpression.VarRef(q), subSelectVars, subSelectElements);
                        }
                        QueryTranslator.addJoinConstraints(gp, observedJoinVariables);
                    }
                    if (previousProjected.size() > 0) {
                        VarRefReplacer.replaceExpressions(gp, previousProjected);
                    }
                    translation = GraphPatternTranslator.translateGraphPattern(subSelectElements, gp, groupByElements, orderByElems, havingExp, lateralInfo.pathAggregations, metadataConnector, ctx, subqueryInfo);
                    variables.values().forEach(var -> observedJoinVariables.add(var.getName()));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Table expression type not supported:" + t3.getTableExpressionType());
                }
            }
            translation.setIsSubquery(containsLateral);
            translations.add(translation);
        }
        VarRefReplacer.replaceExpressions(selectElements, constraints, groupByElements, orderByElems, havingExp, previousProjected);
        return QueryTranslator.wrapForModificators(translations, QueryTranslator.needsWithClause(graphQuery), selectElements, isDistinct, constraints, groupByElements, orderByElems, havingExp, graphQuery.getOffset(), graphQuery.getLimit(), containsLateral, metadataConnector, ctx, subqueryInfo, lateralInfo);
    }

    private static boolean needsWithClause(GraphQuery graphQuery) {
        final boolean[] needsWithClause = new boolean[]{false};
        graphQuery.accept((QueryExpressionVisitor)new AbstractQueryExpressionVisitor(){

            public void visit(QueryPath path) {
                if (PathTranslator.useWithClause(path)) {
                    needsWithClause[0] = true;
                }
            }
        });
        return needsWithClause[0];
    }

    private static TableExpression wrapForModificators(List<TableExpression> tabs, boolean addWithClause, List<ExpAsVar> selectElements, boolean isDistinct, Set<QueryExpression> constraints, List<ExpAsVar> groupByElems, List<OrderByElem> orderByElems, QueryExpression havingExp, QueryExpression offsetExp, QueryExpression limitExp, boolean useAlias, MetadataConnector metadataConnector, QueryContext ctx, SubqueryInfo subqueryInfo, LateralInfo lateralInfo) {
        String withClause = addWithClause ? QueryTranslator.buildWithClause(ctx) : "";
        ArrayList<Pair<String, String>> newSelectElements = new ArrayList<Pair<String, String>>();
        boolean addAggregate = groupByElems.size() > 0;
        selectElements.forEach(x -> {
            if (x.getExp().getExpType() == QueryExpression.ExpressionType.FUNCTION_CALL && x.getName().startsWith("_ora_comp_key_")) {
                List<Pair<String, String>> keyColumns = QueryTranslator.splitCompositeKey(x);
                for (Pair<String, String> keyColumn : keyColumns) {
                    newSelectElements.add(new Pair<String, String>(ExpressionTranslator.aggregateIfRequired((String)keyColumn.first, addAggregate), (String)keyColumn.second));
                }
            } else {
                String select = ExpressionTranslator.translateQueryExpression(x.getExp(), new ExpressionTranslator.QueryExpTransOptions(addAggregate, useAlias, false, true, lateralInfo.pathAggregations, metadataConnector, ctx, subqueryInfo));
                newSelectElements.add(new Pair<String, String>(select, x.getName()));
            }
        });
        HashSet whereExpressions = new HashSet();
        constraints.forEach(x -> whereExpressions.add(ExpressionTranslator.translateQueryExpression(x, new ExpressionTranslator.QueryExpTransOptions(addAggregate, useAlias, false, false, lateralInfo.pathAggregations, metadataConnector, ctx, subqueryInfo))));
        String whereExpression = String.join((CharSequence)" AND ", whereExpressions);
        ArrayList<String> groupBy = new ArrayList<String>();
        groupByElems.forEach(x -> {
            if (x.getExp().getExpType() == QueryExpression.ExpressionType.FUNCTION_CALL && x.getName().startsWith("_ora_comp_key_")) {
                groupBy.addAll(QueryTranslator.splitCompositeKey(x).stream().map(y -> (String)y.first).collect(Collectors.toList()));
            } else {
                groupBy.add(ExpressionTranslator.translateQueryExpression(x.getExp(), new ExpressionTranslator.QueryExpTransOptions(false, true, false, false, lateralInfo.pathAggregations, metadataConnector, ctx, subqueryInfo)));
            }
        });
        String having = havingExp == null ? null : ExpressionTranslator.translateQueryExpression(havingExp, new ExpressionTranslator.QueryExpTransOptions(true, false, false, false, lateralInfo.pathAggregations, metadataConnector, ctx, subqueryInfo));
        List<String> orderBy = orderByElems.stream().map(x -> ExpressionTranslator.translateQueryExpression(x.getExp(), new ExpressionTranslator.QueryExpTransOptions(groupByElems.size() > 0, true, false, false, lateralInfo.pathAggregations, metadataConnector, ctx, subqueryInfo)) + (x.isAscending() ? "" : " DESC")).collect(Collectors.toList());
        String offset = "";
        if (offsetExp != null) {
            if (offsetExp.getExpType() == QueryExpression.ExpressionType.INTEGER || offsetExp.getExpType() == QueryExpression.ExpressionType.BIND_VARIABLE) {
                offset = ExpressionTranslator.translateQueryExpression(offsetExp, new ExpressionTranslator.QueryExpTransOptions(false, false, false, false, lateralInfo.pathAggregations, metadataConnector, ctx, subqueryInfo));
            } else {
                throw new IllegalArgumentException("Unexpected expression type for OFFSET");
            }
        }
        String limit = "";
        if (limitExp != null) {
            if (limitExp.getExpType() == QueryExpression.ExpressionType.INTEGER || limitExp.getExpType() == QueryExpression.ExpressionType.BIND_VARIABLE) {
                limit = ExpressionTranslator.translateQueryExpression(limitExp, new ExpressionTranslator.QueryExpTransOptions(false, false, false, false, lateralInfo.pathAggregations, metadataConnector, ctx, subqueryInfo));
            } else {
                throw new IllegalArgumentException("Unexpected expression type for LIMIT");
            }
        }
        return new Projection(isDistinct, lateralInfo.isLateral, withClause, newSelectElements, tabs, whereExpression, groupBy, having, orderBy, offset, limit);
    }

    private static String buildWithClause(QueryContext ctx) {
        String withClause = ctx.isShortestPathCursorSupported() ? WITH_CLAUSE : WITH_CLAUSE_12C;
        withClause = ctx.spCreateView ? withClause.replaceAll("/\\*spCreateView", "").replaceAll("spCreateView\\*/", "") : withClause.replaceAll("/\\*spNoViews", "").replaceAll("spNoViews\\*/", "");
        withClause = ctx.spCreateTable ? withClause.replaceAll("/\\*spCreateTable", "").replaceAll("spCreateTable\\*/", "") : withClause.replaceAll("/\\*spCreateXml", "").replaceAll("spCreateXml\\*/", "");
        withClause = ctx.spStartVC ? withClause.replaceFirst("/\\*spStartVC", "").replaceFirst("spStartVC\\*/", "") : withClause.replaceFirst("/\\*spStartCL", "").replaceFirst("spStartCL\\*/", "");
        withClause = ctx.spEndVC ? withClause.replaceFirst("/\\*spEndVC", "").replaceFirst("spEndVC\\*/", "") : withClause.replaceFirst("/\\*spEndCL", "").replaceFirst("spEndCL\\*/", "");
        withClause = ctx.spPathVC ? withClause.replaceFirst("/\\*spPathVC", "").replaceFirst("spPathVC\\*/", "") : withClause.replaceFirst("/\\*spPathCL", "").replaceFirst("spPathCL\\*/", "");
        return withClause;
    }

    private static List<Pair<String, String>> splitCompositeKey(ExpAsVar x) {
        ArrayList<Pair<String, String>> keyColumns = new ArrayList<Pair<String, String>>();
        int numKeyColumns = Integer.parseInt(x.getName().substring(x.getName().lastIndexOf("_") + 1));
        String varName = x.getName().substring("_ora_comp_key_".length(), x.getName().lastIndexOf("_"));
        String var = ((QueryExpression.VarRef)((QueryExpression.FunctionCall)x.getExp()).getArgs().get(0)).getVariable().getName();
        for (int i = 0; i <= numKeyColumns; ++i) {
            keyColumns.add(new Pair<String, String>(PgqlUtils.escapeAndEnquoteIdentifier(var + "_" + i), PgqlUtils.escapeAndEnquoteIdentifier(varName + "_" + i)));
        }
        return keyColumns;
    }

    private static String getWithClause(boolean for12c) {
        String fileName = for12c ? "with_clause_12c.sql" : "with_clause.sql";
        try (Scanner in = new Scanner(QueryTranslator.class.getClassLoader().getResourceAsStream(fileName)).useDelimiter("\\A");){
            String string = in.next();
            return string;
        }
    }

    private static Set<ExpAsVar> getProjectedVerticesAndEdges(SelectQuery selectQuery) {
        HashSet<ExpAsVar> projectedVars = new HashSet<ExpAsVar>();
        List childSelectElements = selectQuery.getProjection().getElements();
        for (ExpAsVar childElement : childSelectElements) {
            if (!GraphPatternTranslator.isVertexOrEdgeReference(childElement)) continue;
            projectedVars.add(childElement);
        }
        return projectedVars;
    }

    private static void pushSubSelectElements(List<ExpAsVar> parentSelectElements, Set<QueryExpression> parentConstraints, List<ExpAsVar> parentGroupByElements, List<OrderByElem> parentOrderByElems, QueryExpression parentHaving, SelectQuery selectQuery, Set<ExpAsVar> projectedVerticesAndEdges, Set<String> matchVariables, MetadataConnector metadataConnector, Set<String> joinVariables) {
        HashMap<String, Pair<Boolean, QueryVariable>> projectedVariables = new HashMap<String, Pair<Boolean, QueryVariable>>();
        HashMap<String, Pair<Boolean, QueryVariable>> groupByVariables = new HashMap<String, Pair<Boolean, QueryVariable>>();
        for (ExpAsVar childElement : projectedVerticesAndEdges) {
            if (matchVariables.contains(childElement.getName())) continue;
            projectedVariables.put(childElement.getName(), new Pair<Boolean, ExpAsVar>(true, childElement));
        }
        for (ExpAsVar parentElement : parentGroupByElements) {
            QueryVariable var;
            Object type;
            if (parentElement.getExp().getExpType() != QueryExpression.ExpressionType.VARREF) continue;
            if (projectedVariables.containsKey(parentElement.getName())) {
                groupByVariables.put(parentElement.getName(), new Pair<Boolean, ExpAsVar>(true, parentElement));
            }
            if ((type = ExpressionTranslator.getQueryVariable(var = ((QueryExpression.VarRef)parentElement.getExp()).getVariable()).getVariableType()) != QueryVariable.VariableType.VERTEX && type != QueryVariable.VariableType.EDGE || var.getName().equals(parentElement.getName())) continue;
            projectedVariables.put(parentElement.getName(), new Pair<Boolean, QueryVariable>(true, var));
        }
        HashSet<QueryVertex> commonVertices = new HashSet<QueryVertex>();
        HashSet<QueryVertex> commonJoinVertices = new HashSet<QueryVertex>();
        ArrayList<ExpAsVar> subSelectElems = new ArrayList<ExpAsVar>();
        for (ExpAsVar expAsVar2 : parentSelectElements) {
            GraphPatternTranslator.addSubSelectElements(expAsVar2.getExp(), subSelectElems, new HashSet<String>(), new HashMap<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo>(), new HashMap<QueryVariable, QueryPath>(), true, projectedVariables, commonVertices, commonJoinVertices);
        }
        for (QueryExpression queryExpression : parentConstraints) {
            GraphPatternTranslator.addSubSelectElements(queryExpression, subSelectElems, new HashSet<String>(), new HashMap<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo>(), new HashMap<QueryVariable, QueryPath>(), true, projectedVariables, commonVertices, commonJoinVertices);
        }
        for (ExpAsVar expAsVar3 : parentGroupByElements) {
            GraphPatternTranslator.addSubSelectElements(expAsVar3.getExp(), subSelectElems, new HashSet<String>(), new HashMap<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo>(), new HashMap<QueryVariable, QueryPath>(), true, projectedVariables, commonVertices, commonJoinVertices);
        }
        for (OrderByElem orderByElem : parentOrderByElems) {
            GraphPatternTranslator.addSubSelectElements(orderByElem.getExp(), subSelectElems, new HashSet<String>(), new HashMap<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo>(), new HashMap<QueryVariable, QueryPath>(), true, projectedVariables, commonVertices, commonJoinVertices);
        }
        if (parentHaving != null) {
            GraphPatternTranslator.addSubSelectElements(parentHaving, subSelectElems, new HashSet<String>(), new HashMap<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo>(), new HashMap<QueryVariable, QueryPath>(), true, projectedVariables, commonVertices, commonJoinVertices);
        }
        Set<String> subSelectVars = selectQuery.getProjection().getElements().stream().map(expAsVar -> PgqlUtils.escapeAndEnquoteIdentifier(expAsVar.toString())).collect(Collectors.toSet());
        for (ExpAsVar expAsVar2 : subSelectElems) {
            GraphPatternTranslator.addSubSelectExpression(expAsVar2, subSelectVars, (List<ExpAsVar>)selectQuery.getProjection().getElements());
        }
        for (ExpAsVar childElement : projectedVerticesAndEdges) {
            QueryVertex vertex;
            int numKeyColumns;
            QueryVariable var;
            if (childElement.getExp().getExpType() != QueryExpression.ExpressionType.VARREF || (var = ExpressionTranslator.getQueryVariable((QueryExpression.VarRef)childElement.getExp())).getVariableType() != QueryVariable.VariableType.VERTEX || !joinVariables.contains(childElement.getName()) || (numKeyColumns = QueryTranslator.getCompatibleKeyColumns(vertex = (QueryVertex)var, selectQuery.getTableExpressions(), metadataConnector)) == -1) continue;
            GraphPatternTranslator.addSubSelectExpression(new ExpAsVar((QueryExpression)new QueryExpression.FunctionCall("_ora_comp_key_f_", PgqlUtils.buildList(new QueryExpression.VarRef((QueryVariable)childElement))), "_ora_comp_key_" + childElement.getName() + "_" + numKeyColumns, false), subSelectVars, (List<ExpAsVar>)selectQuery.getProjection().getElements());
        }
        for (QueryVertex commonVertex : commonJoinVertices) {
            int numKeyColumns = QueryTranslator.getCompatibleKeyColumns(commonVertex, selectQuery.getTableExpressions(), metadataConnector);
            if (numKeyColumns == -1) continue;
            GraphPatternTranslator.addSubSelectExpression(new ExpAsVar((QueryExpression)new QueryExpression.FunctionCall("_ora_comp_key_f_", PgqlUtils.buildList(new QueryExpression.VarRef((QueryVariable)commonVertex))), "_ora_comp_key_" + commonVertex.getName() + "_" + numKeyColumns, false), subSelectVars, (List<ExpAsVar>)selectQuery.getProjection().getElements());
            if (!groupByVariables.containsKey(commonVertex.getName())) continue;
            parentGroupByElements.add(new ExpAsVar((QueryExpression)new QueryExpression.FunctionCall("_ora_comp_key_f_", PgqlUtils.buildList(new QueryExpression.VarRef((QueryVariable)commonVertex))), "_ora_comp_key_" + commonVertex.getName() + "_" + numKeyColumns, true));
        }
        GraphPatternTranslator.addExtraGroupByElements(commonVertices, parentGroupByElements, groupByVariables, subSelectElems);
        if (subSelectElems.size() > 0) {
            for (OrderByElem orderByElem : selectQuery.getOrderBy().getElements()) {
                for (final ExpAsVar expAsVar3 : subSelectElems) {
                    orderByElem.accept((QueryExpressionVisitor)new ReplaceExpressions(){

                        protected boolean matches(QueryExpression expression) {
                            return expression.equals(expAsVar3.getExp());
                        }

                        public QueryExpression replace(QueryExpression expression) {
                            return new QueryExpression.VarRef((QueryVariable)expAsVar3);
                        }
                    });
                }
            }
        }
    }

    private static Set<String> addSubSelectElements(GraphPattern gp, Map<String, QueryVariable> variables, List<ExpAsVar> selectElements, List<ExpAsVar> subSelectElements) {
        HashSet<String> subSelectVars = new HashSet<String>();
        Map<QueryVariable, QueryPath> pathVariables = GraphPatternTranslator.collectPathVariables(gp);
        HashMap<String, Pair<Boolean, QueryVariable>> gpVariables = new HashMap<String, Pair<Boolean, QueryVariable>>();
        variables.forEach((s, v) -> gpVariables.put((String)s, new Pair<Boolean, QueryVariable>(true, (QueryVariable)v)));
        for (ExpAsVar selectElement : selectElements) {
            GraphPatternTranslator.addSubSelectElements(selectElement.getExp(), subSelectElements, subSelectVars, new HashMap<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo>(), pathVariables, true, gpVariables, new HashSet<QueryVertex>(), new HashSet<QueryVertex>());
        }
        return subSelectVars;
    }

    private static Map<String, QueryVariable> getRenamedVariables(Set<ExpAsVar> selectElements, List<ExpAsVar> groupByElements) {
        HashMap<String, QueryVariable> renamedVariables = new HashMap<String, QueryVariable>();
        for (ExpAsVar newVariable : selectElements) {
            QueryTranslator.addIfIsRenamed(renamedVariables, newVariable);
        }
        for (ExpAsVar newVariable : groupByElements) {
            QueryTranslator.addIfIsRenamed(renamedVariables, newVariable);
        }
        return renamedVariables;
    }

    private static void addIfIsRenamed(Map<String, QueryVariable> renamedVariables, ExpAsVar newVariable) {
        QueryVariable originalVariable;
        if (newVariable.getExp().getExpType() == QueryExpression.ExpressionType.VARREF && !(originalVariable = ((QueryExpression.VarRef)newVariable.getExp()).getVariable()).getName().equals(newVariable.getName())) {
            renamedVariables.put(newVariable.getName(), originalVariable);
        }
    }

    private static void replaceRenamedVariables(final ExpAsVar expAsVar, final Map<String, QueryVariable> renamedVariables) {
        expAsVar.accept((QueryExpressionVisitor)new SubqueryVisitor(){

            @Override
            public void visitVarRef(QueryExpression.VarRef varRef) {
            }

            @Override
            public void visitPropertyAccess(QueryExpression.PropertyAccess propertyAccess) {
                String varName = propertyAccess.getVariable().getName();
                if (renamedVariables.containsKey(varName)) {
                    expAsVar.setExp((QueryExpression)new QueryExpression.PropertyAccess((QueryVariable)renamedVariables.get(varName), propertyAccess.getPropertyName()));
                }
            }

            private void replaceFunctionVariable(QueryExpression.FunctionCall functionCall) {
                String varName = ((QueryExpression.VarRef)functionCall.getArgs().get(0)).getVariable().getName();
                if (renamedVariables.containsKey(varName)) {
                    QueryExpression.FunctionCall fCopy = new QueryExpression.FunctionCall(functionCall.getFunctionName(), PgqlUtils.buildList(new QueryExpression.VarRef((QueryVariable)renamedVariables.get(varName))));
                    expAsVar.setExp((QueryExpression)fCopy);
                }
            }

            @Override
            public void visitIdOrLabelFunction(QueryExpression.FunctionCall functionCall) {
                this.replaceFunctionVariable(functionCall);
            }

            @Override
            public void visitKeyColumnsFunction(QueryExpression.FunctionCall functionCall) {
                this.replaceFunctionVariable(functionCall);
            }

            @Override
            public void visitVarRefSubqueryFunction(QueryExpression.FunctionCall functionCall) {
            }

            @Override
            public void visitIsSourceOrIsDestOfFunction(QueryExpression.FunctionCall functionCall) {
            }

            @Override
            public void visitSrcDstPredicate(QueryExpression.SourceDestinationPredicate sourceDestinationPredicate) {
            }

            @Override
            public void visitHasLabelFunction(QueryExpression.FunctionCall functionCall) {
            }

            @Override
            public void visitAggregation(QueryExpression.Aggregation.AbstractAggregation agg) {
            }
        });
    }

    private static Map<String, QueryVariable> getVerticesAndEdges(oracle.pgql.lang.ir.TableExpression te) {
        switch (te.getTableExpressionType()) {
            case DERIVED_TABLE: {
                return QueryTranslator.getVerticesAndEdges((DerivedTable)te);
            }
            case GRAPH_PATTERN: {
                return QueryTranslator.getVerticesAndEdges((GraphPattern)te);
            }
        }
        throw new UnsupportedOperationException("Unsupported table expression:" + te.getTableExpressionType());
    }

    private static Map<String, QueryVariable> getVerticesAndEdges(GraphPattern gp) {
        HashMap<String, QueryVariable> variables = new HashMap<String, QueryVariable>();
        gp.getVertices().forEach(v -> variables.put(v.getName(), (QueryVariable)v));
        gp.getConnections().forEach(c -> variables.putAll(QueryTranslator.getVerticesAndEdges(c)));
        gp.getConstraints().forEach(c -> variables.putAll(QueryTranslator.getVerticesAndEdges(c)));
        return variables;
    }

    private static Map<String, QueryVariable> getVerticesAndEdges(VertexPairConnection vc) {
        HashMap<String, QueryVariable> variables = new HashMap<String, QueryVariable>();
        if (vc.getVariableType() == QueryVariable.VariableType.EDGE) {
            variables.put(vc.getName(), (QueryVariable)vc);
        } else if (vc.getVariableType() == QueryVariable.VariableType.PATH) {
            QueryPath p = (QueryPath)vc;
            p.getVertices().forEach(v -> variables.put(v.getName(), (QueryVariable)v));
            p.getConnections().forEach(d -> variables.putAll(QueryTranslator.getVerticesAndEdges(d)));
        }
        return variables;
    }

    private static Map<String, QueryVariable> getVerticesAndEdges(DerivedTable dt) {
        HashMap<String, QueryVariable> variables = new HashMap<String, QueryVariable>();
        dt.getQuery().getTableExpressions().forEach(t -> {
            switch (t.getTableExpressionType()) {
                case GRAPH_PATTERN: {
                    variables.putAll(QueryTranslator.getVerticesAndEdges((GraphPattern)t));
                    break;
                }
                case DERIVED_TABLE: {
                    variables.putAll(QueryTranslator.getVerticesAndEdges((DerivedTable)t));
                }
            }
        });
        return variables;
    }

    private static Map<String, QueryVariable> getVerticesAndEdges(QueryExpression.Subquery subquery) {
        HashMap<String, QueryVariable> variables = new HashMap<String, QueryVariable>();
        subquery.getQuery().getTableExpressions().forEach(t -> variables.putAll(QueryTranslator.getVerticesAndEdges(t)));
        return variables;
    }

    private static Map<String, QueryVariable> getVerticesAndEdges(QueryExpression exp) {
        final HashMap<String, QueryVariable> variables = new HashMap<String, QueryVariable>();
        exp.accept((QueryExpressionVisitor)new AbstractQueryExpressionVisitor(){

            public void visit(QueryExpression.Function.Exists existsSubquery) {
                variables.putAll(QueryTranslator.getVerticesAndEdges((QueryExpression.Subquery)existsSubquery));
            }

            public void visit(QueryExpression.ScalarSubquery scalarSubquery) {
                variables.putAll(QueryTranslator.getVerticesAndEdges((QueryExpression.Subquery)scalarSubquery));
            }
        });
        return variables;
    }

    private static void addJoinConstraints(GraphPattern graphPattern, Set<String> joinVariables) {
        Map<String, QueryVariable> variables = QueryTranslator.getVerticesAndEdges(graphPattern);
        for (String joinVar : joinVariables) {
            if (!variables.containsKey(joinVar)) continue;
            graphPattern.getConstraints().add(new QueryExpression.FunctionCall("_ora_join_key_to_var_", PgqlUtils.buildList(new QueryExpression.VarRef(variables.get(joinVar)))));
        }
    }

    private static void findJoinVariables(GraphPattern graphPattern, Map<String, Boolean> joinVariables) {
        Map<String, QueryVariable> variables = QueryTranslator.getVerticesAndEdges(graphPattern);
        for (String joinVar : joinVariables.keySet()) {
            if (!variables.containsKey(joinVar)) continue;
            joinVariables.put(joinVar, true);
        }
    }

    private static int getCompatibleKeyColumns(QueryVertex vertex, List<oracle.pgql.lang.ir.TableExpression> tableExpressions, MetadataConnector metadataConnector) {
        for (oracle.pgql.lang.ir.TableExpression t : tableExpressions) {
            switch (t.getTableExpressionType()) {
                case GRAPH_PATTERN: {
                    GraphPattern gp = (GraphPattern)t;
                    if (!gp.getVertices().contains(vertex)) break;
                    return GraphPatternTranslator.getCompatibleKeyColumns(vertex, gp, metadataConnector);
                }
                case DERIVED_TABLE: {
                    DerivedTable dt = (DerivedTable)t;
                    int keyColumns = QueryTranslator.getCompatibleKeyColumns(vertex, dt.getQuery().getTableExpressions(), metadataConnector);
                    if (keyColumns == 1000000) break;
                    return keyColumns;
                }
            }
        }
        return 1000000;
    }

    public static class LateralInfo {
        public final boolean isLateral;
        public final Map<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo> pathAggregations;

        public LateralInfo(boolean isLateral, Map<QueryExpression.Aggregation, PathTranslator.PathAggregateInfo> pathAggregations) {
            this.isLateral = isLateral;
            this.pathAggregations = pathAggregations;
        }
    }
}

