/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.translation;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import oracle.pg.rdbms.pgql.pgview.metadata.MetadataConnector;
import oracle.pgql.lang.ir.GraphPattern;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryPath;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.QueryVertex;
import oracle.pgql.lang.ir.VertexPairConnection;

public class LabelTranslator {
    static Map<QueryVariable, Set<String>> generateVariableLabelMap(GraphPattern graphPattern, MetadataConnector metadataConnector) {
        return LabelTranslator.generateVariableLabelMap(graphPattern.getVertices(), graphPattern.getConnections(), graphPattern.getConstraints(), metadataConnector);
    }

    static Map<QueryVariable, Set<String>> generateVariableLabelMap(QueryPath queryPath, MetadataConnector metadataConnector) {
        return LabelTranslator.generateVariableLabelMap(new HashSet<QueryVertex>(queryPath.getVertices()), new HashSet<VertexPairConnection>(queryPath.getConnections()), queryPath.getConstraints(), metadataConnector);
    }

    private static Map<QueryVariable, Set<String>> generateVariableLabelMap(Set<QueryVertex> vertices, Set<VertexPairConnection> connections, Set<QueryExpression> constraints, MetadataConnector metadataConnector) {
        HashMap<QueryVariable, Set<String>> variableLabelMap = new HashMap<QueryVariable, Set<String>>();
        Set<String> allPossibleEdgeLabels = metadataConnector.getAllEdgeLabels();
        Set<String> allPossibleVertexLabels = metadataConnector.getAllVertexLabels();
        vertices.forEach(v -> variableLabelMap.put((QueryVariable)v, new HashSet(allPossibleVertexLabels)));
        connections.forEach(v -> {
            if (v.getVariableType() == QueryVariable.VariableType.EDGE) {
                variableLabelMap.put((QueryVariable)v, new HashSet(allPossibleEdgeLabels));
            } else if (v.getVariableType() == QueryVariable.VariableType.PATH) {
                variableLabelMap.put((QueryVariable)v, new HashSet());
            }
        });
        constraints.stream().filter(LabelTranslator::isLabelExpression).forEach(queryExpression -> {
            QueryVariable var = LabelTranslator.getVarForLabelExpression(queryExpression);
            Set<String> assignedLabels = LabelTranslator.collectLabels(queryExpression);
            ((Set)variableLabelMap.get(var)).retainAll(assignedLabels);
            if (((Set)variableLabelMap.get(var)).size() == 0 && assignedLabels.size() > 0) {
                throw new IllegalArgumentException("Label " + assignedLabels.iterator().next() + " does not exist");
            }
        });
        for (QueryVariable var : variableLabelMap.keySet()) {
            if (var.getVariableType() == QueryVariable.VariableType.VERTEX) {
                LabelTranslator.validateLabelsForVar(variableLabelMap, var, metadataConnector::isVertexLabel);
                continue;
            }
            if (var.getVariableType() == QueryVariable.VariableType.EDGE) {
                LabelTranslator.validateLabelsForVar(variableLabelMap, var, metadataConnector::isEdgeLabel);
                continue;
            }
            if (var.getVariableType() == QueryVariable.VariableType.PATH) continue;
            throw new IllegalArgumentException("Invalid variable type in label map");
        }
        return variableLabelMap;
    }

    static void validateLabelsForVar(Map<QueryVariable, Set<String>> variableLabelMap, QueryVariable var, Function<String, Boolean> validator) {
        Set<String> labels = variableLabelMap.get(var);
        if (!labels.stream().allMatch(validator::apply)) {
            throw new IllegalArgumentException("Invalid labels are present");
        }
    }

    static boolean isLabelExpression(QueryExpression queryExpression) {
        switch (queryExpression.getExpType()) {
            case FUNCTION_CALL: {
                QueryExpression.FunctionCall functionCall = (QueryExpression.FunctionCall)queryExpression;
                return functionCall.getFunctionName().equals("has_label");
            }
            case OR: {
                QueryExpression.LogicalExpression.Or orExpression = (QueryExpression.LogicalExpression.Or)queryExpression;
                return LabelTranslator.isLabelExpression(orExpression.getExp1()) && LabelTranslator.isLabelExpression(orExpression.getExp2());
            }
        }
        return false;
    }

    private static QueryVariable getVarForLabelExpression(QueryExpression queryExpression) {
        switch (queryExpression.getExpType()) {
            case FUNCTION_CALL: {
                QueryExpression.FunctionCall functionCall = (QueryExpression.FunctionCall)queryExpression;
                List args = functionCall.getArgs();
                assert (args.size() == 2);
                return ((QueryExpression.VarRef)args.get(0)).getVariable();
            }
            case OR: {
                QueryExpression.LogicalExpression.Or orExpression = (QueryExpression.LogicalExpression.Or)queryExpression;
                QueryVariable leftVar = LabelTranslator.getVarForLabelExpression(orExpression.getExp1());
                return leftVar == null ? LabelTranslator.getVarForLabelExpression(orExpression.getExp2()) : leftVar;
            }
        }
        return null;
    }

    private static Set<String> collectLabels(QueryExpression queryExpression) {
        switch (queryExpression.getExpType()) {
            case FUNCTION_CALL: {
                if (!LabelTranslator.isLabelExpression(queryExpression)) break;
                QueryExpression.FunctionCall functionCall = (QueryExpression.FunctionCall)queryExpression;
                List args = functionCall.getArgs();
                assert (args.size() == 2);
                String label = (String)((QueryExpression.Constant.ConstString)args.get(1)).getValue();
                return Collections.singleton(label);
            }
            case OR: {
                QueryExpression.LogicalExpression.Or orExpression = (QueryExpression.LogicalExpression.Or)queryExpression;
                Set<String> leftChildLabels = LabelTranslator.collectLabels(orExpression.getExp1());
                Set<String> rightChildLabels = LabelTranslator.collectLabels(orExpression.getExp2());
                HashSet<String> allLabels = new HashSet<String>();
                allLabels.addAll(leftChildLabels);
                allLabels.addAll(rightChildLabels);
                return allLabels;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported label expression type: " + queryExpression.getExpType());
            }
        }
        return new HashSet<String>();
    }
}

