/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.digsig;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.StringCharacterIterator;
import java.util.Enumeration;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cert.CRLDistPoint;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cert.ext.CRLDistPointExtension;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.util.Utils;
import oracle.security.digsig.DigitalSignatureException;

class Utilities {
    Utilities() {
    }

    static CRL getCRL(String url) throws DigitalSignatureException {
        try {
            CRL crl = null;
            if (url.toUpperCase().startsWith("FILE:")) {
                crl = new CRL(new File(url.substring("FILE:".length())));
            } else if (url.toUpperCase().startsWith("HTTP:")) {
                URL httpUrl = new URL(url);
                crl = new CRL(httpUrl.openStream());
            } else {
                throw new DigitalSignatureException("Unsupported URI scheme");
            }
            return crl;
        }
        catch (Exception e) {
            throw new DigitalSignatureException("Exception during CRL download" + e);
        }
    }

    static X509Certificate convertPhaosX509ToJCEX509Certificate(X509 phaosCert) throws DigitalSignatureException {
        X509Certificate jceCert = null;
        try {
            jceCert = CMSUtils.toX509JCECertificate((X509)phaosCert);
        }
        catch (CertificateException e) {
            throw new DigitalSignatureException("Invalid certfificate format", e);
        }
        return jceCert;
    }

    static X509 convertJCEX509CertificateToPhaosX509(X509Certificate jceCert) throws DigitalSignatureException {
        X509 phaosCert = null;
        try {
            phaosCert = CMSUtils.convertX509((X509Certificate)jceCert);
        }
        catch (CertificateEncodingException e) {
            throw new DigitalSignatureException("Invalid Certificate format", e);
        }
        return phaosCert;
    }

    static String X509toBase64(X509 phaosCert) throws DigitalSignatureException {
        return Utilities.X509toBase64(Utilities.convertPhaosX509ToJCEX509Certificate(phaosCert));
    }

    static String X509toBase64(X509Certificate x509Cert) throws DigitalSignatureException {
        String base64Cert = null;
        try {
            base64Cert = Utils.toBase64((byte[])CMSUtils.convertX509((X509Certificate)x509Cert).getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new DigitalSignatureException("Invalid certfificate format", e);
        }
        return base64Cert;
    }

    static X509 Base64toX509(String b64Encoding) throws DigitalSignatureException {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(Utils.fromBase64((String)b64Encoding));
            X509 c = new X509((InputStream)bis);
            bis.close();
            return c;
        }
        catch (Exception e) {
            throw new DigitalSignatureException("X509 certificate encoding exception");
        }
    }

    static String X509CRLtoBase64(CRL crl) {
        return Utils.toBase64((byte[])crl.getEncoded());
    }

    static CRL Base64toX509CRL(String b64Encoding) throws DigitalSignatureException {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(Utils.fromBase64((String)b64Encoding));
            CRL c = new CRL((InputStream)bis);
            bis.close();
            return c;
        }
        catch (Exception e) {
            throw new DigitalSignatureException("X509 certificate encoding exception");
        }
    }

    static String getCRLDistributionPoints(X509 c) {
        String url = null;
        if (c != null) {
            CRLDistPointExtension crldp = new CRLDistPointExtension();
            Vector crldps = ((CRLDistPointExtension)c.getExtension(crldp.getType())).getCRLDistPoints();
            Enumeration e = crldps.elements();
            while (e.hasMoreElements()) {
                boolean found = false;
                CRLDistPoint dp = (CRLDistPoint)e.nextElement();
                Vector v = dp.getDistPointName().getFullName();
                Enumeration f = v.elements();
                while (f.hasMoreElements()) {
                    ASN1String asn1String;
                    GeneralName g = (GeneralName)f.nextElement();
                    if (g.getType() != GeneralName.Type.URI || !(asn1String = (ASN1String)g.getValue()).getValue().toLowerCase().startsWith("http://")) continue;
                    url = asn1String.getValue();
                    found = true;
                    break;
                }
                if (!found) continue;
                break;
            }
        }
        return url;
    }

    static String StringEscape(String instr) {
        if (instr == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        StringCharacterIterator sci = new StringCharacterIterator(instr);
        char c = sci.first();
        while (c != '\uffff') {
            if (Character.isLetterOrDigit(c) || c == '*' || c == '@' || c == '-' || c == '_' || c == '+' || c == '.' || c == '/') {
                sb.append(c);
            } else {
                sb.append('%');
                sb.append(Integer.toHexString(c));
            }
            c = sci.next();
        }
        return sb.toString();
    }
}

