/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.digsig;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Date;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.cert.AttributeSet;
import oracle.security.crypto.cert.CertificateTrustPolicy;
import oracle.security.crypto.cert.TrustedCAPolicy;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSContentInfo;
import oracle.security.crypto.cms.CMSDataContentInfo;
import oracle.security.crypto.cms.CMSSignedDataContentInfo;
import oracle.security.crypto.cms.CMSSignerInfo;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.util.Utils;
import oracle.security.digsig.CertificateMapper;
import oracle.security.digsig.DigitalSignatureException;
import oracle.security.digsig.KeyStoreWrapper;
import oracle.security.digsig.SignatureProperties;
import oracle.security.digsig.Utilities;
import oracle.security.digsig.Verifier;

public class PKCS7Verifier
extends Verifier {
    private CMSSignerInfo signerInfo;
    private CMSSignedDataContentInfo p7Signature;

    PKCS7Verifier(KeyStoreWrapper pKeyStore, CertificateMapper pCertificateMapper, Properties pConfig) throws DigitalSignatureException {
        super(pKeyStore, pCertificateMapper, pConfig);
        this.verifierSignatureFormat = 2;
    }

    @Override
    public SignatureProperties getSignatureProperties() throws DigitalSignatureException {
        String s;
        X509 cert;
        X509Certificate jceCert;
        int i;
        Enumeration e;
        Vector certs;
        String s2;
        Hashtable<String, Object> sigProperties = new Hashtable<String, Object>();
        super.getSignatureProperties();
        if (!this.verifierStatus || this.signerInfo == null) {
            throw new DigitalSignatureException("Signature verification failed");
        }
        sigProperties.put("SignerCertificateType", "X.509");
        String das = null;
        AlgorithmIdentifier dai = this.signerInfo.getDigestAlgID();
        if (dai.equals((Object)AlgID.sha1) || dai.equals((Object)AlgID.sha_1)) {
            das = "sha_1";
            sigProperties.put("DigestAlgorithm", "SHA1");
        } else if (dai.equals((Object)AlgID.sha)) {
            das = "sha";
            sigProperties.put("DigestAlgorithm", "SHA");
        } else if (dai.equals((Object)AlgID.md5)) {
            das = "md5";
            sigProperties.put("DigestAlgorithm", "MD5");
        } else if (dai.equals((Object)AlgID.md2)) {
            das = "md2";
            sigProperties.put("DigestAlgorithm", "MD2");
        }
        AlgorithmIdentifier sai = this.signerInfo.getDigestEncryptionAlgID();
        if (sai.equals((Object)AlgID.rsaEncryption)) {
            sigProperties.put("SignatureAlgorithm", das + "WithRSAEncryption");
        } else if (sai.equals((Object)AlgID.dsa)) {
            sigProperties.put("SignatureAlgorithm", das + "WithDSA");
        }
        sigProperties.put("SignatureValue", Utils.toBase64((byte[])this.signerInfo.getEncryptedDigest()));
        AttributeSet signedAttrs = this.signerInfo.getSignedAttributes();
        Vector attrValues = null;
        if (signedAttrs != null && (attrValues = signedAttrs.getAttributeValues(CMS.id_signingTime)) != null) {
            Date signingTime = ((ASN1Date)attrValues.elementAt(0)).getValue();
            sigProperties.put("SigningTime", signingTime);
        }
        if (signedAttrs != null && (attrValues = signedAttrs.getAttributeValues(CMS.id_messageDigest)) != null) {
            byte[] digestBits = ((ASN1OctetString)attrValues.elementAt(0)).getValue();
            sigProperties.put("DigestValue", Utils.toBase64((byte[])digestBits));
        }
        if (this.verifierSignerX509Cert != null) {
            s2 = Utilities.X509toBase64(this.verifierSignerX509Cert);
            sigProperties.put("SignerCertificate", s2);
        }
        if (this.verifierCertificateMapper != null) {
            s2 = Utilities.X509toBase64(this.verifierSignerX509Cert);
            sigProperties.put("SignerCertificateID", this.verifierCertificateMapper.getIDByCertificate("X.509", s2));
        }
        if (this.verifierSignerX509Cert != null) {
            certs = this.p7Signature.getCertificates();
            String[] certChain = new String[certs.size()];
            e = certs.elements();
            i = 0;
            while (e.hasMoreElements()) {
                jceCert = (X509Certificate)e.nextElement();
                cert = Utilities.convertJCEX509CertificateToPhaosX509(jceCert);
                certChain[i] = s = Utilities.X509toBase64(cert);
                ++i;
            }
            sigProperties.put("CertificateChain", certChain);
        }
        if (this.verifierCertificateMapper != null) {
            certs = this.p7Signature.getCertificates();
            String[] certIDChain = new String[certs.size()];
            e = certs.elements();
            i = 0;
            while (e.hasMoreElements()) {
                jceCert = (X509Certificate)e.nextElement();
                cert = Utilities.convertJCEX509CertificateToPhaosX509(jceCert);
                s = Utilities.X509toBase64(cert);
                certIDChain[i] = this.verifierCertificateMapper.getIDByCertificate("X.509", s);
                ++i;
            }
            sigProperties.put("CertificateIDChain", certIDChain);
        }
        if (this.verifierSignerX509Cert != null) {
            try {
                CMSSignedDataContentInfo sdci = new CMSSignedDataContentInfo((CMSContentInfo)new CMSDataContentInfo());
                ByteArrayOutputStream baOS = new ByteArrayOutputStream();
                sdci.addSignerInfo(this.verifierSignerX509Cert, this.signerInfo);
                sdci.output((OutputStream)baOS);
                sigProperties.put("MinimalSignature", Utils.toBase64((byte[])baOS.toByteArray()));
            }
            catch (Exception e2) {
                throw new DigitalSignatureException("Cannot make minimal signature" + e2);
            }
        }
        return new SignatureProperties(sigProperties);
    }

    @Override
    public boolean finish() throws DigitalSignatureException {
        super.finish();
        try {
            TrustedCAPolicy trustCAPolicy = new TrustedCAPolicy(this.verifierTrustPoints, false, true);
            ByteArrayInputStream pkcs7InputStream = new ByteArrayInputStream(Utils.fromBase64((String)this.verifierSignature.toString()));
            this.p7Signature = new CMSSignedDataContentInfo((InputStream)pkcs7InputStream);
            if (!this.p7Signature.isDetached()) {
                this.verifierAttached = true;
            }
            this.verifierMode = 1;
            CMSDataContentInfo dci = this.verifierAttached ? null : new CMSDataContentInfo(this.verifierDocBuffer.toByteArray());
            this.signerInfo = (CMSSignerInfo)this.p7Signature.signers().nextElement();
            X500Name signerIssuer = this.signerInfo.getIssuer();
            BigInteger signerSerialNo = this.signerInfo.getSerialNo();
            Enumeration e = this.p7Signature.getCertificates().elements();
            while (e.hasMoreElements()) {
                X509Certificate jceCert = (X509Certificate)e.nextElement();
                X509 cert = Utilities.convertJCEX509CertificateToPhaosX509(jceCert);
                if (!cert.getIssuer().equals((Object)signerIssuer) || !cert.getSerialNo().equals(signerSerialNo)) continue;
                this.verifierSignerX509Cert = jceCert;
            }
            if (this.verifierSignerX509Cert == null) {
                throw new DigitalSignatureException("No signer certificate found");
            }
            if (this.verifierAttached) {
                this.p7Signature.verify((CertificateTrustPolicy)trustCAPolicy);
                byte[] docBytes = ((CMSDataContentInfo)this.p7Signature.getEnclosed()).getData();
                this.verifierDocBuffer.write(docBytes, 0, docBytes.length);
                this.verifierDocBuffer.flush();
            } else {
                this.p7Signature.verify((CertificateTrustPolicy)trustCAPolicy, (CMSContentInfo)dci);
            }
            this.verifierStatus = true;
        }
        catch (AuthenticationException aex) {
            this.verifierStatus = false;
            this.verifierErrorMessage = aex.toString();
        }
        catch (NoSuchElementException nsx) {
            throw new DigitalSignatureException("Internal Error - " + nsx);
        }
        catch (IOException iox) {
            throw new DigitalSignatureException("Internal Error - " + iox);
        }
        return this.verifierStatus;
    }
}

