/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.util.JDBCExtensionInterface;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class JDBCAdapter {
    private static JDBCExtensionInterface jdbcExtension = new DefaultJDBCExtension();

    private JDBCAdapter() {
    }

    public static void initialize(JDBCExtensionInterface jDBCExtensionInterface) {
        if (jDBCExtensionInterface == null) {
            return;
        }
        jdbcExtension = jDBCExtensionInterface;
    }

    public static OracleConnection getOracleConnection(Connection connection) throws SQLException {
        return jdbcExtension.getOracleConnection(connection);
    }

    public static void clearStatementCache(Connection connection) throws SQLException {
        jdbcExtension.clearStatementCache(connection);
    }

    public static JGeometry getJGeometry(Object object) throws SQLException {
        return jdbcExtension.getJGeometry(object);
    }

    public static Datum[] getOracleAttributes(Object object) throws SQLException {
        return jdbcExtension.getOracleAttributes(object);
    }

    public static StructDescriptor getStructDescriptor(Object object) throws SQLException {
        return jdbcExtension.getStructDescriptor(object);
    }

    public static Datum[] getOracleArray(Object object) throws SQLException {
        return jdbcExtension.getOracleArray(object);
    }

    public static ArrayDescriptor getArrayDescriptor(Object object) throws SQLException {
        return jdbcExtension.getArrayDescriptor(object);
    }

    private static class DefaultJDBCExtension
    implements JDBCExtensionInterface {
        private DefaultJDBCExtension() {
        }

        @Override
        public OracleConnection getOracleConnection(Connection connection) throws SQLException {
            if (connection == null) {
                throw new IllegalArgumentException();
            }
            return (OracleConnection)connection;
        }

        @Override
        public void clearStatementCache(Connection connection) throws SQLException {
        }

        @Override
        public JGeometry getJGeometry(Object object) throws SQLException {
            return JGeometry.load((STRUCT)((STRUCT)object));
        }

        @Override
        public Datum[] getOracleAttributes(Object object) throws SQLException {
            return ((STRUCT)object).getOracleAttributes();
        }

        @Override
        public StructDescriptor getStructDescriptor(Object object) throws SQLException {
            return ((STRUCT)object).getDescriptor();
        }

        @Override
        public Datum[] getOracleArray(Object object) throws SQLException {
            return ((ARRAY)object).getOracleArray();
        }

        @Override
        public ArrayDescriptor getArrayDescriptor(Object object) throws SQLException {
            return ((ARRAY)object).getDescriptor();
        }
    }
}

