/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import oracle.jdbc.xa.OracleMultiPhaseArgsJavavm;
import oracle.jdbc.xa.OracleXid;
import oracle.jdbc.xa.XANative;

public class OracleWrapXAResource {
    public static final int XA_OK = 0;
    public static final short DEFAULT_XATIMEOUT = 60;
    public static final int TMNOFLAGS = 0;
    public static final int TMENDRSCAN = 0x800000;
    public static final int TMFAIL = 0x20000000;
    public static final int TMJOIN = 0x200000;
    public static final int TMONEPHASE = 0x40000000;
    public static final int TMRESUME = 0x8000000;
    public static final int TMSTARTRSCAN = 0x1000000;
    public static final int TMSUCCESS = 0x4000000;
    public static final int TMSUSPEND = 0x2000000;
    private static final boolean DEBUG = false;
    private static boolean JTADebug = false;
    private static int[] appVal = new int[]{0};
    private static ByteArrayOutputStream byteArrayOS = null;

    public static byte[] start(byte[] xaid_bytes, int timeout, int flag, int[] status) {
        int returnVal = 0;
        OracleXid xid = (OracleXid)OracleWrapXAResource.deserializeObject(xaid_bytes);
        int formatId = xid.getFormatId();
        byte[] gtrid = xid.getGlobalTransactionId();
        byte[] bqual = xid.getBranchQualifier();
        if (gtrid == null && bqual == null) {
            gtrid = new byte[1];
            bqual = new byte[1];
        }
        status[0] = returnVal = XANative.start(formatId, gtrid, bqual, flag, (short)timeout);
        return null;
    }

    public static int start(int formatId, byte[] gtrid, byte[] bqual, int timeout, int flag) {
        int returnVal = 0;
        if (gtrid == null && bqual == null) {
            gtrid = new byte[1];
            bqual = new byte[1];
        }
        returnVal = XANative.start(formatId, gtrid, bqual, flag, (short)timeout);
        return returnVal;
    }

    public static int rollback(byte[] xaid_bytes, int[] stateOut) {
        int returnVal = 0;
        OracleXid xid = (OracleXid)OracleWrapXAResource.deserializeObject(xaid_bytes);
        int formatId = xid.getFormatId();
        byte[] gtrid = xid.getGlobalTransactionId();
        byte[] bqual = xid.getBranchQualifier();
        if (gtrid == null && bqual == null) {
            gtrid = new byte[1];
            bqual = new byte[1];
        }
        returnVal = XANative.rollback(formatId, gtrid, bqual, (short)0);
        return returnVal;
    }

    public static int rollback(int formatId, byte[] gtrid, byte[] bqual) {
        int returnVal = 0;
        if (gtrid == null && bqual == null) {
            gtrid = new byte[1];
            bqual = new byte[1];
        }
        returnVal = XANative.rollback(formatId, gtrid, bqual, (short)0);
        return returnVal;
    }

    public static int commit(byte[] xaid_bytes, int onePhase, int[] stateOut) {
        int returnVal = 0;
        int flag = 0;
        OracleXid xid = (OracleXid)OracleWrapXAResource.deserializeObject(xaid_bytes);
        int formatId = xid.getFormatId();
        byte[] gtrid = xid.getGlobalTransactionId();
        byte[] bqual = xid.getBranchQualifier();
        if (gtrid == null && bqual == null) {
            gtrid = new byte[1];
            bqual = new byte[1];
        }
        flag = onePhase == 1 ? 0x40000000 : 0;
        returnVal = XANative.commit(formatId, gtrid, bqual, flag, (short)0);
        return returnVal;
    }

    public static int commit(int formatId, byte[] gtrid, byte[] bqual, int onePhase) {
        int returnVal = 0;
        int flag = 0;
        if (gtrid == null && bqual == null) {
            gtrid = new byte[1];
            bqual = new byte[1];
        }
        flag = onePhase == 1 ? 0x40000000 : 0;
        returnVal = XANative.commit(formatId, gtrid, bqual, flag, (short)0);
        return returnVal;
    }

    public static int end(byte[] xaid_bytes, int flag) {
        int returnVal = 0;
        OracleXid xid = (OracleXid)OracleWrapXAResource.deserializeObject(xaid_bytes);
        int formatId = xid.getFormatId();
        byte[] gtrid = xid.getGlobalTransactionId();
        byte[] bqual = xid.getBranchQualifier();
        returnVal = XANative.end(formatId, gtrid, bqual, flag, (short)0);
        return returnVal;
    }

    public static int end(int formatId, byte[] gtrid, byte[] bqual, int flag) {
        int returnVal = 0;
        returnVal = XANative.end(formatId, gtrid, bqual, flag, (short)0);
        return returnVal;
    }

    public static int forget(byte[] xaid_bytes, int[] stateOut) {
        int returnVal = 0;
        OracleXid xid = (OracleXid)OracleWrapXAResource.deserializeObject(xaid_bytes);
        int formatId = xid.getFormatId();
        byte[] gtrid = xid.getGlobalTransactionId();
        byte[] bqual = xid.getBranchQualifier();
        System.out.println("OracleWrapXAResource.forget()-start");
        if (gtrid == null && bqual == null) {
            return -4;
        }
        returnVal = XANative.forget(formatId, gtrid, bqual, (short)0);
        System.out.println("OracleWrapXAResource.forget()-returnVal is " + returnVal);
        System.out.println("OracleWrapXAResource.forget()-end");
        return returnVal;
    }

    public static int forget(int formatId, byte[] gtrid, byte[] bqual) {
        int returnVal = 0;
        System.out.println("OracleWrapXAResource.forget()-start");
        if (gtrid == null && bqual == null) {
            return -4;
        }
        returnVal = XANative.forget(formatId, gtrid, bqual, (short)0);
        System.out.println("OracleWrapXAResource.forget()-returnVal is " + returnVal);
        System.out.println("OracleWrapXAResource.forget()-end");
        return returnVal;
    }

    public static int prepare(byte[] xaid_bytes, int[] stateOut) {
        OracleXid xid = (OracleXid)OracleWrapXAResource.deserializeObject(xaid_bytes);
        int formatId = xid.getFormatId();
        byte[] gtrid = xid.getGlobalTransactionId();
        byte[] bqual = xid.getBranchQualifier();
        if (gtrid == null && bqual == null) {
            return -4;
        }
        int returnVal = XANative.prepare(formatId, gtrid, bqual, (short)0);
        return returnVal;
    }

    public static int prepare(int formatId, byte[] gtrid, byte[] bqual) {
        if (gtrid == null && bqual == null) {
            return -4;
        }
        int returnVal = XANative.prepare(formatId, gtrid, bqual, (short)0);
        return returnVal;
    }

    public static Object deserializeObject(byte[] bytes) {
        Object obj = null;
        try {
            if (bytes == null) {
                return null;
            }
            ByteArrayInputStream istream = new ByteArrayInputStream(bytes);
            obj = new ObjectInputStream(istream).readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static int doTwoPhase(int isFinal, byte[] inBytes) {
        int retVal = -1;
        if (JTADebug) {
            System.out.println("OWXAR.doTwoPhase () - start");
            System.out.println("   isFinal = " + isFinal);
            System.out.println("   inByteslength = " + inBytes.length);
        }
        if (byteArrayOS == null) {
            byteArrayOS = new ByteArrayOutputStream();
        }
        try {
            byteArrayOS.write(inBytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (isFinal == 1) {
            retVal = OracleWrapXAResource.doTwoPhaseAction(byteArrayOS.toByteArray());
            byteArrayOS.reset();
        } else {
            retVal = 0;
        }
        if (JTADebug) {
            System.out.println("   retVal = " + retVal);
            System.out.println("OWXAR.doTwoPhase: end:");
        }
        return retVal;
    }

    private static int doTwoPhaseAction(byte[] inBytes) {
        OracleMultiPhaseArgsJavavm multiPhaseArgs;
        int retVal = -1;
        int action = 0;
        int nsites = 0;
        int[] fmtid = null;
        Object gtrid = null;
        Object bqual = null;
        String[] dbLinks = null;
        if (JTADebug) {
            System.out.println("OWXAR.doTwoPhase () - start");
            System.out.println("   inByteslength = " + inBytes.length);
        }
        if ((nsites = (multiPhaseArgs = new OracleMultiPhaseArgsJavavm(inBytes)).getnsite()) <= 1) {
            return retVal;
        }
        action = multiPhaseArgs.getAction();
        dbLinks = new String[nsites];
        fmtid = new int[nsites];
        gtrid = new byte[nsites][];
        bqual = new byte[nsites][];
        for (int i = 0; i < nsites; ++i) {
            dbLinks[i] = multiPhaseArgs.getdbLinks().elementAt(i).toString();
            Integer fmtInt = (Integer)multiPhaseArgs.getXids().elementAt(i * 3);
            fmtid[i] = fmtInt;
            gtrid[i] = (byte[])multiPhaseArgs.getXids().elementAt(i * 3 + 1);
            bqual[i] = (byte[])multiPhaseArgs.getXids().elementAt(i * 3 + 2);
        }
        if (JTADebug) {
            multiPhaseArgs.printMPArgs();
            System.out.println(" calling doMultiPhase-native method...");
        }
        retVal = XANative.doMultiPhase(action, nsites, fmtid, gtrid, bqual, dbLinks);
        if (JTADebug) {
            System.out.println("OWXAR.doTwoPhase ()-returnVal = " + retVal);
            System.out.println("OWXAR.doTwoPhase() - end");
        }
        return retVal;
    }

    private static void printByteArray(byte[] bArray) {
        for (int j = 0; j < bArray.length; ++j) {
            System.out.print(bArray[j] + " ");
        }
        System.out.println();
    }

    public static void setJTADebug(boolean b) {
        JTADebug = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int stepThinTwophase(byte[] inBytes) {
        int retValue = -1;
        CallableStatement cstmt = null;
        try {
            Connection conn = DriverManager.getConnection("jdbc:oracle:kprb:");
            cstmt = conn.prepareCall("begin ? := JAVA_XA.xa_doTwophase(?, ?); end; ");
            cstmt.registerOutParameter(1, 2);
            cstmt.setInt(2, 1);
            cstmt.setBytes(3, inBytes);
            cstmt.execute();
            retValue = cstmt.getInt(1);
        }
        catch (SQLException e) {
            retValue = e.getErrorCode();
            e.printStackTrace();
        }
        finally {
            try {
                if (cstmt != null) {
                    cstmt.close();
                }
            }
            catch (SQLException ea) {
                retValue = ea.getErrorCode();
                ea.printStackTrace();
            }
        }
        return retValue;
    }
}

