/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Trace {
    protected static final int SKIP_LINES = 2;
    protected int suppressionLevel;
    protected boolean fullStack;
    protected boolean giveThread;
    protected int counter;
    protected StringWriter straceSW;
    protected PrintWriter stracePW;
    protected PrintStream outStream;
    public static final int DEF_LEVEL = 1;
    public static final boolean DEF_FULLSTACK = false;
    public static final boolean DEF_GIVETHREAD = false;
    public static final int DEF_SUPP = 1;

    public Trace() {
        this(1, false, false);
    }

    public Trace(int suppress) {
        this(suppress, false, false);
    }

    public Trace(int suppress, boolean fullStack) {
        this(suppress, fullStack, false);
    }

    public Trace(int suppress, boolean fullStack, boolean giveThread) {
        this.suppressionLevel = suppress;
        this.fullStack = fullStack;
        this.giveThread = giveThread;
        this.counter = 0;
        this.straceSW = new StringWriter();
        this.stracePW = new PrintWriter(this.straceSW);
        this.outStream = System.out;
        this.trace("Trace instance created");
    }

    public final boolean wouldTrace() {
        return this.wouldTrace(1);
    }

    public final boolean wouldTrace(int level) {
        return level < this.suppressionLevel;
    }

    public PrintStream getOutputStream() {
        return this.outStream;
    }

    public PrintStream setOutputStream(PrintStream ps) {
        PrintStream result = this.outStream;
        this.outStream = ps;
        return result;
    }

    public void trace() {
        if (this.wouldTrace(1)) {
            this.doTrace(null, 1);
        }
    }

    public void trace(String msg) {
        if (this.wouldTrace(1)) {
            this.doTrace(msg, 1);
        }
    }

    public void trace(String msg, int level) {
        if (this.wouldTrace(level)) {
            this.doTrace(msg, level);
        }
    }

    public void doTrace(String msg) {
        this.doTrace(msg, 1);
    }

    public synchronized void doTrace(String msg, int level) {
        if (!this.wouldTrace(level)) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("\n" + this.counter++ + ":tr[" + level + "]");
        if (this.giveThread) {
            buf.append("[" + Thread.currentThread().getName() + ":" + Thread.activeCount() + "]");
        }
        if (msg != null) {
            buf.append(" - " + msg);
        }
        Throwable t = new Throwable();
        t.fillInStackTrace();
        t.printStackTrace(this.stracePW);
        this.stracePW.flush();
        String strace = this.straceSW.toString();
        this.straceSW.getBuffer().setLength(0);
        String ls = System.getProperty("line.separator");
        int start = 0;
        for (int i = 0; i < 2; ++i) {
            start = strace.indexOf(ls, start) + ls.length();
        }
        while (true) {
            int end = strace.indexOf(ls, start);
            int tag = strace.indexOf("oracle.aurora.util.Trace", start);
            if (tag == -1 || tag > end) break;
            start = end + ls.length();
        }
        buf.append("\n" + (this.fullStack ? strace.substring(start) : strace.substring(start, strace.indexOf(ls, start))) + "\n");
        this.outStream.println(buf.toString());
        this.outStream.flush();
    }

    public int getSuppressionLevel() {
        return this.suppressionLevel;
    }

    public void setSuppressionLevel(int lev) {
        this.suppressionLevel = lev;
    }

    public boolean getFullStack() {
        return this.fullStack;
    }

    public void setFullStack(boolean fs) {
        this.fullStack = fs;
    }

    public boolean getGiveThread() {
        return this.giveThread;
    }

    public void setGiveThread(boolean gt) {
        this.giveThread = gt;
    }

    public int getSkipLines() {
        return 0;
    }

    public int setSkipLines(int nVal) {
        return nVal;
    }
}

