/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

public class FixedLengthInputStream
extends FilterInputStream {
    protected int expect;
    protected int read;

    public FixedLengthInputStream(InputStream in, int expect) {
        super(in);
        this.expect = expect;
        this.read = 0;
    }

    public int available() throws IOException {
        return Math.min(this.expect - this.read, this.in.available());
    }

    public void close() {
    }

    public int read() throws IOException {
        int result = 0;
        try {
            result = this.read >= this.expect ? -1 : this.in.read();
        }
        catch (InterruptedIOException e) {
            this.handleTimeOut(e, 1L);
        }
        if (result != -1) {
            ++this.read;
        }
        return result;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int result = 0;
        try {
            result = this.read >= this.expect ? -1 : this.in.read(buf, off, Math.min(this.expect - this.read, len));
        }
        catch (InterruptedIOException e) {
            this.handleTimeOut(e, len);
        }
        if (result != -1) {
            this.read += result;
        }
        return result;
    }

    protected void handleTimeOut(InterruptedIOException e, long attempt) throws InterruptedIOException {
        System.out.println("\nSocket timeout! [expect: " + this.expect + ", read: " + this.read + ", attempt: " + attempt + "]");
        e.printStackTrace();
        e.fillInStackTrace();
        throw e;
    }

    public long skip(long len) throws IOException {
        long result = 0L;
        try {
            result = this.read >= this.expect ? 0L : this.in.skip(Math.min((long)(this.expect - this.read), len));
        }
        catch (InterruptedIOException e) {
            this.handleTimeOut(e, len);
        }
        this.read = (int)((long)this.read + result);
        return result;
    }
}

