/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import oracle.aurora.util.ErrorFormatter;
import oracle.aurora.util.LocalStringManagerImpl;

public class ErrorMessages
extends ErrorFormatter {
    private static LocalStringManagerImpl localStrings;

    public static void error(String msg) {
        ErrorMessages.printMessage(ErrorMessages.localStrings().getLocalString("utils.error", "ERROR"), msg);
    }

    public static void error(String msg, Throwable t) {
        ErrorMessages.printMessage(ErrorMessages.localStrings().getLocalString("utils.error", "ERROR"), msg);
        t.printStackTrace();
    }

    public static void fatalError(String msg, int exit_code) {
        ErrorMessages.printMessage(ErrorMessages.localStrings().getLocalString("utils.fatal", "UNRECOVERABLE ERROR"), msg);
        System.exit(exit_code);
    }

    public static void fatalError(String msg, Throwable t, int exit_code) {
        ErrorMessages.printMessage(ErrorMessages.localStrings().getLocalString("utils.fatal", "UNRECOVERABLE ERROR"), msg);
        t.printStackTrace();
        System.exit(exit_code);
    }

    protected static LocalStringManagerImpl localStrings() {
        if (localStrings == null) {
            localStrings = new LocalStringManagerImpl(ErrorMessages.class);
        }
        return localStrings;
    }

    public static void message(String msg) {
        ErrorMessages.printMessage(null, msg);
    }

    public static void setMessagePrefix(String prefix) {
        messagePrefix = prefix;
    }

    public static void warning(String msg) {
        ErrorMessages.printMessage(ErrorMessages.localStrings().getLocalString("utils.warning", "WARNING"), msg);
    }

    public static void warning(String msg, Throwable t) {
        ErrorMessages.printMessage(ErrorMessages.localStrings().getLocalString("utils.warning", "WARNING"), msg);
        t.printStackTrace();
    }
}

