/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class EchoInputStream
extends FilterInputStream {
    public OutputStream echo;
    public boolean writeEcho;

    public EchoInputStream(InputStream in, OutputStream echo) {
        super(in);
        this.echo = echo;
        this.writeEcho = true;
    }

    public int read() throws IOException {
        int val = this.in.read();
        if (this.writeEcho) {
            this.echo.write(val);
        }
        return val;
    }

    public int read(byte[] b) throws IOException {
        int val = this.in.read(b);
        if (this.writeEcho) {
            this.echo.write(b);
        }
        return val;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int val = this.in.read(b, off, len);
        if (this.writeEcho) {
            this.echo.write(b, off, len);
        }
        return val;
    }

    public void close() throws IOException {
        this.echo.flush();
        this.in.close();
        this.echo.close();
    }
}

