/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.io.IOException;
import java.io.OutputStream;

public class BufferedOutputStream
extends OutputStream {
    protected OutputStream out;
    protected byte[] buff;
    protected int offset;
    protected boolean closed;
    public static final int DEF_BUFF_SIZE = 2037;
    protected int wait = 0;

    public BufferedOutputStream(OutputStream str) {
        this(str, 2037);
    }

    public BufferedOutputStream(OutputStream str, int buffSize) {
        this.out = str;
        this.buff = new byte[buffSize];
        this.offset = 0;
        this.closed = false;
    }

    public int getBufferSize() {
        return this.buff.length;
    }

    public int setBufferSize(int size) {
        int result = this.buff.length;
        this.buff = new byte[size];
        return result;
    }

    public void write(int b) throws IOException {
        if (this.offset >= this.buff.length) {
            this.flush();
        }
        this.buff[this.offset++] = (byte)(b & 0xFF);
    }

    protected void busyWait(int msec) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < (long)msec) {
        }
    }

    public void setBusyWait(int msec) {
        this.wait = msec;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int toCopy;
        int space = this.buff.length - this.offset;
        if (len <= space) {
            System.arraycopy(b, off, this.buff, this.offset, len);
            this.offset += len;
            return;
        }
        System.arraycopy(b, off, this.buff, this.offset, space);
        this.offset += space;
        off += space;
        len -= space;
        do {
            this.flush();
            if (this.wait > 0) {
                this.busyWait(this.wait);
            }
            toCopy = Math.min(len, this.buff.length);
            System.arraycopy(b, off, this.buff, 0, toCopy);
            this.offset = toCopy;
            off += toCopy;
        } while ((len -= toCopy) > 0);
    }

    public void flush() throws IOException {
        this.out.write(this.buff, 0, this.offset);
        this.out.flush();
        this.offset = 0;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.flush();
        this.out.close();
        this.closed = true;
    }
}

