/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.io.PrintWriter;
import oracle.aurora.util.Assertion;
import oracle.aurora.util.BTProbe;
import oracle.aurora.util.BTree;
import oracle.aurora.util.BTreeLNode;
import oracle.aurora.util.BTreeNode;

class BTreeINode
extends BTreeNode {
    static final int BTOP_BALANCE_LEFT = 0;
    static final int BTOP_BALANCE_RIGHT = 1;
    static final int BTOP_SPLIT_LEFT = 2;
    static final int BTOP_SPLIT_RIGHT = 3;
    static final int BTOP_MERGE_LEFT = 4;
    static final int BTOP_MERGE_RIGHT = 5;

    public BTreeINode(BTree tree, BTreeINode parent, BTreeNode child) {
        super(tree, parent);
        this.slots = new Object[this.nSlots()];
        this.slots[0] = child;
        child.setParent(this);
    }

    void printOn(PrintWriter out, boolean recurse, int level) {
        out.println();
        BTreeINode.indentOn(out, level);
        out.print("INode: " + this.hashCode() + ", order: " + this.inodeOrder() + " ");
        super.printOn(out, recurse, level);
        BTreeINode.printOn(out, this.getLeftSubTree(0), true, level + 1);
        for (int i = 0; i < this.size; ++i) {
            this.printElementOn(out, i, level);
            BTreeINode.printOn(out, this.getRightSubTree(i), true, level + 1);
        }
        out.flush();
    }

    boolean isINode() {
        return true;
    }

    int order() {
        return this.inodeOrder();
    }

    protected int nSlots() {
        return this.inodeOrder() * 2 + 1;
    }

    boolean probe(Object obj, BTProbe probe) {
        probe.node = this;
        if (this.size < 9) {
            probe.index = 0;
            while (probe.index < this.size) {
                probe.comparison = this.tree.comparator.compare(obj, this.getElement(probe.index));
                if (probe.comparison < 0) {
                    return this.getLeftSubTree(probe.index).probe(obj, probe);
                }
                if (probe.comparison == 0) {
                    return true;
                }
                ++probe.index;
            }
            return this.getRightSubTree(this.size - 1).probe(obj, probe);
        }
        probe.index = 0;
        probe.comparison = this.tree.comparator.compare(obj, this.getElement(probe.index));
        if (probe.comparison > 0) {
            int lower = 0;
            probe.index = this.size - 1;
            probe.comparison = this.tree.comparator.compare(obj, this.getElement(probe.index));
            if (probe.comparison < 0) {
                int upper = this.size - 1;
                while (true) {
                    if (upper - lower <= 1) {
                        probe.index = upper;
                        probe.comparison = -1;
                        break;
                    }
                    probe.index = lower + (upper - lower) / 2;
                    probe.comparison = this.tree.comparator.compare(obj, this.getElement(probe.index));
                    if (probe.comparison > 0) {
                        lower = probe.index;
                        continue;
                    }
                    if (probe.comparison == 0) {
                        return true;
                    }
                    upper = probe.index;
                }
            }
        }
        return probe.comparison < 0 ? this.getLeftSubTree(probe.index).probe(obj, probe) : this.getRightSubTree(probe.index).probe(obj, probe);
    }

    BTreeNode getSubTree(int idx) {
        return (BTreeNode)this.slots[idx * 2];
    }

    void setSubTree(int idx, BTreeNode node) {
        this.slots[idx * 2] = node;
    }

    BTreeNode getLeftSubTree(int idx) {
        return (BTreeNode)this.slots[idx * 2];
    }

    void setLeftSubTree(int idx, BTreeNode node) {
        this.slots[idx * 2] = node;
    }

    BTreeNode getRightSubTree(int idx) {
        return (BTreeNode)this.slots[(idx + 1) * 2];
    }

    void setRightSubTree(int idx, BTreeNode node) {
        this.slots[(idx + 1) * 2] = node;
    }

    Object getElement(int idx) {
        return this.slots[idx * 2 + 1];
    }

    void setElement(int idx, Object obj) {
        this.slots[idx * 2 + 1] = obj;
    }

    void moveSubTree(BTreeNode src, int idx) {
        if (BTree.oassert.on()) {
            Assertion.oassert(idx <= this.size);
        }
        this.setSubTree(idx, src);
        src.setParent(this);
    }

    void _insert(int idx, int count, boolean left) {
        int i;
        if (BTree.oassert.on()) {
            Assertion.oassert(this.size + count <= this.inodeOrder() && idx >= 0 && idx <= this.size && count > 0);
        }
        int first = left ? idx * 2 : idx * 2 + 1;
        for (i = this.size * 2; i >= first; --i) {
            this.slots[i + 2 * count] = this.slots[i];
        }
        this.size = (short)(this.size + count);
        for (i = first; i < first + count * 2; ++i) {
            this.slots[i] = null;
        }
    }

    void _remove(int idx, int count, boolean left) {
        int first;
        int i;
        if (BTree.oassert.on()) {
            Assertion.oassert(this.size > 0 && idx >= 0 && idx + count - 1 < this.size && count > 0);
        }
        for (i = first = left ? (idx + count) * 2 : (idx + count) * 2 + 1; i <= this.size * 2; ++i) {
            this.slots[i - 2 * count] = this.slots[i];
        }
        this.size = (short)(this.size - count);
        for (i = this.size * 2 + 1; i <= (this.size + count) * 2; ++i) {
            this.slots[i] = null;
        }
    }

    void moveLeftSubTree(BTreeNode src, int idx) {
        this.moveSubTree(src, idx);
    }

    void moveRightSubTree(BTreeNode src, int idx) {
        this.moveSubTree(src, idx + 1);
    }

    void subTreeFull(BTreeNode node) {
        int index = this.indexOf(node);
        switch (this.pickFullOp(index)) {
            case 0: {
                this.getSubTree(index - 1).balanceWithRight(node, index - 1);
                return;
            }
            case 1: {
                node.balanceWithRight(this.getSubTree(index + 1), index);
                return;
            }
            case 2: {
                this.getSubTree(index - 1).splitWithRight(node, index - 1);
                return;
            }
            case 3: {
                node.splitWithRight(this.getSubTree(index + 1), index);
                return;
            }
        }
        Assertion.oassert(false);
    }

    int pickFullOp(int index) {
        BTreeNode left = null;
        BTreeNode right = null;
        int leftSpace = 0;
        int rightSpace = 0;
        if (index > 0) {
            left = this.getSubTree(index - 1);
            int n = leftSpace = left != null ? Math.max(0, this.inodeOrder() - left.size - 1) : 0;
        }
        if (index < this.size) {
            right = this.getSubTree(index + 1);
            int n = rightSpace = right != null ? Math.max(0, this.inodeOrder() - right.size - 1) : 0;
        }
        if (leftSpace > 0 && rightSpace > 0) {
            return leftSpace > rightSpace ? 0 : (leftSpace < rightSpace ? 1 : (this.tree.random() ? 0 : 1));
        }
        if (leftSpace > 0) {
            return 0;
        }
        if (rightSpace > 0) {
            return 1;
        }
        if (left != null && right != null) {
            return this.tree.random() ? 2 : 3;
        }
        if (left != null) {
            return 2;
        }
        if (right != null) {
            return 3;
        }
        Assertion.oassert(false);
        return 0;
    }

    void subTreeLow(BTreeNode node) {
        int index = this.indexOf(node);
        switch (this.pickLowOp(index)) {
            case 0: {
                this.getSubTree(index - 1).balanceWithRight(node, index - 1);
                return;
            }
            case 1: {
                node.balanceWithRight(this.getSubTree(index + 1), index);
                return;
            }
            case 4: {
                this.getSubTree(index - 1).mergeWithRight(node, index - 1);
                return;
            }
            case 5: {
                node.mergeWithRight(this.getSubTree(index + 1), index);
                return;
            }
        }
        Assertion.oassert(false);
    }

    int pickLowOp(int index) {
        BTreeNode left = null;
        BTreeNode right = null;
        if (index > 0) {
            left = this.getSubTree(index - 1);
        }
        if (index < this.size) {
            right = this.getSubTree(index + 1);
        }
        if (left != null && right == null || left != null && right != null && (left.size > right.size || left.size == right.size && this.tree.random())) {
            return left.size + this.getSubTree((int)index).size + 1 < left.order() ? 4 : 0;
        }
        return right.size + this.getSubTree((int)index).size + 1 < right.order() ? 5 : 1;
    }

    int indexOf(BTreeNode node) {
        for (int i = 0; i <= this.size; ++i) {
            if (this.getSubTree(i) != node) continue;
            return i;
        }
        Assertion.oassert(false);
        return 0;
    }

    void splitWithRight(BTreeNode r, int index) {
        if (BTree.oassert.on()) {
            Assertion.oassert(r.isINode() && this.parent.getLeftSubTree(index) == this && this.parent.getRightSubTree(index) == r);
        }
        BTreeINode rsib = (BTreeINode)r;
        int nSize = (this.size + rsib.size + 2) / 3;
        int moveThis = this.size - nSize;
        int moveSib = rsib.size - nSize;
        if (BTree.oassert.on()) {
            Assertion.oassert(moveThis + moveSib > 0);
        }
        moveThis = Math.max(1, moveThis);
        moveSib = Math.max(1, moveSib);
        BTreeINode newNode = new BTreeINode(this.tree, this.parent, rsib.getLeftSubTree(0));
        this.parent._insert(index + 1, 1, true);
        this.parent.moveSubTree(newNode, index + 1);
        this.parent.setElement(index + 1, rsib.getElement(0));
        rsib._remove(0, 1, true);
        if (moveThis > 0) {
            this.pushRight(moveThis, newNode, index);
        }
        if (moveSib > 1) {
            rsib.pushLeft(moveSib - 1, newNode, index + 1);
        }
        this.parent.checkIfFull();
    }

    void mergeWithRight(BTreeNode r, int index) {
        if (BTree.oassert.on()) {
            Assertion.oassert(r.isINode() && this.parent.getLeftSubTree(index) == this && this.parent.getRightSubTree(index) == r && this.size + r.size + 1 < this.inodeOrder());
        }
        BTreeINode rsib = (BTreeINode)r;
        if (this.size >= rsib.size) {
            if (rsib.size > 0) {
                rsib.pushLeft(rsib.size, this, index);
            }
            this._insert(this.size, 1, false);
            this.setElement(this.size - 1, this.parent.getElement(index));
            this.moveSubTree(rsib.getSubTree(0), this.size);
            this.parent._remove(index, 1, false);
            this.parent.checkIfLow();
        } else {
            if (this.size > 0) {
                this.pushRight(this.size, rsib, index);
            }
            rsib._insert(0, 1, true);
            rsib.setElement(0, this.parent.getElement(index));
            rsib.moveSubTree(this.getSubTree(0), 0);
            this.parent._remove(index, 1, true);
            this.parent.checkIfLow();
        }
    }

    void pushLeft(int toMove, BTreeNode l, int index) {
        if (BTree.oassert.on()) {
            Assertion.oassert(l.isINode() && this.parent.getRightSubTree(index) == this && this.parent.getLeftSubTree(index) == l && toMove > 0 && toMove <= this.size && toMove + l.size < this.inodeOrder());
        }
        BTreeINode lsib = (BTreeINode)l;
        short lss = lsib.size;
        lsib._insert(lsib.size, toMove, false);
        lsib.setElement(lss, this.parent.getElement(index));
        for (int i = 0; i < toMove; ++i) {
            lsib.moveRightSubTree(this.getLeftSubTree(i), lss + i);
            if (i >= toMove - 1) continue;
            lsib.setElement(lss + i + 1, this.getElement(i));
        }
        this.parent.setElement(index, this.getElement(toMove - 1));
        this._remove(0, toMove, true);
    }

    void pushRight(int toMove, BTreeNode r, int index) {
        if (BTree.oassert.on()) {
            Assertion.oassert(r.isINode() && this.parent.getLeftSubTree(index) == this && this.parent.getRightSubTree(index) == r && toMove > 0 && toMove <= this.size && toMove + r.size < this.inodeOrder());
        }
        BTreeINode rsib = (BTreeINode)r;
        rsib._insert(0, toMove, true);
        rsib.setElement(toMove - 1, this.parent.getElement(index));
        for (int i = 0; i < toMove; ++i) {
            rsib.moveLeftSubTree(this.getRightSubTree(this.size - i - 1), toMove - i - 1);
            if (i >= toMove - 1) continue;
            rsib.setElement(toMove - i - 2, this.getElement(this.size - i - 1));
        }
        this.parent.setElement(index, this.getElement(this.size - toMove));
        this._remove(this.size - toMove, toMove, false);
    }

    void split() {
        if (BTree.oassert.on()) {
            Assertion.oassert(this.isFull() && this.parent.size == 0 && this.parent.indexOf(this) == 0);
        }
        BTreeINode newNode = new BTreeINode(this.tree, this.parent, this.getRightSubTree(this.size - 1));
        this.parent._insert(0, 1, false);
        this.parent.setElement(0, this.getElement(this.size - 1));
        this.parent.moveSubTree(newNode, 1);
        this._remove(this.size - 1, 1, false);
        this.balanceWithRight(newNode, 0);
    }

    void removeElement(int index) {
        if (BTree.oassert.on()) {
            Assertion.oassert(index < this.size);
        }
        BTreeLNode left = this.getLeftSubTree(index).lastLeaf();
        BTreeLNode right = this.getRightSubTree(index).firstLeaf();
        if (left.size > right.size || left.size == right.size && this.tree.random()) {
            this.setElement(index, left.getElement(left.size - 1));
            left.remove(left.size - 1);
        } else {
            this.setElement(index, right.getElement(0));
            right.remove(0);
        }
    }

    int totalSize() {
        int result = this.size;
        for (int i = 0; i <= this.size; ++i) {
            result += this.getSubTree(i).totalSize();
        }
        return result;
    }

    int totalCapacity() {
        int result = this.inodeOrder();
        for (int i = 0; i <= this.size; ++i) {
            result += this.getSubTree(i).totalCapacity();
        }
        return result;
    }

    void rootLow() {
        if (BTree.oassert.on()) {
            Assertion.oassert(this.tree.root == this && this.getSubTree(0) != null);
        }
        if (this.size == 0) {
            this.tree.setRoot(this.getSubTree(0));
            this.getSubTree(0).setParent(null);
        }
    }

    BTreeLNode firstLeaf() {
        if (BTree.oassert.on()) {
            Assertion.oassert(this.getLeftSubTree(0) != null);
        }
        return this.getLeftSubTree(0).firstLeaf();
    }

    BTreeLNode lastLeaf() {
        if (BTree.oassert.on()) {
            Assertion.oassert(this.getRightSubTree(this.size - 1) != null);
        }
        return this.getRightSubTree(this.size - 1).lastLeaf();
    }

    Object insert(Object obj, BTProbe probe) {
        if (BTree.oassert.on()) {
            Assertion.oassert(this.size > 0 && probe.index < this.size && probe.comparison == this.tree.comparator.compare(obj, this.getElement(probe.index)) && probe.comparison != 0);
        }
        BTreeLNode leftLeaf = this.getLeftSubTree(probe.index).lastLeaf();
        BTreeLNode rightLeaf = this.getRightSubTree(probe.index).firstLeaf();
        if (probe.comparison < 0 || leftLeaf.size < rightLeaf.size || leftLeaf.size == rightLeaf.size && this.tree.random()) {
            leftLeaf.insert(obj, leftLeaf.size);
            leftLeaf.checkIfFull();
        } else {
            rightLeaf.insert(obj, 0);
            rightLeaf.checkIfFull();
        }
        return obj;
    }

    boolean findNext(BTProbe probe) {
        if (BTree.oassert.on()) {
            Assertion.oassert(probe.index < this.size);
        }
        probe.node = this.getRightSubTree(probe.index).firstLeaf();
        probe.index = 0;
        return true;
    }

    boolean findPrev(BTProbe probe) {
        if (BTree.oassert.on()) {
            Assertion.oassert(probe.index < this.size);
        }
        probe.node = this.getLeftSubTree(probe.index).lastLeaf();
        probe.index = probe.node.size - 1;
        return true;
    }

    void checkIntegrity(BTreeINode par) {
        super.checkIntegrity(par);
        for (int i = 0; i <= this.size; ++i) {
            for (int j = i + 1; j <= this.size; ++j) {
                Assertion.oassert(this.getSubTree(i) != this.getSubTree(j));
            }
            this.getSubTree(i).checkIntegrity(this);
        }
    }
}

