/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.util.NoSuchElementException;
import oracle.aurora.util.BTProbe;
import oracle.aurora.util.BTree;
import oracle.aurora.util.BTreeNode;
import oracle.aurora.util.BiDirectionalCursor;

public class BTreeCursor
extends BTProbe
implements BiDirectionalCursor {
    protected BTree tree;
    protected Object first;
    protected Object last;
    protected int status;
    protected int tIndex;
    protected static final int statStart = 0;
    protected static final int statValid = 1;
    protected static final int statEnd = 2;

    public BTreeCursor(BTree tree) {
        this(tree, null, null);
    }

    public BTreeCursor(BTree tree, Object first) {
        this(tree, first, null);
    }

    public BTreeCursor(BTree tree, Object first, Object last) {
        this.tree = tree;
        this.first = first;
        this.last = last;
        this.reset();
    }

    public void reset() {
        this.tIndex = -1;
        this.status = 0;
        if (this.first != null) {
            this.tree.root.probe(this.first, this);
        } else {
            this.node = this.tree.root.firstLeaf();
            this.index = 0;
        }
    }

    public void reset(BTree tree, Object first, Object last) {
        this.tree = tree;
        this.first = first;
        this.last = last;
        this.reset();
    }

    protected boolean valid() {
        return !(this.node == null || this.node.size <= 0 || this.last != null && this.comparison < 0 || this.first != null && this.comparison > 0);
    }

    public boolean next() {
        switch (this.status) {
            case 0: {
                this.tIndex = 0;
                if (this.valid()) {
                    this.status = 1;
                    return true;
                }
                this.status = 2;
                return false;
            }
            case 1: {
                ++this.tIndex;
                BTreeNode oNode = this.node;
                int oIndex = this.index;
                this.node.findNext(this);
                if (this.node != null && this.last != null) {
                    this.comparison = this.tree.comparator.compare(this.last, this.node.getElement(this.index));
                }
                if (this.valid()) {
                    return true;
                }
                this.node = oNode;
                this.index = oIndex;
                this.status = 2;
                return false;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    public boolean previous() {
        switch (this.status) {
            case 0: {
                return false;
            }
            case 1: {
                --this.tIndex;
                BTreeNode oNode = this.node;
                int oIndex = this.index;
                this.node.findPrev(this);
                if (this.node != null && this.first != null) {
                    this.comparison = this.tree.comparator.compare(this.first, this.node.getElement(this.index));
                }
                if (this.valid()) {
                    return true;
                }
                this.node = oNode;
                this.index = oIndex;
                this.status = 0;
                return false;
            }
            case 2: {
                --this.tIndex;
                if (this.valid()) {
                    this.status = 1;
                    return true;
                }
                this.status = 0;
                return false;
            }
        }
        return false;
    }

    public Object get() {
        if (this.status != 1) {
            throw new NoSuchElementException("No current element, cursor is " + (this.status == 0 ? "before start" : "after end"));
        }
        return this.node.getElement(this.index);
    }

    public int getIndex() {
        return this.tIndex;
    }
}

