/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import oracle.aurora.server.tools.loadjava.MkMsg;
import oracle.aurora.server.tools.loadjava.Options;
import oracle.aurora.server.tools.loadjava.ToolsException;
import oracle.aurora.util.msg.Msg;
import oracle.jdbc.driver.OracleDriver;

public class DatabaseOptions {
    static Msg mkMsg = MkMsg.mkMsg;
    String driver;
    String user;
    String password;
    String database;
    boolean isDefault;

    public DatabaseOptions() {
        this.reset();
    }

    void reset() {
        this.driver = null;
        this.user = null;
        this.password = null;
        this.database = null;
        this.isDefault = true;
    }

    public Connection connect() throws SQLException, ToolsException {
        DriverManager.registerDriver((Driver)new OracleDriver());
        Connection conn = null;
        try {
            if (this.driver.equals("oci8")) {
                try {
                    String oci8DB = this.database == null ? "@" : "@" + this.database;
                    conn = this.getConnection("jdbc:oracle:oci8:" + oci8DB, this.user, this.password);
                }
                catch (UnsatisfiedLinkError e) {
                    this.err(mkMsg.m("The JDBC OCI8 Driver is not installed properly, use -thin to try the JDBC Thin driver: {0}", e.getMessage()));
                }
            } else if (this.driver.equals("kprb")) {
                String connString = "jdbc:oracle:kprb:@";
                conn = DriverManager.getConnection(connString);
            } else {
                String thinDB = this.database == null ? "" : "@" + this.database;
                conn = this.getConnection("jdbc:oracle:thin:" + thinDB, this.user, this.password);
            }
        }
        catch (SQLException e) {
            String dbName = this.database == null ? "default database" : String.valueOf(this.database);
            this.err(mkMsg.m("SQL Error while connecting with {1} driver to {2}: {0}", e.getMessage(), this.driver, dbName));
        }
        catch (Exception e) {
            String dbName = this.database == null ? "default database" : String.valueOf(this.database);
            this.err(mkMsg.m("Error while connecting with {1} driver to {2}: {0}", e.toString(), this.driver, dbName));
        }
        conn.setAutoCommit(false);
        return conn;
    }

    private Connection getConnection(String db, String user, String password) throws SQLException {
        Properties up = new Properties();
        up.put("user", user);
        up.put("password", password);
        if (user.toUpperCase().equals("SYS") || user.toUpperCase().equals("INTERNAL")) {
            up.put("internal_logon", "sysdba");
        }
        return DriverManager.getConnection(db, up);
    }

    void dumpArgs() {
        System.out.println("driver = " + this.driver);
        System.out.println("user = " + this.user);
        System.out.println("password = " + this.password);
        System.out.println("database = " + this.database);
    }

    public String[] parseArgs(String[] argv) throws ToolsException {
        Options.Args args = new Options.Args(argv);
        this.parseArgs(args);
        return args.unused();
    }

    public void parseArgs(Options.Args args) throws ToolsException {
        String[] argv = args.argv();
        Vector argsLeft = new Vector();
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-thin") || argv[i].equals("-t")) {
                this.driver = "thin";
                args.markUsed(i);
                continue;
            }
            if (argv[i].equals("-oci8") || argv[i].equals("-o") || argv[i].equals("-oci")) {
                this.driver = "oci8";
                args.markUsed(i);
                continue;
            }
            if (argv[i].equals("-kprb")) {
                this.driver = "kprb";
                args.markUsed(i);
                continue;
            }
            if (argv[i].equals("-user") || argv[i].equals("-u")) {
                args.markUsed(i, i + 2);
                if (++i == argv.length) {
                    this.err(mkMsg.m("Missing user name after -user"));
                }
                this.tryFullDBString(argv[i]);
                continue;
            }
            if (argv[i].equals("-password") || argv[i].equals("-P")) {
                args.markUsed(i, i + 2);
                if (++i == argv.length) {
                    this.err(mkMsg.m("Missing password name after -password"));
                }
                this.password = argv[i];
                continue;
            }
            if (argv[i].equals("-database")) {
                args.markUsed(i, i + 2);
                if (++i == argv.length) {
                    this.err(mkMsg.m("Missing database connect string after -database"));
                }
                this.database = argv[i];
                continue;
            }
            if (argv[i].startsWith("@")) {
                args.markUsed(i);
                this.tryFullDBString(argv[i]);
                continue;
            }
            if (!argv[i].startsWith("-P")) continue;
            args.markUsed(i);
            this.tryFullDBString(argv[i].substring(2));
        }
        boolean bl = this.isDefault = this.driver == null && this.user == null && this.password == null && this.database == null;
        if (this.user != null && this.password == null) {
            if (System.getProperty("oracle.jserver.version") == null) {
                this.promptForPassword();
            } else {
                this.password = "";
            }
        } else if (this.user == null) {
            this.user = "SYS";
            this.password = "oracle";
        }
        if (this.driver == null) {
            this.driver = System.getProperty("oracle.jserver.version") == null ? "oci8" : "kprb";
        }
    }

    public boolean optionsSupplied() {
        return !this.isDefault;
    }

    public boolean isParseArg(String arg) {
        return arg.equals("-thin") || arg.equals("-t") || arg.equals("-oci8") || arg.equals("-oci") || arg.equals("-o") || arg.equals("-kprb") || arg.equals("-user") || arg.equals("-u") || arg.equals("-password") || arg.equals("-P") || arg.equals("-database") || arg.equals("-d");
    }

    void tryFullDBString(String dbString) throws ToolsException {
        int user_start = 0;
        int user_end = 0;
        int password_start = 0;
        int password_end = 0;
        int database_start = 0;
        int database_end = 0;
        int slash_index = dbString.indexOf("/");
        int at_index = dbString.indexOf("@");
        if (slash_index != -1 && at_index != -1 && slash_index > at_index) {
            this.err(mkMsg.m("Database argument must be of the form <user>/<password>@<database>: {0}", dbString));
        }
        user_start = 0;
        user_end = slash_index != -1 ? slash_index : (at_index != -1 ? at_index : dbString.length());
        if (slash_index != -1) {
            password_start = slash_index + 1;
            password_end = at_index == -1 ? dbString.length() : at_index;
        }
        if (at_index != -1) {
            database_start = at_index + 1;
            database_end = dbString.length();
        }
        this.user = dbString.substring(user_start, user_end);
        if (slash_index != -1) {
            this.password = dbString.substring(password_start, password_end);
        }
        if (at_index != -1) {
            this.database = dbString.substring(database_start, database_end);
        }
    }

    void err(String msg) throws ToolsException {
        throw new ToolsException(msg);
    }

    public String toString() {
        return "{driver=" + this.driver + ", user=" + this.user + ", database=" + this.database + "}";
    }

    public String getDriver() {
        return this.driver;
    }

    void promptForPassword() {
        HidePasswordFromCommandLine hideThread = new HidePasswordFromCommandLine();
        hideThread.start();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("\nPassword:");
        System.out.print(" ");
        hideThread.hideInput = true;
        try {
            this.password = in.readLine();
            hideThread.stopThread = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.print("\b \b");
    }

    class HidePasswordFromCommandLine
    extends Thread {
        boolean stopThread = false;
        boolean hideInput = false;
        boolean shortMomentGone = false;

        HidePasswordFromCommandLine() {
        }

        public void run() {
            try {
                HidePasswordFromCommandLine.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.shortMomentGone = true;
            while (!this.stopThread) {
                if (this.hideInput) {
                    System.out.print("\b*");
                }
                try {
                    HidePasswordFromCommandLine.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

