/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms.security;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import oracle.aurora.rdbms.security.PolicyTable;
import oracle.aurora.rdbms.security.TypePermissions;
import oracle.aurora.vm.Id;

class SchemaPermissions
extends PermissionCollection {
    Map typeCache;
    Id schema;
    PolicyTable table;

    SchemaPermissions(PolicyTable table, Id schema) {
        this.table = table;
        this.schema = schema;
        this.typeCache = new HashMap();
        this.setReadOnly();
    }

    public void add(Permission permission) {
    }

    public Enumeration elements() {
        Class permClass = PolicyTable.jsPermissionClass;
        TypePermissions allPermissions = (TypePermissions)this.typeCache.get(permClass);
        if (allPermissions == null) {
            Permissions collection = new Permissions();
            allPermissions = new TypePermissions(this.table, this.schema, permClass, collection);
            this.typeCache.put(permClass, allPermissions);
        }
        return allPermissions.elements();
    }

    public boolean implies(Permission implicand) {
        boolean result = this.getTypePermissionsFor(implicand).implies(implicand);
        return result;
    }

    synchronized TypePermissions getTypePermissionsFor(Permission implicand) {
        Class<?> pClass = implicand.getClass();
        TypePermissions typePermissions = (TypePermissions)this.typeCache.get(pClass);
        if (typePermissions == null) {
            PermissionCollection collection = implicand.newPermissionCollection();
            if (collection == null) {
                collection = new Permissions();
            }
            typePermissions = new TypePermissions(this.table, this.schema, pClass, collection);
            this.typeCache.put(pClass, typePermissions);
        }
        return typePermissions;
    }

    public String toString() {
        return "SchemaPermissions:" + this.schema;
    }
}

