/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms.security;

import java.security.Permission;
import java.security.PermissionCollection;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.rdbms.security.SchemaPermission;
import oracle.aurora.security.JServerPermission;

public class SchemaJServerPermission
extends JServerPermission
implements SchemaPermission {
    private String base;
    private String target;
    private String actions;
    private boolean allActions;
    private Permission targetPermission;

    protected SchemaJServerPermission(String base, String target, String actions) {
        super(base + "." + SchemaJServerPermission.adjustedTarget(base, target));
        this.base = base;
        this.target = SchemaJServerPermission.adjustedTarget(base, target);
        this.targetPermission = new JServerPermission(this.target);
        this.actions = actions;
        this.allActions = actions != null && actions.equals("*");
    }

    private static String adjustedTarget(String base, String target) {
        if (target.startsWith(base + ".")) {
            target = target.substring(base.length() + 1);
        }
        return target;
    }

    public boolean equals(Permission other) {
        boolean result = false;
        if (other instanceof SchemaJServerPermission) {
            SchemaJServerPermission otherP = (SchemaJServerPermission)((Object)other);
            result = this.base.equals(otherP.base) && this.target.equals(otherP.target);
        }
        return result;
    }

    public String getActions() {
        return "";
    }

    public int hashCode() {
        return this.base.hashCode() + this.target.hashCode();
    }

    public boolean implies(Permission other) {
        boolean result = false;
        if (other instanceof SchemaJServerPermission) {
            result = this.implies((SchemaJServerPermission)((Object)other));
        }
        return result;
    }

    public boolean implies(SchemaJServerPermission other) {
        boolean ok = true;
        if (ok) {
            ok = this.base.equals(other.base);
        }
        if (ok) {
            ok = this.targetPermission.implies(other.targetPermission);
        }
        if (ok && other.actions == null) {
            boolean bl = ok = this.actions == null;
        }
        if (ok && other.actions != null && !this.allActions) {
            ok = this.actions != null && this.actions.indexOf(other.actions) >= 0;
        }
        return ok;
    }

    public PermissionCollection getPermissionFor(Schema schema) {
        PermissionCollection collection = this.newPermissionCollection();
        collection.add((Permission)((Object)new SchemaJServerPermission(this.base, schema.toString() + ".*", this.actions)));
        return collection;
    }
}

