/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.cert.Certificate;
import oracle.aurora.rdbms.DbmsJava;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.vm.Id;

class SchemaCodeSource
extends CodeSource
implements Serializable {
    private transient Schema schema;
    private transient Id user;

    SchemaCodeSource(Schema schema) {
        super(null, (Certificate[])null);
        this.schema = schema;
    }

    private static URL jarURL(Schema schema, Class clazz) {
        try {
            String jarName = DbmsJava.longName(DbmsJava.jarName(clazz));
            return jarName == null ? null : new URL("jserver:/jar/schema/" + schema.toString() + "/" + jarName);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    SchemaCodeSource(Schema schema, Class clazz) {
        super(SchemaCodeSource.jarURL(schema, clazz), (Certificate[])null);
        this.schema = schema;
    }

    public int hashCode() {
        return this.schema.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SchemaCodeSource)) {
            return false;
        }
        return this.schema.equals(((SchemaCodeSource)obj).schema);
    }

    public boolean implies(CodeSource codeSource) {
        return this.equals(codeSource);
    }

    public String toString() {
        return this.schema.toString();
    }

    private synchronized void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeUTF(this.schema.toString());
    }

    private synchronized void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        String name = ois.readUTF();
        this.schema = Schema.lookup(name);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Id getUser() {
        return this.schema.getId();
    }
}

