/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms.security;

import java.security.Permission;
import sun.reflect.Reflection;

public class PolicyTablePermission
extends Permission {
    static final Class theClass = Reflection.getCallerClass((int)1);
    String type;
    Component pName;
    boolean all;

    public PolicyTablePermission(String name) {
        super(name);
        int xHash = name.indexOf("#");
        if (name.equals("*")) {
            this.all = true;
            this.type = "*";
            this.pName = new Component("*");
        } else if (xHash >= 0) {
            this.type = name.substring(0, xHash);
            this.pName = new Component(name.substring(xHash + 1));
        }
    }

    public String toString() {
        return "PolicyTablePermission(" + this.type + "#" + this.pName + ")";
    }

    public boolean implies(Permission implicand) {
        boolean ok = false;
        if (implicand instanceof PolicyTablePermission) {
            ok = this.implies((PolicyTablePermission)implicand);
        }
        return ok;
    }

    public String getActions() {
        return null;
    }

    public int hashCode() {
        return this.type.hashCode() + this.pName.hashCode();
    }

    public boolean equals(Object rhs) {
        boolean ok = false;
        if (rhs instanceof PolicyTablePermission) {
            PolicyTablePermission rhsP = (PolicyTablePermission)rhs;
            ok = this.all == rhsP.all && this.type.equals(rhsP.type) && this.pName.equals(rhsP.pName);
        }
        return ok;
    }

    boolean implies(PolicyTablePermission implicand) {
        boolean result = this.all ? true : this.type.equals(implicand.type) && this.pName.implies(implicand.pName);
        return result;
    }

    static class Component {
        String constant;
        boolean star;

        Component(String str) {
            if (str.length() > 0 && str.endsWith("*")) {
                this.constant = str.substring(0, str.length() - 1);
                this.star = true;
            } else {
                this.constant = str;
                this.star = false;
            }
        }

        boolean implies(Component other) {
            boolean prefix = other.constant.startsWith(this.constant);
            boolean eq = other.constant.equals(this.constant);
            return prefix && this.star || eq && this.star == other.star;
        }

        public String toString() {
            return this.constant + (this.star ? "*" : "");
        }

        public int hashCode() {
            return this.constant.hashCode() + (this.star ? 1 : 0);
        }

        public boolean equals(Object rhs) {
            boolean result = false;
            if (rhs instanceof Component) {
                Component rhsP = (Component)rhs;
                result = this.constant.equals(rhsP.constant) && this.star == rhsP.star;
            }
            return result;
        }
    }
}

