/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms.security;

import java.util.Iterator;
import java.util.NoSuchElementException;
import oracle.aurora.rdbms.security.RowInCache;

class FilteredCacheRowsIterator
implements Iterator {
    private Iterator remainingRows;
    private long schemaNumber;
    private Class permissionClass;
    private RowInCache nextRow;

    FilteredCacheRowsIterator(Iterator rows, long number, Class permissionClass) {
        this.remainingRows = rows;
        this.schemaNumber = number;
        this.permissionClass = permissionClass;
    }

    public boolean hasNext() {
        while (this.remainingRows.hasNext() && this.nextRow == null) {
            RowInCache row = (RowInCache)this.remainingRows.next();
            if (row.schema != this.schemaNumber || !this.permissionClass.isAssignableFrom(row.permissionClass())) continue;
            this.nextRow = row;
        }
        return this.nextRow != null;
    }

    public Object next() {
        this.hasNext();
        if (this.nextRow == null) {
            throw new NoSuchElementException();
        }
        RowInCache n = this.nextRow;
        this.nextRow = null;
        return n;
    }

    public void remove() {
        throw new UnsupportedOperationException("RowInCache.FilterRow.remove");
    }
}

